/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.web.config;

import eu.europeana.corelib.db.wrapper.ApiMongoConnector;
import org.mongodb.morphia.Datastore;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:annotation.properties", "classpath:annotation.user.properties"}, ignoreResourceNotFound=true)
public class MongoConfig {
    @Value(value="${mongodb.annotation.connectionUrl:}")
    private String mongoConnectionUrl;
    @Value(value="${mongodb.annotation.truststore:}")
    private String mongoTrustStore;
    @Value(value="${mongodb.annotation.truststorepass:}")
    private String mongoTrustStorePass;
    private static final String MODEL_PACKAGE = "eu.europeana.annotation.definitions";
    private ApiMongoConnector mongoConnector;

    @Bean(value={"annotation_db_morphia_datastore_annotation"})
    public Datastore createDataStore() {
        return this.getMongoConnector().createDatastore(this.mongoConnectionUrl, this.mongoTrustStore, this.mongoTrustStorePass, -1, new String[]{MODEL_PACKAGE});
    }

    @Bean(value={"annotationMongoConnector"})
    protected ApiMongoConnector getMongoConnector() {
        if (this.mongoConnector == null) {
            this.mongoConnector = new ApiMongoConnector();
        }
        return this.mongoConnector;
    }
}

