/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation;

import eu.europeana.annotation.web.config.SocksProxyActivator;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.metrics.mongo.MongoMetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.web.embedded.EmbeddedWebServerFactoryCustomizerAutoConfiguration;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ImportResource;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(scanBasePackages={"eu.europeana.annotation"}, exclude={SecurityAutoConfiguration.class, EmbeddedMongoAutoConfiguration.class, EmbeddedWebServerFactoryCustomizerAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, MongoMetricsAutoConfiguration.class, ManagementWebSecurityAutoConfiguration.class, DataSourceAutoConfiguration.class})
@ImportResource(value={"classpath:annotation-web-context.xml"})
public class AnnotationApp
extends SpringBootServletInitializer {
    private static final Logger logger = LogManager.getLogger(AnnotationApp.class);

    public static void main(String[] args) {
        logger.info("CF_INSTANCE_INDEX  = {}, CF_INSTANCE_GUID = {}, CF_INSTANCE_IP  = {}", (Object)System.getenv("CF_INSTANCE_INDEX"), (Object)System.getenv("CF_INSTANCE_GUID"), (Object)System.getenv("CF_INSTANCE_IP"));
        String propertiesFileName = AnnotationApp.getUserPropertiesFileName((String[])args);
        SocksProxyActivator.activate((String)propertiesFileName);
        ConfigurableApplicationContext ctx = SpringApplication.run(AnnotationApp.class, (String[])args);
        if (logger.isDebugEnabled()) {
            AnnotationApp.printRegisteredBeans((ApplicationContext)ctx);
        }
    }

    private static String getUserPropertiesFileName(String[] args) {
        String propertiesFileName = "annotation.user.properties";
        String ADITIONAL_CONFIG_REFIX = "--spring.config.additional-location=";
        if (args != null) {
            for (String config : args) {
                if (!config.startsWith(ADITIONAL_CONFIG_REFIX)) continue;
                propertiesFileName = config.substring(ADITIONAL_CONFIG_REFIX.length());
                propertiesFileName = propertiesFileName.replaceFirst("optional\\:", "");
                propertiesFileName = propertiesFileName.replaceFirst("file\\:", "");
            }
        }
        return propertiesFileName;
    }

    private static void printRegisteredBeans(ApplicationContext ctx) {
        Object[] beanNames = ctx.getBeanDefinitionNames();
        Arrays.sort(beanNames);
        logger.debug("Instantiated beans:");
        logger.debug(StringUtils.join((Object[])beanNames, (String)"\n"));
    }
}

