/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.solr.service.impl;

import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.body.Body;
import eu.europeana.annotation.definitions.model.body.GraphBody;
import eu.europeana.annotation.definitions.model.moderation.Summary;
import eu.europeana.annotation.definitions.model.resource.SpecificResource;
import eu.europeana.annotation.definitions.model.search.Query;
import eu.europeana.annotation.definitions.model.search.result.ResultSet;
import eu.europeana.annotation.definitions.model.target.Target;
import eu.europeana.annotation.definitions.model.view.AnnotationView;
import eu.europeana.annotation.definitions.model.vocabulary.BodyInternalTypes;
import eu.europeana.annotation.solr.model.internal.SolrAnnotation;
import eu.europeana.annotation.solr.model.internal.SolrAnnotationImpl;
import eu.europeana.annotation.solr.model.view.AnnotationViewAdapter;
import eu.europeana.annotation.solr.model.view.FacetFieldAdapter;
import eu.europeana.annotation.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;

public class SolrAnnotationUtils {
    private final Logger logger = LogManager.getLogger(this.getClass());

    public Logger getLogger() {
        return this.logger;
    }

    protected SolrQuery toSolrQuery(Query searchQuery) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(searchQuery.getQuery());
        if (searchQuery.getFilters() != null) {
            solrQuery.addFilterQuery(searchQuery.getFilters());
        }
        if (searchQuery.getFacetFields() != null) {
            solrQuery.setFacet(true);
            solrQuery.addFacetField(searchQuery.getFacetFields());
            solrQuery.setFacetMinCount(1);
            solrQuery.setFacetLimit(100);
        }
        if (searchQuery.getSort() != null) {
            solrQuery.setSort(searchQuery.getSort(), SolrQuery.ORDER.valueOf((String)searchQuery.getSortOrder()));
        }
        solrQuery.setFields(searchQuery.getViewFields());
        int solrPageNr = searchQuery.getPageNr() - 1;
        solrQuery.setStart(Integer.valueOf(solrPageNr * searchQuery.getPageSize()));
        solrQuery.setRows(Integer.valueOf(searchQuery.getPageSize()));
        return solrQuery;
    }

    public SolrAnnotation copyIntoSolrAnnotation(Annotation annotation, Summary summary, String annoBaseUri) {
        SolrAnnotationImpl solrAnnotationImpl = new SolrAnnotationImpl(annotation, summary, annoBaseUri);
        this.processSolrBeanProperties(solrAnnotationImpl);
        return solrAnnotationImpl;
    }

    protected <T extends AnnotationView> ResultSet<T> buildResultSet(QueryResponse rsp) {
        ResultSet resultSet = new ResultSet();
        List beans = rsp.getBeans(AnnotationViewAdapter.class);
        resultSet.setResults(beans);
        resultSet.setResultSize(rsp.getResults().getNumFound());
        if (rsp.getFacetFields() != null) {
            ArrayList<FacetFieldAdapter> facetFields = new ArrayList<FacetFieldAdapter>(rsp.getFacetFields().size());
            for (FacetField solrFacetField : rsp.getFacetFields()) {
                facetFields.add(new FacetFieldAdapter(solrFacetField));
            }
            resultSet.setFacetFields(facetFields);
        }
        if (rsp.getFacetQuery() != null) {
            resultSet.setQueryFacets(rsp.getFacetQuery());
        }
        return resultSet;
    }

    protected void processSolrBeanProperties(SolrAnnotation solrAnnotation) {
        this.processBody(solrAnnotation);
        this.processTargetUris(solrAnnotation);
    }

    protected void processBody(SolrAnnotation solrAnnotation) {
        Body body = solrAnnotation.getBody();
        if (body == null) {
            return;
        }
        String textValue = this.extractTextValues(body);
        switch (BodyInternalTypes.valueOf((String)body.getInternalType())) {
            case TEXT: {
                solrAnnotation.setBodyValue(textValue);
                break;
            }
            case GEO_TAG: {
                break;
            }
            case GRAPH: {
                GraphBody gb = (GraphBody)body;
                this.processGraphBody(solrAnnotation, gb);
                break;
            }
            case LINK: {
                break;
            }
            case SEMANTIC_LINK: {
                break;
            }
            case SEMANTIC_TAG: {
                solrAnnotation.setBodyUris(this.extractUriValues((SpecificResource)body));
                break;
            }
            case TAG: {
                solrAnnotation.setBodyValue(textValue);
                this.setBodyMultilingualValue(solrAnnotation);
                break;
            }
            case SPECIFIC_RESOURCE: 
            case FULL_TEXT_RESOURCE: {
                solrAnnotation.setBodyValue(textValue);
                solrAnnotation.setBodyUris(this.extractUriValues((SpecificResource)body));
                this.setBodyMultilingualValue(solrAnnotation);
                break;
            }
        }
    }

    protected void setBodyMultilingualValue(SolrAnnotation solrAnnotation) {
        String bodyMultiLingualText = this.extractMultilingualValue(solrAnnotation.getBody());
        HashMap<String, String> bodyMultilingualValue = new HashMap<String, String>();
        if (solrAnnotation.getBody().getLanguage() != null) {
            bodyMultilingualValue.put("body_value." + solrAnnotation.getBody().getLanguage(), bodyMultiLingualText);
        } else {
            bodyMultilingualValue.put("body_value.", bodyMultiLingualText);
        }
        solrAnnotation.setBodyMultilingualValue(bodyMultilingualValue);
    }

    protected String extractMultilingualValue(Body body) {
        return this.extractTextValues(body);
    }

    protected void processGraphBody(SolrAnnotation solrAnnotation, GraphBody gb) {
        solrAnnotation.setLinkRelation(gb.getGraph().getRelationName());
        if (gb.getGraph().getNodeUri() != null) {
            solrAnnotation.setLinkResourceUri(gb.getGraph().getNodeUri());
        } else if (gb.getGraph().getNode() != null) {
            String linkedResourceUri = gb.getGraph().getNode().getHttpUri();
            solrAnnotation.setLinkResourceUri(linkedResourceUri);
        }
    }

    protected String extractTextValues(Body body) {
        if (body.getValue() != null && !GeneralUtils.isUrl((String)body.getValue())) {
            return body.getValue();
        }
        if (body.getValues() != null) {
            ArrayList<String> notUrlValues = new ArrayList<String>();
            for (String elem : body.getValues()) {
                if (GeneralUtils.isUrl((String)elem)) continue;
                notUrlValues.add(elem);
            }
            if (notUrlValues.size() > 0) {
                return Arrays.toString(notUrlValues.toArray());
            }
            return null;
        }
        return null;
    }

    protected void processTargetUris(SolrAnnotation solrAnnotation) {
        HashSet<String> uniqueTargetUris = new HashSet<String>();
        Iterator iterator = solrAnnotation.getTarget().iterator();
        while (iterator.hasNext()) {
            Target t;
            Target internetResource = t = (Target)iterator.next();
            List<String> targetUrisEach = this.extractUriValues((SpecificResource)internetResource);
            uniqueTargetUris.addAll(targetUrisEach);
        }
        if (!uniqueTargetUris.isEmpty()) {
            solrAnnotation.setTargetUris(new ArrayList<String>(uniqueTargetUris));
            solrAnnotation.setTargetRecordIds(this.extractRecordIds(uniqueTargetUris));
        }
    }

    protected List<String> extractUriValues(SpecificResource specificResource) {
        ArrayList<String> resourceUrls = new ArrayList<String>();
        if (specificResource.getValues() != null && !specificResource.getValues().isEmpty()) {
            for (String value : specificResource.getValues()) {
                this.appendUrlValue(resourceUrls, value);
            }
        }
        if (specificResource.getValue() != null) {
            this.appendUrlValue(resourceUrls, specificResource.getValue());
        }
        if (specificResource.getSource() != null) {
            this.appendUrlValue(resourceUrls, specificResource.getSource());
        }
        if (specificResource.getScope() != null) {
            this.appendUrlValue(resourceUrls, specificResource.getScope());
        }
        if (specificResource.getHttpUri() != null) {
            this.appendUrlValue(resourceUrls, specificResource.getHttpUri());
        }
        return resourceUrls;
    }

    private void appendUrlValue(List<String> resourceUrls, String value) {
        if (GeneralUtils.isUrl((String)value) && !resourceUrls.contains(value)) {
            resourceUrls.add(value);
        }
    }

    List<String> extractRecordIds(Collection<String> targetUrls) {
        ArrayList<String> recordIds = new ArrayList<String>();
        for (String targetUrl : targetUrls) {
            this.addRecordIdToList(targetUrl, recordIds);
        }
        return recordIds;
    }

    void addRecordIdToList(String target, List<String> recordIds) {
        this.addToRecordIds(recordIds, target, "/item/");
        this.addToRecordIds(recordIds, target, "/record/");
    }

    private void addToRecordIds(List<String> recordIds, String target, String markup) {
        String recordId = null;
        int pos = target.indexOf(markup);
        if (pos > 0) {
            recordId = target.substring(pos + markup.length() - 1);
        }
        if (recordId != null && !recordIds.contains(recordId)) {
            recordIds.add(recordId);
        }
    }

    public String hideSolrServerBaseUrl(String text) {
        return text.replaceAll("http[^\\s]*\\s+", "*");
    }

    public static boolean isMalformedQueryException(Throwable ex) {
        return ex instanceof SolrException && ((SolrException)ex).code() == SolrException.ErrorCode.BAD_REQUEST.code;
    }

    public static void addQueryFieldFilter(SolrQuery q, String field) {
        q.set("fl", new String[]{field});
    }
}

