/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.solr.service.impl;

import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.moderation.ModerationRecord;
import eu.europeana.annotation.definitions.model.moderation.Summary;
import eu.europeana.annotation.definitions.model.resource.SpecificResource;
import eu.europeana.annotation.definitions.model.search.Query;
import eu.europeana.annotation.definitions.model.search.result.ResultSet;
import eu.europeana.annotation.definitions.model.target.Target;
import eu.europeana.annotation.definitions.model.utils.AnnotationIdHelper;
import eu.europeana.annotation.definitions.model.view.AnnotationView;
import eu.europeana.annotation.definitions.model.vocabulary.BodyInternalTypes;
import eu.europeana.annotation.definitions.model.vocabulary.MotivationTypes;
import eu.europeana.annotation.solr.exceptions.AnnotationServiceException;
import eu.europeana.annotation.solr.model.internal.SolrAnnotation;
import eu.europeana.annotation.solr.service.SolrAnnotationService;
import eu.europeana.annotation.solr.service.impl.SolrAnnotationUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.request.json.JsonQueryRequest;
import org.apache.solr.client.solrj.request.json.TermsFacetMap;
import org.apache.solr.client.solrj.response.PivotField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Service;

@Service(value="solrAnnotationService")
@PropertySource(value={"classpath:annotation.properties", "classpath:config/annotation.user.properties"}, ignoreResourceNotFound=true)
public class SolrAnnotationServiceImpl
extends SolrAnnotationUtils
implements SolrAnnotationService {
    @Autowired
    @Qualifier(value="annoSolrClient")
    SolrClient solrClient;
    @Value(value="${solr.stats.facets:10}")
    private int solrStatsFacets;
    @Value(value="${annotation.data.endpoint:}")
    private String annotationDataEndpoint;

    public void setSolrClient(SolrClient solrServer) {
        this.solrClient = solrServer;
    }

    public SolrClient getSolrClient() {
        return this.solrClient;
    }

    @Override
    public boolean store(Annotation anno) throws AnnotationServiceException {
        if (anno.isDisabled()) {
            this.getLogger().warn("Annotation with the following id was not stored in solr index, annotation diabled: " + anno.toString());
            return false;
        }
        this.store(anno, true);
        return true;
    }

    @Override
    public void store(List<? extends Annotation> annos) throws AnnotationServiceException {
        try {
            for (Annotation annotation : annos) {
                this.store(annotation, false);
            }
            this.solrClient.commit();
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when storing a list of annotations. " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
    }

    @Override
    public void store(Annotation anno, boolean doCommit) throws AnnotationServiceException {
        try {
            this.getLogger().debug("store: {}", (Object)anno);
            SolrAnnotation indexedAnno = null;
            indexedAnno = anno instanceof SolrAnnotation ? (SolrAnnotation)anno : this.copyIntoSolrAnnotation(anno, null, this.annotationDataEndpoint);
            UpdateResponse rsp = this.solrClient.addBean((Object)indexedAnno);
            this.getLogger().trace("store response: {}", (Object)rsp);
            if (doCommit) {
                this.solrClient.commit();
            }
        }
        catch (Throwable th) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when storing annotations for: " + anno.getIdentifier() + ". " + this.hideSolrServerBaseUrl(th.getMessage()), th);
        }
    }

    @Override
    public ResultSet<? extends AnnotationView> search(String term) throws AnnotationServiceException {
        ResultSet res = null;
        SolrQuery query = new SolrQuery(term);
        this.getLogger().debug("query: {}", (Object)query);
        try {
            QueryResponse rsp = this.solrClient.query((SolrParams)query);
            this.getLogger().trace("query response: {}", (Object)rsp);
            res = this.buildResultSet(rsp);
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when searching annotations for: " + term + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
        return res;
    }

    @Override
    @Deprecated
    public ResultSet<? extends AnnotationView> search(String term, String start, String limit) throws AnnotationServiceException {
        ResultSet res = null;
        SolrQuery query = new SolrQuery(term);
        if (StringUtils.isNotEmpty((CharSequence)start)) {
            query.setStart(Integer.valueOf(Integer.parseInt(start)));
        }
        if (StringUtils.isNotEmpty((CharSequence)limit)) {
            query.setRows(Integer.valueOf(Integer.parseInt(limit)));
        }
        this.getLogger().debug("limited query:{} ", (Object)query);
        try {
            QueryResponse rsp = this.solrClient.query((SolrParams)query);
            this.getLogger().trace("query response: {}", (Object)rsp);
            res = this.buildResultSet(rsp);
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when searching annotations for: " + term + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
        return res;
    }

    @Override
    public ResultSet<? extends AnnotationView> getAll() throws AnnotationServiceException {
        ResultSet res = null;
        SolrQuery query = new SolrQuery("all");
        try {
            QueryResponse rsp = this.solrClient.query((SolrParams)query);
            res = this.buildResultSet(rsp);
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when searching annotations with query: " + query.toString() + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
        return res;
    }

    @Override
    public AnnotationView searchById(String annoIdUrl) throws AnnotationServiceException {
        ResultSet rs;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("search by id: " + annoIdUrl);
        }
        SolrQuery query = new SolrQuery();
        query.setParam("anno_uri", new String[]{annoIdUrl});
        try {
            QueryResponse rsp = this.solrClient.query((SolrParams)query);
            rs = this.buildResultSet(rsp);
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when searching annotations for: " + annoIdUrl + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
        if (rs.getResultSize() == 0L) {
            return null;
        }
        if (rs.getResultSize() != 1L) {
            throw new AnnotationServiceException("Expected one result from Solr but found: " + rs.getResultSize());
        }
        return (AnnotationView)rs.getResults().get(0);
    }

    @Override
    @Deprecated
    public ResultSet<? extends AnnotationView> searchByTerm(String text) throws AnnotationServiceException {
        ResultSet res = null;
        SolrQuery query = new SolrQuery();
        String queryStr = "";
        if (text != null) {
            queryStr = text;
        }
        this.getLogger().debug("queryStr: {}", (Object)queryStr);
        query.setQuery(queryStr);
        try {
            QueryResponse rsp = this.solrClient.query((SolrParams)query);
            res = this.buildResultSet(rsp);
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when searching annotations for: " + text + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
        return res;
    }

    public ResultSet<? extends AnnotationView> searchAll() throws AnnotationServiceException {
        ResultSet<? extends AnnotationView> res = null;
        res = this.search("*:*");
        return res;
    }

    @Override
    public ResultSet<? extends AnnotationView> search(Query searchQuery) throws AnnotationServiceException {
        ResultSet res = null;
        SolrQuery query = this.toSolrQuery(searchQuery);
        try {
            this.getLogger().debug("search obj: {}", (Object)searchQuery);
            QueryResponse rsp = this.solrClient.query((SolrParams)query);
            res = this.buildResultSet(rsp);
            this.getLogger().trace("search obj res size: {}", (Object)res.getResultSize());
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when searching annotations for: " + query.toString() + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
        return res;
    }

    @Override
    public ResultSet<? extends AnnotationView> searchByLabel(String searchTerm) throws AnnotationServiceException {
        ResultSet res = null;
        SolrQuery query = new SolrQuery();
        query.setQuery(searchTerm);
        try {
            this.getLogger().debug("searchByLabel search query: {}", (Object)query);
            QueryResponse rsp = this.solrClient.query((SolrParams)query);
            res = this.buildResultSet(rsp);
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when searching annotations for: " + query.toString() + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
        return res;
    }

    @Override
    @Deprecated
    public ResultSet<? extends AnnotationView> searchByField(String field, String searchValue) throws AnnotationServiceException {
        ResultSet res = null;
        SolrQuery query = new SolrQuery();
        query.setQuery(field + ":" + searchValue);
        try {
            this.getLogger().debug("searchByField search query: {}", (Object)query);
            QueryResponse rsp = this.solrClient.query((SolrParams)query);
            res = this.buildResultSet(rsp);
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when searching annotations for: " + query.toString() + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
        return res;
    }

    @Override
    public QueryResponse getStatisticsByField(String fieldName) throws AnnotationServiceException {
        TermsFacetMap topCategoriesFacet = new TermsFacetMap(fieldName);
        JsonQueryRequest request = new JsonQueryRequest().setQuery("*:*").setLimit(0).withFacet(fieldName, (Map)topCategoriesFacet);
        try {
            this.getLogger().debug("Getting the annotations statstics with the json nested facets for the facet field: {}.", (Object)fieldName);
            QueryResponse queryResponse = (QueryResponse)request.process(this.solrClient);
            return queryResponse;
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when getting the annotations statistics for the facet field: " + fieldName + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
    }

    @Override
    public Map<String, Map<String, Long>> getStatisticsByFieldAndScenario(String mainFacetField) throws AnnotationServiceException {
        HashMap<String, Map<String, Long>> statsPerByFieldAndScenario = new HashMap<String, Map<String, Long>>();
        SolrQuery query = new SolrQuery();
        query.setQuery("*:*");
        String nestedFacetsFields = mainFacetField + ",scenario";
        query.addFacetPivotField(new String[]{nestedFacetsFields});
        query.setFacet(true);
        if (this.solrStatsFacets > 0) {
            query.setFacetLimit(this.solrStatsFacets);
        }
        query.setRows(Integer.valueOf(0));
        try {
            this.getLogger().debug("Getting the annotations statstics for the query: {}", (Object)query);
            QueryResponse rsp = this.solrClient.query((SolrParams)query);
            List nestedFacets = (List)rsp.getFacetPivot().get(nestedFacetsFields);
            for (PivotField mainFacetFieldFacet : nestedFacets) {
                HashMap<String, Long> statsPerScenario = new HashMap<String, Long>();
                for (PivotField scenarioFacet : mainFacetFieldFacet.getPivot()) {
                    statsPerScenario.put(scenarioFacet.getValue().toString(), Long.valueOf(scenarioFacet.getCount()));
                }
                statsPerByFieldAndScenario.put(mainFacetFieldFacet.getValue().toString(), statsPerScenario);
            }
            return statsPerByFieldAndScenario;
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when getting the annotations statistics for: " + query.toString() + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
    }

    @Override
    public void update(Annotation anno) throws AnnotationServiceException {
        this.update(anno, null);
    }

    @Override
    public boolean update(Annotation anno, Summary summary) throws AnnotationServiceException {
        this.getLogger().debug("update solr annotation: {}", (Object)anno);
        if (anno.isDisabled()) {
            return true;
        }
        SolrAnnotation indexedAnnotation = null;
        indexedAnnotation = anno instanceof SolrAnnotation ? (SolrAnnotation)anno : this.copyIntoSolrAnnotation(anno, summary, this.annotationDataEndpoint);
        return this.store(indexedAnnotation);
    }

    @Override
    public void delete(long annotationIdentifier) throws AnnotationServiceException {
        String annoUri = AnnotationIdHelper.buildAnnotationUri((String)this.annotationDataEndpoint, (long)annotationIdentifier);
        this.delete(annoUri);
    }

    public void deleteByQuery(String query) throws AnnotationServiceException {
        try {
            this.getLogger().debug("deleteByQuery: {}", (Object)query);
            UpdateResponse rsp = this.solrClient.deleteByQuery(query);
            this.getLogger().trace("delete response: {}", (Object)rsp);
            this.solrClient.commit();
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when deleting annotations for: " + query + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
    }

    protected void cleanUpAll() throws AnnotationServiceException {
        this.getLogger().info("clean up all solr annotations");
        this.deleteByQuery("*:*");
    }

    @Override
    public void delete(String annoUrl) throws AnnotationServiceException {
        try {
            this.getLogger().debug("delete annotation with ID: {}", (Object)annoUrl);
            this.solrClient.deleteById(annoUrl);
            this.solrClient.commit();
        }
        catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
            throw new AnnotationServiceException("Unexpected Solr server exception occured when deleting annotations for: " + annoUrl + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
        }
    }

    public void index(ModerationRecord moderationRecord) {
    }

    @Override
    public Set<String> checkDuplicateAnnotations(Annotation anno, boolean noSelfDupplicate) throws AnnotationServiceException {
        ArrayList<SolrQuery> queries = new ArrayList<SolrQuery>();
        switch (anno.getMotivationType()) {
            case TRANSLATING: 
            case TRANSCRIBING: {
                queries.add(this.solrUniquenessQueryTranscriptions(anno, noSelfDupplicate));
                break;
            }
            case CAPTIONING: {
                queries.add(this.solrUniquenessQueryCaptions(anno, noSelfDupplicate));
                queries.add(this.solrUniquenessQueryCaptionsAndSubtitles(anno, noSelfDupplicate));
                break;
            }
            case SUBTITLING: {
                queries.add(this.solrUniquenessQueryCaptionsAndSubtitles(anno, noSelfDupplicate));
                break;
            }
            case TAGGING: {
                if (BodyInternalTypes.isSemanticTagBody((String)anno.getBody().getInternalType())) {
                    queries.add(this.solrUniquenessQuerySemanticTagging(anno, noSelfDupplicate));
                    break;
                }
                if (!BodyInternalTypes.isSimpleTagBody((String)anno.getBody().getInternalType())) break;
                queries.add(this.solrUniquenessQuerySimpleTagging(anno, noSelfDupplicate));
                break;
            }
            case LINKING: {
                break;
            }
            case LINKFORCONTRIBUTING: {
                queries.add(this.solrUniquenessQueryLinkForContributing(anno, noSelfDupplicate));
                break;
            }
            case HIGHLIGHTING: {
                queries.add(this.solrUniquenessQueryDebias(anno, noSelfDupplicate));
                break;
            }
        }
        HashSet<String> responseAnnoIds = new HashSet<String>();
        for (SolrQuery query : queries) {
            this.getLogger().debug("Dupplicate annotation check query: {}", (Object)query);
            QueryResponse rsp = null;
            try {
                rsp = this.solrClient.query((SolrParams)query);
            }
            catch (IOException | SolrServerException | BaseHttpSolrClient.RemoteSolrException ex) {
                throw new AnnotationServiceException("Unexpected Solr server exception occured when searching with the query: " + query.toString() + ". " + this.hideSolrServerBaseUrl(ex.getMessage()), ex);
            }
            if (rsp == null) {
                throw new AnnotationServiceException("Cannot verify if annotation is dupplicated, no solr response for query: " + query.toString());
            }
            SolrDocumentList docs = rsp.getResults();
            if (docs.isEmpty()) continue;
            for (SolrDocument returnedDoc : docs) {
                responseAnnoIds.add(String.valueOf(returnedDoc.getFieldValue("anno_id")));
            }
        }
        return responseAnnoIds;
    }

    private SolrQuery solrUniquenessQueryTranscriptions(Annotation anno, boolean noSelfDupplicate) {
        SolrQuery query = new SolrQuery();
        query.setQuery("motivation:\"" + anno.getMotivationType().getOaType() + "\"");
        query.addFilterQuery(new String[]{"target_uri:\"" + ((Target)anno.getTarget().get(0)).getSource() + "\""});
        if (anno.getBody().getLanguage() != null) {
            query.addFilterQuery(new String[]{"body_value." + anno.getBody().getLanguage() + ":*"});
        } else {
            query.addFilterQuery(new String[]{"body_value.:*"});
        }
        this.addNotSelfDupplicateFilter(anno, query, noSelfDupplicate);
        SolrAnnotationUtils.addQueryFieldFilter(query, "anno_id");
        return query;
    }

    private SolrQuery solrUniquenessQueryCaptions(Annotation anno, boolean noSelfDupplicate) {
        SolrQuery query = new SolrQuery();
        query.setQuery("motivation:\"" + MotivationTypes.CAPTIONING.getOaType() + "\"");
        query.addFilterQuery(new String[]{"target_uri:\"" + ((Target)anno.getTarget().get(0)).getSource() + "\""});
        this.addNotSelfDupplicateFilter(anno, query, noSelfDupplicate);
        SolrAnnotationUtils.addQueryFieldFilter(query, "anno_id");
        return query;
    }

    private SolrQuery solrUniquenessQueryCaptionsAndSubtitles(Annotation anno, boolean noSelfDupplicate) {
        SolrQuery query = new SolrQuery();
        query.setQuery("motivation:(\"" + MotivationTypes.CAPTIONING.getOaType() + "\" OR \"" + MotivationTypes.SUBTITLING.getOaType() + "\")");
        query.addFilterQuery(new String[]{"target_uri:\"" + ((Target)anno.getTarget().get(0)).getSource() + "\""});
        query.addFilterQuery(new String[]{"body_value." + anno.getBody().getLanguage() + ":*"});
        this.addNotSelfDupplicateFilter(anno, query, noSelfDupplicate);
        SolrAnnotationUtils.addQueryFieldFilter(query, "anno_id");
        return query;
    }

    private SolrQuery solrUniquenessQueryDebias(Annotation anno, boolean noSelfDupplicate) {
        SolrQuery query = new SolrQuery();
        query.setQuery("motivation:\"" + MotivationTypes.HIGHLIGHTING.getOaType() + "\"");
        StringBuilder targetOrQuery = new StringBuilder();
        for (Target t : anno.getTarget()) {
            String bindElement = targetOrQuery.isEmpty() ? "(" : " OR ";
            targetOrQuery.append(bindElement).append('\"').append(t.getSource()).append('\"');
        }
        targetOrQuery.append(")");
        query.addFilterQuery(new String[]{"target_uri:" + targetOrQuery.toString()});
        List<String> bodyUris = this.extractUriValues((SpecificResource)anno.getBody());
        for (int i = 0; i < bodyUris.size(); ++i) {
            query.addFilterQuery(new String[]{"body_uri:\"" + bodyUris.get(i) + "\""});
        }
        this.addNotSelfDupplicateFilter(anno, query, noSelfDupplicate);
        SolrAnnotationUtils.addQueryFieldFilter(query, "anno_id");
        return query;
    }

    private void addNotSelfDupplicateFilter(Annotation anno, SolrQuery query, boolean noSelfDupplicate) {
        if (noSelfDupplicate && anno.getIdentifier() > 0L) {
            query.addFilterQuery(new String[]{"-anno_id:" + anno.getIdentifier()});
        }
    }

    private void addTargetRecordIdFilter(Annotation anno, SolrQuery query) {
        List<String> recordIds;
        List<String> targetUris;
        if (anno.getTarget() != null && (targetUris = this.extractUriValues((SpecificResource)anno.getTarget().get(0))) != null && (recordIds = this.extractRecordIds(targetUris)) != null) {
            for (String recordIdElem : recordIds) {
                query.addFilterQuery(new String[]{"target_record_id:\"" + recordIdElem + "\""});
            }
        }
    }

    private SolrQuery solrUniquenessQuerySemanticTagging(Annotation anno, boolean noSelfDupplicate) {
        SolrQuery query = new SolrQuery();
        query.setQuery("motivation:\"" + MotivationTypes.TAGGING.getOaType() + "\"");
        this.addTargetRecordIdFilter(anno, query);
        List<String> bodyUris = this.extractUriValues((SpecificResource)anno.getBody());
        for (int i = 0; i < bodyUris.size(); ++i) {
            query.addFilterQuery(new String[]{"body_uri:\"" + bodyUris.get(i) + "\""});
        }
        this.addNotSelfDupplicateFilter(anno, query, noSelfDupplicate);
        SolrAnnotationUtils.addQueryFieldFilter(query, "anno_id");
        return query;
    }

    private SolrQuery solrUniquenessQuerySimpleTagging(Annotation anno, boolean noSelfDupplicate) {
        SolrQuery query = new SolrQuery();
        query.setQuery("motivation:\"" + MotivationTypes.TAGGING.getOaType() + "\"");
        this.addTargetRecordIdFilter(anno, query);
        String bodyMultilingualValue = this.extractMultilingualValue(anno.getBody());
        if (anno.getBody().getLanguage() != null) {
            query.addFilterQuery(new String[]{"body_value." + anno.getBody().getLanguage() + ":\"" + bodyMultilingualValue + "\""});
        } else {
            query.addFilterQuery(new String[]{"body_value.:\"" + bodyMultilingualValue + "\""});
        }
        this.addNotSelfDupplicateFilter(anno, query, noSelfDupplicate);
        SolrAnnotationUtils.addQueryFieldFilter(query, "anno_id");
        return query;
    }

    private SolrQuery solrUniquenessQueryLinkForContributing(Annotation anno, boolean noSelfDupplicate) {
        SolrQuery query = new SolrQuery();
        query.setQuery("motivation:\"" + MotivationTypes.LINKFORCONTRIBUTING.getOaType() + "\"");
        this.addTargetRecordIdFilter(anno, query);
        this.addNotSelfDupplicateFilter(anno, query, noSelfDupplicate);
        SolrAnnotationUtils.addQueryFieldFilter(query, "anno_id");
        return query;
    }
}

