/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.solr.model.internal;

import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.impl.AbstractAnnotation;
import eu.europeana.annotation.definitions.model.moderation.Summary;
import eu.europeana.annotation.definitions.model.vocabulary.BodyInternalTypes;
import eu.europeana.annotation.solr.model.internal.SolrAnnotation;
import eu.europeana.annotation.solr.vocabulary.SolrAnnotationConstants;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.beans.Field;

public class SolrAnnotationImpl
extends AbstractAnnotation
implements SolrAnnotation,
SolrAnnotationConstants {
    private String annoUri;
    private long annoId;
    private String generatorUri;
    private String generatorName;
    private String creatorUri;
    private String creatorName;
    private Integer moderationScore = 0;
    private List<String> targetUris;
    private List<String> targetRecordIds;
    private String linkResourceUri;
    private String linkRelation;
    private String bodyValue;
    private Map<String, String> bodyMultilingualValue;
    private List<String> bodyUris;
    private String scenario;
    private Date modified;

    public SolrAnnotationImpl() {
    }

    public SolrAnnotationImpl(Annotation annotation, Summary summary, String annoBaseUri) {
        this.setInternalType(annotation.getInternalType());
        this.setMotivation(annotation.getMotivation());
        this.setIdentifier(annotation.getIdentifier());
        this.setAnnoUri(annoBaseUri + "/" + annotation.getIdentifier());
        this.setAnnoId(annotation.getIdentifier());
        if (annotation.getGenerator() != null) {
            this.setGenerator(annotation.getGenerator());
            this.setGeneratorUri(annotation.getGenerator().getHttpUrl());
            this.setGeneratorName(annotation.getGenerator().getName());
        }
        this.setGenerated(annotation.getGenerated());
        if (annotation.getCreator() != null) {
            this.setCreator(annotation.getCreator());
            this.setCreatorName(annotation.getCreator().getName());
            this.setCreatorUri(annotation.getCreator().getHttpUrl());
        }
        this.setCreated(annotation.getCreated());
        this.setModified(annotation.getLastUpdate());
        if (summary != null) {
            this.setModerationScore(summary.getScore());
        }
        this.setTarget(annotation.getTarget());
        this.setBody(annotation.getBody());
        this.setScenario(this.findScenarioType(annotation));
    }

    private String findScenarioType(Annotation anno) {
        switch (anno.getMotivationType()) {
            case TRANSCRIBING: {
                return "transcription";
            }
            case TRANSLATING: {
                return "translation";
            }
            case CAPTIONING: {
                return "caption";
            }
            case SUBTITLING: {
                return "subtitle";
            }
            case TAGGING: {
                if (anno.getBody().getInternalType().equalsIgnoreCase(BodyInternalTypes.SEMANTIC_TAG.toString())) {
                    return "semanticTag";
                }
                if (anno.getBody().getInternalType().equalsIgnoreCase(BodyInternalTypes.TAG.toString())) {
                    return "simpleTag";
                }
                if (anno.getBody().getInternalType().equalsIgnoreCase(BodyInternalTypes.GEO_TAG.toString())) {
                    return "geoTag";
                }
            }
            case LINKING: {
                return "objectLink";
            }
            case LINKFORCONTRIBUTING: {
                return "contributeLink";
            }
            case HIGHLIGHTING: {
                return "highlight";
            }
        }
        return "";
    }

    @Override
    @Field(value="created")
    public void setCreated(Date created) {
        super.setCreated(created);
    }

    @Field(value="generated")
    public void setGenerated(Date generated) {
        super.setGenerated(generated);
    }

    @Override
    public String getBodyValue() {
        return this.bodyValue;
    }

    @Override
    public List<String> getTargetUris() {
        return this.targetUris;
    }

    @Override
    @Field(value="target_uri")
    public void setTargetUris(List<String> targetUris) {
        this.targetUris = targetUris;
    }

    @Override
    public List<String> getTargetRecordIds() {
        return this.targetRecordIds;
    }

    @Override
    @Field(value="target_record_id")
    public void setTargetRecordIds(List<String> recordIds) {
        this.targetRecordIds = recordIds;
    }

    @Field(value="motivation")
    public void setMotivation(String motivation) {
        super.setMotivation(motivation);
    }

    @Override
    public String getAnnoUri() {
        return this.annoUri;
    }

    @Override
    @Field(value="body_value")
    public void setBodyValue(String bodyValue) {
        this.bodyValue = bodyValue;
    }

    @Override
    @Field(value="body_value.*")
    public void setBodyMultilingualValue(Map<String, String> multilingualText) {
        this.bodyMultilingualValue = multilingualText;
    }

    public Map<String, String> getBodyMultilingualValue() {
        return this.bodyMultilingualValue;
    }

    @Override
    @Field(value="anno_uri")
    public void setAnnoUri(String annotationIdUrl) {
        this.annoUri = annotationIdUrl;
    }

    public void setInternalType(String internalType) {
        this.internalType = internalType;
    }

    @Override
    @Field(value="moderation_score")
    public void setModerationScore(Integer moderationScore) {
        this.moderationScore = moderationScore;
    }

    @Override
    public Integer getModerationScore() {
        return this.moderationScore;
    }

    public String toString() {
        return "SolrAnnotation [anno_uri:" + this.getAnnoUri() + ", created:" + this.getCreated() + ", bodyValue:" + this.getBodyValue() + "]";
    }

    @Override
    public String getGeneratorName() {
        return this.generatorName;
    }

    @Override
    @Field(value="generator_name")
    public void setGeneratorName(String generatorName) {
        this.generatorName = generatorName;
    }

    @Override
    public String getGeneratorUri() {
        return this.generatorUri;
    }

    @Override
    @Field(value="generator_uri")
    public void setGeneratorUri(String generatorId) {
        this.generatorUri = generatorId;
    }

    @Override
    public long getAnnoId() {
        return this.annoId;
    }

    @Override
    @Field(value="anno_id")
    public void setAnnoId(long annoId) {
        this.annoId = annoId;
    }

    @Override
    public String getCreatorUri() {
        return this.creatorUri;
    }

    @Override
    @Field(value="creator_uri")
    public void setCreatorUri(String creatorUri) {
        this.creatorUri = creatorUri;
    }

    @Override
    public String getCreatorName() {
        return this.creatorName;
    }

    @Override
    @Field(value="creator_name")
    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    @Field(value="modified")
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Override
    public String getLinkResourceUri() {
        return this.linkResourceUri;
    }

    @Override
    @Field(value="link_resource_uri")
    public void setLinkResourceUri(String linkResourceUri) {
        this.linkResourceUri = linkResourceUri;
    }

    @Override
    public String getLinkRelation() {
        return this.linkRelation;
    }

    @Override
    @Field(value="link_relation")
    public void setLinkRelation(String linkRelation) {
        this.linkRelation = linkRelation;
    }

    @Override
    public List<String> getBodyUris() {
        return this.bodyUris;
    }

    @Override
    @Field(value="body_uri")
    public void setBodyUris(List<String> bodyUris) {
        this.bodyUris = bodyUris;
    }

    @Override
    public String getScenario() {
        return this.scenario;
    }

    @Override
    @Field(value="scenario")
    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public long getIdentifierAsNumber() {
        return this.annoId;
    }
}

