/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.dereferenciation;

import eu.europeana.annotation.connection.HttpConnection;
import eu.europeana.annotation.definitions.exception.AnnotationDereferenciationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.stanbol.commons.jsonld.JsonSerializer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service(value="metisDereferenceClient")
@PropertySource(value={"classpath:annotation.properties", "classpath:config/annotation.user.properties"}, ignoreResourceNotFound=true)
public class MetisDereferenciationClient
implements InitializingBean {
    @Value(value="${metis.baseUrl}")
    private String baseUrl;
    @Value(value="${metis.connection.retries:3}")
    private int connRetries;
    @Value(value="${metis.connection.timeout:30000}")
    private int connTimeout;
    static final String XSLT_TRANSFORMATION_FILE = "/deref2json.xsl";
    static final String PARAM_URI = "uri";
    static final String PARAM_LANGS = "langs";
    Transformer transformer;
    private HttpConnection httpConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        MetisDereferenciationClient metisDereferenciationClient = this;
        synchronized (metisDereferenciationClient) {
            if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
                throw new AnnotationDereferenciationException((Throwable)new RuntimeException("Metis baseUrl cannot be null or empty."));
            }
            this.httpConnection = new HttpConnection(this.connRetries, this.connTimeout);
            TransformerFactory factory = TransformerFactory.newInstance();
            InputStream xslFileAsStream = new ClassPathResource(XSLT_TRANSFORMATION_FILE).getInputStream();
            StreamSource xslSource = new StreamSource(xslFileAsStream);
            Templates templates = factory.newTemplates(xslSource);
            this.transformer = templates.newTransformer();
        }
    }

    String encodeUrl(String url) {
        return URLEncoder.encode(url, StandardCharsets.UTF_8);
    }

    public Map<String, String> dereferenceOne(String uri, String language) throws AnnotationDereferenciationException {
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            UriBuilder uriBuilder = UriBuilder.fromPath((String)this.baseUrl).queryParam(PARAM_URI, new Object[]{uri});
            InputStream streamResponse = this.httpConnection.getURLContent(uriBuilder.build(new Object[0]).toString());
            String jsonLdStr = this.convertToJsonLd(uri, streamResponse, language).toString();
            res.put(uri, jsonLdStr);
        }
        catch (IOException ex) {
            throw new AnnotationDereferenciationException((Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new AnnotationDereferenciationException((Throwable)ex);
        }
        return res;
    }

    public Map<String, String> dereferenceMany(List<String> uris, String language) throws AnnotationDereferenciationException {
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            String urisJson = JsonSerializer.toString(uris);
            InputStream streamResponse = this.httpConnection.postRequest(this.baseUrl, urisJson);
            String[] urisArray = new String[uris.size()];
            urisArray = uris.toArray(urisArray);
            String jsonLdStr = this.convertToJsonLd(urisArray, streamResponse, language).toString();
            List<Integer> startingPositions = this.findSubstringIndexes(jsonLdStr, "{ \"@context\":");
            for (int i = 0; i < startingPositions.size(); ++i) {
                if (i == startingPositions.size() - 1) {
                    res.put(uris.get(i), jsonLdStr.substring(startingPositions.get(i), jsonLdStr.length()));
                    continue;
                }
                res.put(uris.get(i), jsonLdStr.substring(startingPositions.get(i), startingPositions.get(i + 1)));
            }
        }
        catch (IOException ex) {
            throw new AnnotationDereferenciationException((Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new AnnotationDereferenciationException((Throwable)ex);
        }
        return res;
    }

    private List<Integer> findSubstringIndexes(String input, String substring) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int substringLength = substring.length();
        int index = input.indexOf(substring, 0);
        if (index != -1) {
            indexes.add(index);
            while (index != -1) {
                if ((index = input.indexOf(substring, index + substringLength)) == -1) continue;
                indexes.add(index);
            }
        }
        return indexes;
    }

    public StringWriter convertToJsonLd(Object uris, InputStream response, String language) {
        StringWriter result = new StringWriter();
        try {
            this.transformer.clearParameters();
            this.transformer.setParameter(PARAM_URI, uris);
            if (language != null) {
                this.transformer.setParameter(PARAM_LANGS, language);
            }
            StreamSource text = new StreamSource(response);
            this.transformer.transform(text, new StreamResult(result));
        }
        catch (TransformerConfigurationException e) {
            throw new AnnotationDereferenciationException("Unexpected exception occured when invoking the MetisDereferenciationClient convertDereferenceOutputToJsonLd method", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new AnnotationDereferenciationException("Exception occured when invoking the MetisDereferenciationClient convertDereferenceOutputToJsonLd method", (Throwable)e);
        }
        return result;
    }
}

