/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.connection;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class HttpConnection {
    public static final int DEFAULT_CONNECTION_RETRIES = 3;
    public static final int DEFAULT_TIMEOUT_CONNECTION = 40000;
    private static final int STATUS_OK_START = 200;
    private static final int STATUS_OK_END = 299;
    private HttpClient httpClient = null;
    private int connectionRetries;
    private int connectionTimeout;

    public HttpConnection(int retries, int timeout) {
        this.connectionRetries = retries > 0 ? retries : 3;
        this.connectionTimeout = timeout > 0 ? timeout : timeout;
    }

    public HttpConnection() {
        this(3, 40000);
    }

    public InputStream getURLContent(String url) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        GetMethod get = new GetMethod(url);
        get.setRequestHeader("Accept", "application/xml");
        client.executeMethod((HttpMethod)get);
        if (get.getStatusCode() >= 200 && get.getStatusCode() <= 299) {
            return get.getResponseBodyAsStream();
        }
        return null;
    }

    public InputStream postRequest(String url, String body) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        PostMethod post = new PostMethod(url);
        post.setRequestHeader("Accept", "application/xml");
        StringRequestEntity requestBody = new StringRequestEntity(body, "application/json;charset=UTF-8", null);
        post.setRequestEntity((RequestEntity)requestBody);
        client.executeMethod((HttpMethod)post);
        if (post.getStatusCode() >= 200 && post.getStatusCode() <= 299) {
            return post.getResponseBodyAsStream();
        }
        return null;
    }

    private HttpClient getHttpClient(int connectionRetry, int conectionTimeout) {
        if (this.httpClient == null) {
            String readTimeOut;
            HttpClient client = new HttpClient();
            client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(connectionRetry, false));
            String proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost != null && proxyHost.length() > 0) {
                String proxyPortSrt = System.getProperty("http.proxyPort");
                if (proxyPortSrt == null) {
                    proxyPortSrt = "8080";
                }
                int proxyPort = Integer.parseInt(proxyPortSrt);
                client.getHostConfiguration().setProxy(proxyHost, proxyPort);
            }
            boolean bTimeout = false;
            String connectTimeOut = System.getProperty("sun.net.client.defaultConnectTimeout");
            if (connectTimeOut != null && connectTimeOut.length() > 0) {
                client.getParams().setIntParameter("sun.net.client.defaultConnectTimeout", Integer.parseInt(connectTimeOut));
                bTimeout = true;
            }
            if ((readTimeOut = System.getProperty("sun.net.client.defaultReadTimeout")) != null && readTimeOut.length() > 0) {
                client.getParams().setIntParameter("sun.net.client.defaultReadTimeout", Integer.parseInt(readTimeOut));
                bTimeout = true;
            }
            if (!bTimeout) {
                client.getParams().setIntParameter("http.socket.timeout", conectionTimeout);
            }
            this.httpClient = client;
        }
        return this.httpClient;
    }

    public int getConnectionRetries() {
        return this.connectionRetries;
    }

    public void setConnectionRetries(int connectionRetries) {
        this.connectionRetries = connectionRetries;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

