/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.client.model.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.agent.Agent;
import eu.europeana.annotation.definitions.model.factory.impl.AnnotationObjectFactory;
import eu.europeana.annotation.definitions.model.selector.shape.Point;
import eu.europeana.annotation.definitions.model.selector.shape.impl.PointImpl;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;

public class AnnotationDeserializer
implements JsonDeserializer<Annotation> {
    Gson gson = null;

    public Annotation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Class concreteClass = null;
        JsonObject jsonObj = json.getAsJsonObject();
        for (Map.Entry attribute : jsonObj.entrySet()) {
            if (!"type".equals(attribute.getKey())) continue;
            concreteClass = AnnotationObjectFactory.getInstance().getClassForType(((JsonElement)attribute.getValue()).getAsString());
            break;
        }
        return (Annotation)this.getGson().fromJson((JsonElement)jsonObj, concreteClass);
    }

    private Gson getGson() {
        if (this.gson == null) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(Point.class, (Object)new ShapeDeserializer());
            gsonBuilder.registerTypeAdapter(Date.class, (Object)new JsonDateDeserializer());
            gsonBuilder.registerTypeAdapter(Agent.class, (Object)new AgentDeserializer());
            this.gson = gsonBuilder.create();
        }
        return this.gson;
    }

    public class ShapeDeserializer
    implements InstanceCreator<Point> {
        public Point createInstance(Type type) {
            return new PointImpl();
        }
    }

    public class JsonDateDeserializer
    implements JsonDeserializer<Date> {
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String s = json.getAsJsonPrimitive().getAsString();
            long l = Long.parseLong(s.substring(6, s.length() - 2));
            Date d = new Date(l);
            return d;
        }
    }

    public class AgentDeserializer
    implements JsonDeserializer<Agent> {
        public Agent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return null;
        }
    }
}

