/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.client.http;

import java.io.IOException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class HttpConnection {
    private static final int CONNECTION_RETRIES = 3;
    private static final int TIMEOUT_CONNECTION = 40000;
    private static final int STATUS_OK_START = 200;
    private static final int STATUS_OK_END = 299;
    private static final String ENCODING = "UTF-8";
    private HttpClient httpClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURLContent(String url) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        GetMethod get = new GetMethod(url);
        try {
            client.executeMethod((HttpMethod)get);
            if (get.getStatusCode() >= 200 && get.getStatusCode() <= 299) {
                String res;
                byte[] byteResponse = get.getResponseBody();
                String string = res = new String(byteResponse, ENCODING);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURLContentWithHeader(String url, String requestHeaderName, String requestHeaderValue) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        GetMethod get = new GetMethod(url);
        if (StringUtils.isNotBlank((CharSequence)requestHeaderName) && StringUtils.isNotBlank((CharSequence)requestHeaderValue)) {
            get.setRequestHeader(requestHeaderName, requestHeaderValue);
        }
        try {
            client.executeMethod((HttpMethod)get);
            if (get.getStatusCode() >= 200 && get.getStatusCode() <= 299) {
                String res;
                byte[] byteResponse = get.getResponseBody();
                String string = res = new String(byteResponse, ENCODING);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURLContent(String url, String jsonParamName, String jsonParamValue) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        PostMethod post = new PostMethod(url);
        post.setParameter(jsonParamName, jsonParamValue);
        try {
            client.executeMethod((HttpMethod)post);
            if (post.getStatusCode() >= 200 && post.getStatusCode() <= 299) {
                String res;
                byte[] byteResponse = post.getResponseBody();
                String string = res = new String(byteResponse, ENCODING);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<String> postURL(String url, String jsonParamValue, String requestHeaderName, String requestHeaderValue) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        PostMethod post = new PostMethod(url);
        if (StringUtils.isNotBlank((CharSequence)requestHeaderName) && StringUtils.isNotBlank((CharSequence)requestHeaderValue)) {
            post.setRequestHeader(requestHeaderName, requestHeaderValue);
        }
        post.setRequestHeader("Content-Type", "application/json;charset=utf-8");
        post.setRequestBody(jsonParamValue);
        try {
            client.executeMethod((HttpMethod)post);
            ResponseEntity<String> responseEntity = this.buildResponseEntity((HttpMethod)post);
            return responseEntity;
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<String> postURL(String url, String jsonParamValue) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        PostMethod post = new PostMethod(url);
        post.setRequestHeader("Content-Type", "application/json;charset=utf-8");
        post.setRequestBody(jsonParamValue);
        try {
            client.executeMethod((HttpMethod)post);
            ResponseEntity<String> responseEntity = this.buildResponseEntity((HttpMethod)post);
            return responseEntity;
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<String> putURL(String url, String jsonParamValue) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        PutMethod put = new PutMethod(url);
        put.setRequestHeader("Content-Type", "application/json;charset=utf-8");
        put.setRequestBody(jsonParamValue);
        try {
            client.executeMethod((HttpMethod)put);
            ResponseEntity<String> responseEntity = this.buildResponseEntity((HttpMethod)put);
            return responseEntity;
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<String> putURL(String url, String jsonParamValue, String requestHeaderName, String requestHeaderValue) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        PutMethod put = new PutMethod(url);
        if (StringUtils.isNotBlank((CharSequence)requestHeaderName) && StringUtils.isNotBlank((CharSequence)requestHeaderValue)) {
            put.setRequestHeader(requestHeaderName, requestHeaderValue);
        }
        put.setRequestHeader("Content-Type", "application/json;charset=utf-8");
        put.setRequestBody(jsonParamValue);
        try {
            client.executeMethod((HttpMethod)put);
            ResponseEntity<String> responseEntity = this.buildResponseEntity((HttpMethod)put);
            return responseEntity;
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<String> deleteURL(String url) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        DeleteMethod delete = new DeleteMethod(url);
        try {
            client.executeMethod((HttpMethod)delete);
            ResponseEntity<String> responseEntity = this.buildResponseEntity((HttpMethod)delete);
            return responseEntity;
        }
        finally {
            delete.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<String> deleteURL(String url, String requestHeaderName, String requestHeaderValue) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        DeleteMethod delete = new DeleteMethod(url);
        if (StringUtils.isNotBlank((CharSequence)requestHeaderName) && StringUtils.isNotBlank((CharSequence)requestHeaderValue)) {
            delete.setRequestHeader(requestHeaderName, requestHeaderValue);
        }
        try {
            client.executeMethod((HttpMethod)delete);
            ResponseEntity<String> responseEntity = this.buildResponseEntity((HttpMethod)delete);
            return responseEntity;
        }
        finally {
            delete.releaseConnection();
        }
    }

    private ResponseEntity<String> buildResponseEntity(HttpMethod method) throws IOException {
        LinkedMultiValueMap headers = new LinkedMultiValueMap(15);
        for (Header header : method.getResponseHeaders()) {
            headers.add((Object)header.getName(), (Object)header.getValue());
        }
        String res = null;
        if (method.getResponseBody() != null && method.getResponseBody().length > 0) {
            byte[] byteResponse = method.getResponseBody();
            res = new String(byteResponse, ENCODING);
        }
        ResponseEntity responseEntity = new ResponseEntity(res, (MultiValueMap)headers, HttpStatus.valueOf((int)method.getStatusCode()));
        return responseEntity;
    }

    public ResponseEntity<String> getURL(String url) throws IOException {
        return this.getURLWithHeader(url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<String> getURLWithHeader(String url, String requestHeaderName, String requestHeaderValue) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        GetMethod get = new GetMethod(url);
        if (StringUtils.isNotBlank((CharSequence)requestHeaderName) && StringUtils.isNotBlank((CharSequence)requestHeaderValue)) {
            get.setRequestHeader(requestHeaderName, requestHeaderValue);
        }
        try {
            client.executeMethod((HttpMethod)get);
            ResponseEntity<String> responseEntity = this.buildResponseEntity((HttpMethod)get);
            return responseEntity;
        }
        finally {
            get.releaseConnection();
        }
    }

    public String getURLContentWithBody(String url, String jsonParamValue) throws IOException {
        return this.getURLContentWithBody(url, jsonParamValue, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURLContentWithBody(String url, String jsonParamValue, String requestHeaderName, String requestHeaderValue) throws IOException {
        HttpClient client = this.getHttpClient(3, 40000);
        PostMethod post = new PostMethod(url);
        post.setRequestBody(jsonParamValue);
        if (StringUtils.isNotBlank((CharSequence)requestHeaderName) && StringUtils.isNotBlank((CharSequence)requestHeaderValue)) {
            post.setRequestHeader(requestHeaderName, requestHeaderValue);
        }
        try {
            client.executeMethod((HttpMethod)post);
            if (post.getStatusCode() >= 200 && post.getStatusCode() <= 299) {
                String res;
                byte[] byteResponse = post.getResponseBody();
                String string = res = new String(byteResponse, ENCODING);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            post.releaseConnection();
        }
    }

    private HttpClient getHttpClient(int connectionRetry, int conectionTimeout) {
        if (this.httpClient == null) {
            String readTimeOut;
            HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            client.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(connectionRetry, false));
            String proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost != null && proxyHost.length() > 0) {
                String proxyPortSrt = System.getProperty("http.proxyPort");
                if (proxyPortSrt == null) {
                    proxyPortSrt = "8080";
                }
                int proxyPort = Integer.parseInt(proxyPortSrt);
                client.getHostConfiguration().setProxy(proxyHost, proxyPort);
            }
            boolean bTimeout = false;
            String connectTimeOut = System.getProperty("sun.net.client.defaultConnectTimeout");
            if (connectTimeOut != null && connectTimeOut.length() > 0) {
                client.getParams().setIntParameter("sun.net.client.defaultConnectTimeout", Integer.parseInt(connectTimeOut));
                bTimeout = true;
            }
            if ((readTimeOut = System.getProperty("sun.net.client.defaultReadTimeout")) != null && readTimeOut.length() > 0) {
                client.getParams().setIntParameter("sun.net.client.defaultReadTimeout", Integer.parseInt(readTimeOut));
                bTimeout = true;
            }
            if (!bTimeout) {
                client.getParams().setIntParameter("http.socket.timeout", conectionTimeout);
            }
            this.httpClient = client;
        }
        return this.httpClient;
    }
}

