/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.client.connection;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.europeana.annotation.client.http.HttpConnection;
import eu.europeana.annotation.client.model.json.AnnotationDeserializer;
import eu.europeana.annotation.definitions.model.Annotation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;

public class BaseApiConnection {
    private String apiKey;
    private String annotationServiceUri = "";
    private HttpConnection httpConnection = new HttpConnection();
    Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Gson gson;

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAdminApiKey() {
        return "apiadmin";
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getAnnotationServiceUri() {
        return this.annotationServiceUri;
    }

    public void setAnnotationServiceUri(String annotationServiceUri) {
        this.annotationServiceUri = annotationServiceUri;
    }

    public HttpConnection getHttpConnection() {
        return this.httpConnection;
    }

    public void setHttpConnection(HttpConnection httpConnection) {
        this.httpConnection = httpConnection;
    }

    public Gson getAnnotationGson() {
        if (this.gson == null) {
            GsonBuilder builder = new GsonBuilder();
            AnnotationDeserializer annoDeserializer = new AnnotationDeserializer();
            builder.registerTypeHierarchyAdapter(Annotation.class, (Object)annoDeserializer);
            this.gson = builder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
        }
        return this.gson;
    }

    public BaseApiConnection(String annotationServiceUri, String apiKey) {
        this.apiKey = apiKey;
        this.annotationServiceUri = annotationServiceUri;
    }

    String getJSONResult(String url) throws IOException {
        this.logger.trace("Call to Annotation API (GET): " + url);
        return this.getHttpConnection().getURLContent(url);
    }

    String getJSONResultWithHeader(String url, String headerName, String headerValue) throws IOException {
        this.logger.trace("Call to Annotation API (GET): " + url);
        return this.getHttpConnection().getURLContentWithHeader(url, headerName, headerValue);
    }

    String getJSONResult(String url, String paramName, String jsonPost) throws IOException {
        this.logger.trace("Call to Annotation API (POST): " + url);
        return this.getHttpConnection().getURLContent(url, paramName, jsonPost);
    }

    String getJSONResultWithBody(String url, String jsonPost) throws IOException {
        this.logger.trace("Call to Annotation API (POST) with body: " + url);
        return this.getHttpConnection().getURLContentWithBody(url, jsonPost);
    }

    String getJSONResultWithBodyAndHeader(String url, String jsonPost, String headerName, String headerValue) throws IOException {
        this.logger.trace("Call to Annotation API (POST) with body: " + url);
        return this.getHttpConnection().getURLContentWithBody(url, jsonPost, headerName, headerValue);
    }

    ResponseEntity<String> postURL(String url, String jsonPost, String headerName, String headerValue) throws IOException {
        this.logger.trace("Call to Annotation API (POST) with body: " + url + ". Returns body, headers and status code.");
        return this.getHttpConnection().postURL(url, jsonPost, headerName, headerValue);
    }

    ResponseEntity<String> postURL(String url, String jsonPost) throws IOException {
        this.logger.trace("Call to Annotation API (POST) with body: " + url + ". Returns body, headers and status code.");
        return this.getHttpConnection().postURL(url, jsonPost);
    }

    ResponseEntity<String> putURL(String url, String jsonPut, String headerName, String headerValue) throws IOException {
        this.logger.trace("Call to Annotation API (PUT) with body: " + url + ". Returns body, headers and status code.");
        ResponseEntity<String> response = this.getHttpConnection().putURL(url, jsonPut, headerName, headerValue);
        response.getStatusCode();
        return response;
    }

    public ResponseEntity<String> getURL(String url) throws IOException {
        this.logger.trace("Call to Annotation API (GET): " + url + ". Returns body, headers and status code.");
        return this.getHttpConnection().getURL(url);
    }

    public ResponseEntity<String> getURLWithHeader(String url, String headerName, String headerValue) throws IOException {
        this.logger.trace("Call to Annotation API (GET): " + url + ". Returns body, headers and status code.");
        return this.getHttpConnection().getURLWithHeader(url, headerName, headerValue);
    }

    ResponseEntity<String> deleteURL(String url, String headerName, String headerValue) throws IOException {
        this.logger.trace("Call to Annotation API (DELETE): " + url + ". Returns headers and status code.");
        return this.getHttpConnection().deleteURL(url, headerName, headerValue);
    }

    ResponseEntity<String> removeURL(String url, String headerName, String headerValue) throws IOException {
        this.logger.trace("Call to Annotation API (remove): " + url + ". Returns headers and status code.");
        return this.getHttpConnection().deleteURL(url, headerName, headerValue);
    }

    String encodeUrl(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, "UTF-8");
    }
}

