/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.client.connection;

import eu.europeana.annotation.client.config.ClientConfiguration;
import eu.europeana.annotation.client.connection.BaseApiConnection;
import eu.europeana.annotation.client.exception.TechnicalRuntimeException;
import eu.europeana.annotation.client.model.result.AnnotationOperationResponse;
import eu.europeana.annotation.client.model.result.AnnotationSearchResults;
import eu.europeana.annotation.client.model.result.WhitelistOperationResponse;
import eu.europeana.annotation.definitions.model.Annotation;
import eu.europeana.annotation.definitions.model.search.SearchProfiles;
import eu.europeana.annotation.definitions.model.search.result.AnnotationPage;
import eu.europeana.annotation.definitions.model.whitelist.WhitelistEntry;
import eu.europeana.annotation.utils.JsonUtils;
import eu.europeana.annotation.utils.parse.AnnotationPageParser;
import eu.europeana.annotation.utils.parse.WhiteListParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.stanbol.commons.exception.JsonParseException;
import org.apache.stanbol.commons.jsonld.JsonLdParser;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.http.ResponseEntity;

public class AnnotationApiConnection
extends BaseApiConnection {
    private static final String AND = "&";
    private static final String EQUALS = "=";
    private static final String JSON_LD = ".jsonld";
    String authorizationHeaderName = "Authorization";
    String regularUserAuthorizationValue = null;
    String adminUserAuthorizationValue = null;
    public static String USER_REGULAR = "regular";
    public static String USER_ADMIN = "admin";
    Map<String, String> userTokens = new HashMap<String, String>();

    public AnnotationApiConnection(String annotationServiceUri, String apiKey) {
        super(annotationServiceUri, apiKey);
        this.initConfigurations();
    }

    public AnnotationApiConnection() {
        this(ClientConfiguration.getInstance().getServiceUri(), ClientConfiguration.getInstance().getApiKey());
        this.initConfigurations();
    }

    private void initConfigurations() {
    }

    private String getAuthorizationHeaderValue(String user) {
        return this.getOauthToken(user);
    }

    public AnnotationSearchResults getAnnotationsForObject(String collectionId, String objectHash) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "/" + collectionId + "/" + objectHash + ".json";
        url = (String)url + "?wsKey=" + this.getApiKey() + "&profile=annotation";
        String json = this.getJSONResult((String)url);
        return this.getAnnotationSearchResults(json);
    }

    public AnnotationSearchResults getAnnotationLd(String provider, Long annotationNr, String apikey) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "/";
        if (StringUtils.isNotEmpty((CharSequence)provider)) {
            url = (String)url + provider + "/";
        }
        if (annotationNr != null) {
            url = (String)url + annotationNr + "?";
        }
        String resApiKey = this.getApiKey();
        if (apikey != null) {
            resApiKey = apikey;
        }
        url = (String)url + "wskey=" + resApiKey;
        String json = this.getJSONResultWithHeader((String)url, this.authorizationHeaderName, this.regularUserAuthorizationValue);
        AnnotationSearchResults asr = new AnnotationSearchResults();
        asr.setJson(json);
        return asr;
    }

    public AnnotationSearchResults searchAnnotationLd(String target, String resourceId) throws IOException {
        String url = this.getAnnotationServiceUri() + "/";
        url = url + "search.jsonld?";
        url = url + "wskey=ws&";
        if (StringUtils.isNotEmpty((CharSequence)target)) {
            url = url + "target=" + target;
        }
        if (StringUtils.isNotEmpty((CharSequence)resourceId)) {
            url = url + "resourceId=" + resourceId;
        }
        String json = this.getJSONResult(url);
        AnnotationSearchResults asr = new AnnotationSearchResults();
        asr.setJson(json);
        return asr;
    }

    public AnnotationOperationResponse createEuropeanaAnnotationLd(String motivation, Long annotationNr, String europeanaLdStr, String apikey) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "/?";
        String resApiKey = this.getApiKey();
        if (apikey != null) {
            resApiKey = apikey;
        }
        url = (String)url + "wskey=" + resApiKey + AND;
        url = (String)url + "userToken=tester1&";
        if (annotationNr != null) {
            url = (String)url + "identifier=" + annotationNr + AND;
        }
        url = (String)url + "indexOnCreate=true";
        String json = this.getJSONResultWithBodyAndHeader((String)url, europeanaLdStr, this.authorizationHeaderName, this.regularUserAuthorizationValue);
        AnnotationOperationResponse aor = new AnnotationOperationResponse();
        aor.setSuccess("true");
        aor.setAction("create:/annotation.jsonld");
        aor.setJson(json);
        return aor;
    }

    public ResponseEntity<String> createAnnotation(Boolean indexOnCreate, String annotation, String annoType, String user) throws IOException {
        Object url = this.getAnnotationServiceUri();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        if (annoType != null) {
            url = (String)url + annoType + JSON_LD;
        }
        url = (String)url + "?";
        if (indexOnCreate != null) {
            url = (String)url + "indexOnCreate=" + indexOnCreate;
        }
        this.logger.trace("Ivoking create annotation: " + (String)url);
        return this.postURL((String)url, annotation, this.authorizationHeaderName, this.getAuthorizationHeaderValue(user));
    }

    public ResponseEntity<String> createAnnotationReport(String wskey, long identifier, String userToken) throws IOException {
        Object url = this.getAnnotationServiceUri();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + identifier + "/";
        url = (String)url + "report";
        url = (String)url + "?";
        url = (String)url + "wskey=" + wskey + AND;
        url = (String)url + "userToken=" + userToken;
        this.logger.trace("Ivoking create annotation report: " + (String)url);
        return this.postURL((String)url, "", this.authorizationHeaderName, this.regularUserAuthorizationValue);
    }

    public ResponseEntity<String> getAnnotation(String wskey, long identifier, boolean isTypeJsonld) throws IOException {
        String url = this.getAnnotationServiceUri() + "/";
        url = url + identifier;
        if (isTypeJsonld) {
            url = url + JSON_LD;
        }
        url = url + "?";
        url = url + "wskey=" + wskey + AND;
        return this.getURL(url);
    }

    public ResponseEntity<String> getAnnotation(String wskey, long identifier, boolean isTypeJsonld, SearchProfiles searchProfile) throws IOException {
        String url = this.getAnnotationServiceUri() + "/";
        url = url + identifier;
        if (isTypeJsonld) {
            url = url + JSON_LD;
        }
        url = url + "?";
        url = url + "wskey=" + wskey + AND;
        url = url + "profile=" + searchProfile.toString();
        return this.getURLWithHeader(url, this.authorizationHeaderName, this.regularUserAuthorizationValue);
    }

    public ResponseEntity<String> getAnnotation(long identifier, boolean isTypeJsonld, SearchProfiles searchProfile) throws IOException {
        String url = this.getAnnotationServiceUri() + "/";
        url = url + identifier;
        if (isTypeJsonld) {
            url = url + JSON_LD;
        }
        url = url + "?";
        url = url + "profile=" + searchProfile.toString();
        return this.getURLWithHeader(url, this.authorizationHeaderName, this.regularUserAuthorizationValue);
    }

    public ResponseEntity<String> getModerationReport(String wskey, long identifier) throws IOException {
        Object url = this.getAnnotationServiceUri();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + identifier + "/";
        url = (String)url + "moderationsummary";
        url = (String)url + "?";
        url = (String)url + "wskey=" + wskey + AND;
        this.logger.trace("Ivoking get annotation moderation report: " + (String)url);
        return this.getURLWithHeader((String)url, this.authorizationHeaderName, this.regularUserAuthorizationValue);
    }

    public ResponseEntity<String> updateAnnotation(long identifier, String updateAnnotation, String user) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "/" + identifier;
        return this.putURL((String)url, updateAnnotation, this.authorizationHeaderName, this.getAuthorizationHeaderValue(user));
    }

    public ResponseEntity<String> deleteAnnotation(long identifier, String user) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "/" + identifier;
        return this.deleteURL((String)url, this.authorizationHeaderName, this.getAuthorizationHeaderValue(user));
    }

    public ResponseEntity<String> removeAnnotation(long identifier) throws IOException {
        String url = this.getAnnotationServiceUri();
        Object urlRemovedLastAnnotationPart = url.substring(0, url.lastIndexOf("/"));
        urlRemovedLastAnnotationPart = (String)urlRemovedLastAnnotationPart + "/admin/annotation/delete";
        ResponseEntity<String> response = this.removeURL((String)(urlRemovedLastAnnotationPart = (String)urlRemovedLastAnnotationPart + "?identifier=" + identifier), this.authorizationHeaderName, this.adminUserAuthorizationValue);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new TechnicalRuntimeException("Remote method invocation failed: " + (String)response.getBody());
        }
        return response;
    }

    public AnnotationOperationResponse createAnnotation(String annotationJsonLdStr) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "annotation.jsonld?";
        url = (String)url + "wskey=ws&";
        String json = this.getJSONResultWithBody((String)url, annotationJsonLdStr);
        AnnotationOperationResponse aor = new AnnotationOperationResponse();
        aor.setSuccess("true");
        aor.setAction("create:/annotations/collection/object.json");
        String annotationJsonString = JsonUtils.extractAnnotationStringFromJsonString((String)json);
        aor.setAnnotation(JsonUtils.toAnnotationObject((String)annotationJsonString));
        return aor;
    }

    public AnnotationPage search(String query, String page, String pageSize) throws IOException, JsonParseException {
        return this.search(query, page, pageSize, SearchProfiles.STANDARD, null);
    }

    public AnnotationPage search(String query, String page, String pageSize, SearchProfiles searchProfile, String language) throws IOException, JsonParseException {
        return this.search(query, null, null, null, page, pageSize, searchProfile, language);
    }

    public AnnotationPage search(String query, String qf, String sort, String sortOrder, String page, String pageSize, SearchProfiles searchProfile, String language) throws IOException, JsonParseException {
        String url = this.buildUrl(query, qf, sort, sortOrder, page, pageSize, searchProfile.toString(), language);
        String json = this.getJSONResult(url);
        return this.getAnnotationPage(json);
    }

    public AnnotationPage getAnnotationPage(String json) throws JsonParseException {
        AnnotationPageParser apParser = new AnnotationPageParser();
        AnnotationPage ap = apParser.parseAnnotationPage(json);
        return ap;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationSearchResults getAnnotationSearchResults(String json) {
        AnnotationSearchResults asr = new AnnotationSearchResults();
        asr.setSuccess("true");
        asr.setAction("create:/annotations/search");
        String annotationListJsonString = JsonUtils.extractAnnotationListStringFromJsonString((String)json, (String)"\":(.*?)}]");
        if (StringUtils.isNotEmpty((CharSequence)annotationListJsonString) && !annotationListJsonString.isEmpty()) {
            annotationListJsonString = annotationListJsonString.substring(1, annotationListJsonString.length() - 1);
            String[] arrValue = JsonLdParser.splitAnnotationListStringToArray((String)annotationListJsonString);
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (String string : arrValue) {
                void var9_9;
                if (!string.startsWith("{")) {
                    String string2 = "{" + string;
                }
                Annotation annotationObject = JsonUtils.toAnnotationObject((String)((String)var9_9 + "}}"));
                annotationList.add(annotationObject);
            }
            asr.setItems(annotationList);
        }
        return asr;
    }

    private String buildUrl(String query, String qf, String sort, String sortOrder, String page, String pageSize, String profile, String language) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "/search?wskey=" + this.getApiKey();
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            url = (String)url + "&profile=" + profile;
        }
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            url = (String)url + "&query=" + this.encodeUrl(query);
        }
        if (StringUtils.isNotEmpty((CharSequence)qf)) {
            url = (String)url + "&qf=" + this.encodeUrl(qf);
        }
        if (StringUtils.isNotEmpty((CharSequence)sort)) {
            url = (String)url + "&sort=" + sort;
        }
        if (StringUtils.isNotEmpty((CharSequence)sortOrder)) {
            url = (String)url + "&sortOrder=" + sortOrder;
        }
        url = StringUtils.isNotEmpty((CharSequence)page) ? (String)url + "&page=" + page : (String)url + "&page=1";
        url = StringUtils.isNotEmpty((CharSequence)pageSize) ? (String)url + "&pageSize=" + pageSize : (String)url + "&pageSize=10";
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            url = (String)url + "&language=" + language;
        }
        return url;
    }

    public AnnotationPage search(String query) throws IOException, JsonParseException {
        return this.search(query, null, null);
    }

    public AnnotationOperationResponse getAnnotation(String europeanaId, long identifier) throws IOException {
        Object url = this.getAnnotationServiceUri();
        if (!europeanaId.startsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + europeanaId;
        url = (String)url + "/" + identifier;
        url = (String)url + "?wsKey=" + this.getApiKey() + "&profile=annotation";
        String json = this.getJSONResult((String)url);
        return (AnnotationOperationResponse)this.getAnnotationGson().fromJson(json, AnnotationOperationResponse.class);
    }

    public AnnotationOperationResponse setAnnotationStatus(long identifier, String status) throws IOException {
        Object url = this.getAnnotationServiceUri().replace("annotations", "admin");
        url = (String)url + "/set/status/" + identifier + ".json?";
        if (identifier != 0L) {
            url = (String)url + "identifier=" + identifier + AND;
        }
        url = (String)url + "status=" + status;
        String json = this.getJSONResultWithBody((String)url, status);
        AnnotationOperationResponse aor = new AnnotationOperationResponse();
        aor.setSuccess("true");
        aor.setAction("set:/annotations/set/status/object.json");
        aor.setJson(json);
        return aor;
    }

    public AnnotationOperationResponse searchAnnotationStatusLogs(String status, String startOn, String limit) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "/statuslogs/search?";
        url = (String)url + "status=" + status + AND;
        url = (String)url + "startOn=" + startOn + AND;
        url = (String)url + "limit=" + limit;
        String json = this.getJSONResult((String)url);
        AnnotationOperationResponse aor = new AnnotationOperationResponse();
        aor.setSuccess("true");
        aor.setAction("search:/statuslogs.json");
        aor.setJson(json);
        return aor;
    }

    public AnnotationOperationResponse getAnnotationStatus(long identifier) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "/get/status/" + identifier + ".json?";
        if (identifier != 0L) {
            url = (String)url + "identifier=" + identifier;
        }
        String json = this.getJSONResult((String)url);
        AnnotationOperationResponse aor = new AnnotationOperationResponse();
        aor.setSuccess("true");
        aor.setAction("get:/annotations/get/status/object.json");
        aor.setJson(json);
        return aor;
    }

    public AnnotationOperationResponse disableAnnotation(long identifier) throws IOException {
        Object url = this.getAnnotationServiceUri();
        url = (String)url + "/admin/annotation/disable/" + identifier + ".json";
        String json = this.getJSONResultWithBody((String)url, "");
        AnnotationOperationResponse aor = new AnnotationOperationResponse();
        aor.setSuccess("true");
        aor.setAction("put:/admin/annotation/disable/object.json");
        aor.setJson(json);
        return aor;
    }

    public AnnotationOperationResponse checkVisibility(Annotation annotation, String user) throws IOException {
        Object url = this.getAnnotationServiceUri();
        long identifier = annotation.getIdentifier();
        url = (String)url + "/check/visibility/" + identifier + "/" + user + ".json?";
        if (identifier != 0L) {
            url = (String)url + "identifier=" + identifier + AND;
        }
        url = (String)url + "user=" + user;
        String json = this.getJSONResult((String)url);
        AnnotationOperationResponse aor = new AnnotationOperationResponse();
        aor.setSuccess("true");
        aor.setAction("get:/annotations/check/visibility/object.json");
        aor.setJson(json);
        return aor;
    }

    public WhitelistOperationResponse createWhitelistEntry(String whitelistEntryJson) throws IOException {
        String action = "create";
        String url = this.getWhitelistServiceUrl(action);
        String json = (String)this.postURL(url, whitelistEntryJson, this.authorizationHeaderName, this.adminUserAuthorizationValue).getBody();
        WhitelistOperationResponse aor = new WhitelistOperationResponse();
        aor.setSuccess("true");
        aor.setAction("create:/whitelist");
        String whitelistJsonString = "";
        try {
            JSONObject mainObject = new JSONObject(json);
            JSONObject whitelistEntry = mainObject.getJSONObject("whitelistEntry");
            whitelistJsonString = whitelistEntry.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        aor.setWhitelistEntry(WhiteListParser.toWhitelistEntry((String)whitelistJsonString));
        aor.setJson(json);
        return aor;
    }

    protected String getWhitelistServiceBaseUri() {
        return this.getAnnotationServiceUri().replace("annotation", "whitelist") + "/";
    }

    public WhitelistOperationResponse loadWhitelist() throws IOException {
        String action = "load";
        String url = this.getWhitelistServiceUrl(action);
        String json = this.getJSONResult(url);
        WhitelistOperationResponse aor = new WhitelistOperationResponse();
        aor.setSuccess("true");
        aor.setAction("load:/whitelist");
        ArrayList<WhitelistEntry> resList = new ArrayList<WhitelistEntry>();
        try {
            JSONObject mainObject = new JSONObject(json);
            JSONArray whitelistEntries = mainObject.getJSONArray("items");
            for (int i = 0; i < whitelistEntries.length(); ++i) {
                JSONObject entry = (JSONObject)whitelistEntries.get(0);
                WhitelistEntry whitelistEntry = WhiteListParser.toWhitelistEntry((String)entry.toString());
                resList.add(whitelistEntry);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        aor.setWhitelistEntries(resList);
        aor.setJson(json);
        return aor;
    }

    protected String getWhitelistServiceUrl(String action) {
        String url = this.getWhitelistServiceBaseUri() + action;
        return url;
    }

    public WhitelistOperationResponse getWhitelistEntry(String httpUrl) throws IOException {
        String action = "search";
        Object url = this.getWhitelistServiceUrl(action);
        url = (String)url + "?url=" + httpUrl;
        String json = this.getJSONResultWithHeader((String)url, this.authorizationHeaderName, this.adminUserAuthorizationValue);
        WhitelistOperationResponse aor = new WhitelistOperationResponse();
        aor.setSuccess("true");
        aor.setAction("search:/whitelist");
        String whitelistJsonString = "";
        try {
            JSONObject mainObject = new JSONObject(json);
            JSONObject whitelistEntry = mainObject.getJSONObject("whitelistEntry");
            whitelistJsonString = whitelistEntry.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        aor.setWhitelistEntry(WhiteListParser.toWhitelistEntry((String)whitelistJsonString));
        aor.setJson(json);
        return aor;
    }

    public WhitelistOperationResponse getWhitelist() throws IOException {
        String action = "view";
        String url = this.getWhitelistServiceUrl(action);
        String json = this.getJSONResultWithHeader(url, this.authorizationHeaderName, this.adminUserAuthorizationValue);
        WhitelistOperationResponse aor = new WhitelistOperationResponse();
        aor.setSuccess("true");
        aor.setAction("view:/whitelist");
        ArrayList<WhitelistEntry> resList = new ArrayList<WhitelistEntry>();
        try {
            JSONObject mainObject = new JSONObject(json);
            JSONArray whitelistEntries = mainObject.getJSONArray("items");
            for (int i = 0; i < whitelistEntries.length(); ++i) {
                JSONObject entry = (JSONObject)whitelistEntries.get(0);
                WhitelistEntry whitelistEntry = WhiteListParser.toWhitelistEntry((String)entry.toString());
                resList.add(whitelistEntry);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        aor.setWhitelistEntries(resList);
        aor.setJson(json);
        return aor;
    }

    public ResponseEntity<String> deleteWhitelistEntry(String httpUrl) throws IOException {
        String action = "delete";
        Object url = this.getWhitelistServiceUrl(action);
        url = (String)url + "?url=" + httpUrl;
        return this.deleteURL((String)url, this.authorizationHeaderName, this.adminUserAuthorizationValue);
    }

    public ResponseEntity<String> deleteWholeWhitelist() throws IOException {
        String action = "deleteall";
        String url = this.getWhitelistServiceUrl(action);
        return this.deleteURL(url, this.authorizationHeaderName, this.adminUserAuthorizationValue);
    }

    public ResponseEntity<String> deleteAnnotationForGood(long identifier) throws IOException {
        String action = "delete";
        this.logger.debug("Annotation service URI: " + this.getAnnotationServiceUri());
        String adminAnnotationServiceUri = this.getAnnotationServiceUri().replace("annotation", "admin/annotation");
        this.logger.trace("Admin annotation service URI: " + adminAnnotationServiceUri);
        String url = adminAnnotationServiceUri + "/" + action;
        url = url + "&identifier=" + identifier;
        this.logger.trace("Delete Annotation request URL: " + url);
        ResponseEntity<String> re = this.deleteURL(url, this.authorizationHeaderName, this.adminUserAuthorizationValue);
        this.logger.trace(re.toString());
        return re;
    }

    public ResponseEntity<String> reindexOutdated() throws IOException {
        String action = "reindexoutdated";
        this.logger.debug("Annotation service URI: " + this.getAnnotationServiceUri());
        Object adminAnnotationServiceUri = StringUtils.removeEnd((String)this.getAnnotationServiceUri(), (String)"annotation");
        adminAnnotationServiceUri = (String)adminAnnotationServiceUri + "admin/annotation";
        this.logger.trace("Admin annotation service URI: " + (String)adminAnnotationServiceUri);
        String url = (String)adminAnnotationServiceUri + "/" + action;
        this.logger.trace("(Re)index outdated annotations request URL: " + url);
        ResponseEntity<String> res = this.putURL(url, null, this.authorizationHeaderName, this.adminUserAuthorizationValue);
        this.logger.trace("(Re)index outdated annotations HTTP status: " + res.getStatusCode().toString());
        return res;
    }

    public ResponseEntity<String> uploadAnnotations(String tag, Boolean indexOnCreate) throws IOException {
        String url = this.getAnnotationServiceUri() + "s";
        url = url + "/";
        url = url + "?";
        url = url + "indexOnCreate=" + indexOnCreate;
        this.logger.debug("Upload annotations request URL: " + url);
        return this.postURL(url, tag, this.authorizationHeaderName, this.regularUserAuthorizationValue);
    }

    public String getDeleted(String motivation, String from, String to, int page, int limit) throws IOException, JsonParseException {
        String url = this.getAnnotationServiceUri() + "s/deleted";
        boolean hasAtLeastOneParam = false;
        if (from != null) {
            if (!hasAtLeastOneParam) {
                url = url + "?from=" + from;
                hasAtLeastOneParam = true;
            } else {
                url = url + "&from=" + from;
            }
        }
        if (to != null) {
            if (!hasAtLeastOneParam) {
                url = url + "?to=" + to;
                hasAtLeastOneParam = true;
            } else {
                url = url + "&to=" + to;
            }
        }
        url = url + "&page=" + page;
        url = url + "&limit=" + limit;
        if (motivation != null) {
            if (!hasAtLeastOneParam) {
                url = url + "motivation=" + motivation;
                hasAtLeastOneParam = true;
            } else {
                url = url + "&motivation=" + motivation;
            }
        }
        url = url + "&wskey=" + this.getApiKey();
        this.logger.debug("Get deleted annotation ids with URL: " + url);
        return this.getJSONResult(url);
    }

    public String getOauthToken(String user) {
        if (this.userTokens.containsKey(user)) {
            return this.userTokens.get(user);
        }
        String userToken = null;
        try {
            String oauthUri = ClientConfiguration.getInstance().getOauthServiceUri();
            String oauthParams = ClientConfiguration.getInstance().getOauthRequestParams(user);
            PostMethod post = new PostMethod(oauthUri);
            if (StringUtils.isNotBlank((CharSequence)oauthParams)) {
                post.setRequestBody(oauthParams);
                post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            }
            HttpClient client = new HttpClient();
            try {
                client.executeMethod((HttpMethod)post);
                if (post.getResponseBody() != null && post.getResponseBody().length > 0) {
                    byte[] byteResponse = post.getResponseBody();
                    String jsonResponse = new String(byteResponse, StandardCharsets.UTF_8);
                    JSONObject jo = new JSONObject(jsonResponse);
                    userToken = "Bearer " + jo.getString("access_token");
                    this.userTokens.put(user, userToken);
                }
            }
            catch (JSONException e) {
                throw new TechnicalRuntimeException("Cannot retrieve authentication token!", (Exception)((Object)e));
            }
            finally {
                post.releaseConnection();
            }
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Cannot retrieve authentication token!", e);
        }
        return userToken;
    }
}

