/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.client.config;

import eu.europeana.annotation.client.exception.TechnicalRuntimeException;
import java.io.InputStream;
import java.util.Properties;

public class ClientConfiguration {
    protected static final String ANNOTATION_CLIENT_PROPERTIES_FILE = "/annotation-client.properties";
    public static final String PROP_ANNOTATION_API_KEY = "annotation.api.key";
    public static final String PROP_ANNOTATION_SERVICE_BASE_URI = "annotation.service.uri";
    public static final String PROP_ANNOTATION_ID_BASE_URI = "annotation.id.baseUrl";
    public static final String PROP_ANNOTATION_ITEM_DATA_ENDPOINT = "annotation.item.data.endpoint";
    public static final String PROP_ANNOTATION_CLIENT_API_ENDPOINT = "annotation.client.api.endpoint";
    public static final String PROP_AUTHORIZATION_HEADER_NAME = "annotation.header.name";
    public static final String PROP_REGULAR_AUTHORIZATION_HEADER_VALUE = "annotation.regular.authorization.value";
    public static final String PROP_ADMIN_ANNOTATION_HEADER_VALUE = "annotation.admin.authorization.value";
    public static final String PROP_OAUTH_SERVICE_URI = "oauth.service.uri";
    public static final String PROP_OAUTH_REQUEST_PARAMS_PREFIX = "oauth.token.request.params.";
    private static Properties properties = null;
    private static ClientConfiguration singleton;

    private ClientConfiguration() {
    }

    public static synchronized ClientConfiguration getInstance() {
        if (singleton == null) {
            singleton = new ClientConfiguration();
            singleton.loadProperties();
        }
        return singleton;
    }

    public ClientConfiguration(Properties properties) {
        ClientConfiguration.properties = properties;
    }

    public synchronized void loadProperties() {
        try {
            properties = new Properties();
            InputStream resourceAsStream = this.getClass().getResourceAsStream(ANNOTATION_CLIENT_PROPERTIES_FILE);
            if (resourceAsStream == null) {
                throw new TechnicalRuntimeException("No properties file found in classpath! /annotation-client.properties");
            }
            this.getProperties().load(resourceAsStream);
        }
        catch (Exception e) {
            throw new TechnicalRuntimeException("Cannot read configuration file: /annotation-client.properties", e);
        }
    }

    Properties getProperties() {
        return properties;
    }

    String getConfigurationFile() {
        return ANNOTATION_CLIENT_PROPERTIES_FILE;
    }

    public String getApiKey() {
        return this.getProperties().getProperty(PROP_ANNOTATION_API_KEY).trim();
    }

    public String getServiceUri() {
        return this.getProperties().getProperty(PROP_ANNOTATION_SERVICE_BASE_URI).trim();
    }

    public String getAnnotationIdBaseUri() {
        return this.getProperties().getProperty(PROP_ANNOTATION_ID_BASE_URI).trim();
    }

    @Deprecated
    public String getHeaderName() {
        return this.getProperties().getProperty(PROP_AUTHORIZATION_HEADER_NAME).trim();
    }

    public String getAuthorizationHeaderValue() {
        return this.getProperties().getProperty(PROP_REGULAR_AUTHORIZATION_HEADER_VALUE).trim();
    }

    public String getAuthorizationHeaderValueForAdmin() {
        return this.getProperties().getProperty(PROP_ADMIN_ANNOTATION_HEADER_VALUE).trim();
    }

    public String getOauthServiceUri() {
        return this.getProperties().getProperty(PROP_OAUTH_SERVICE_URI).trim();
    }

    public String getOauthRequestParams(String user) {
        return this.getProperties().getProperty(PROP_OAUTH_REQUEST_PARAMS_PREFIX + user).trim();
    }

    public String getPropAnnotationItemDataEndpoint() {
        return this.getProperties().getProperty(PROP_ANNOTATION_ITEM_DATA_ENDPOINT).trim();
    }

    public String getPropAnnotationClientApiEndpoint() {
        return this.getProperties().getProperty(PROP_ANNOTATION_CLIENT_API_ENDPOINT).trim();
    }
}

