/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.client;

import eu.europeana.annotation.client.BaseAnnotationApi;
import eu.europeana.annotation.client.WhitelistJsonApi;
import eu.europeana.annotation.client.config.ClientConfiguration;
import eu.europeana.annotation.client.connection.AnnotationApiConnection;
import eu.europeana.annotation.client.exception.TechnicalRuntimeException;
import eu.europeana.annotation.client.model.result.WhitelistOperationResponse;
import eu.europeana.annotation.definitions.model.whitelist.WhitelistEntry;
import java.io.IOException;
import java.util.List;
import org.springframework.http.ResponseEntity;

public class WhitelistJsonApiImpl
extends BaseAnnotationApi
implements WhitelistJsonApi {
    public WhitelistJsonApiImpl(ClientConfiguration configuration, AnnotationApiConnection apiConnection) {
        super(configuration, apiConnection);
    }

    public WhitelistJsonApiImpl() {
    }

    @Override
    public List<? extends WhitelistEntry> loadWhitelistFromResources() {
        WhitelistOperationResponse res;
        try {
            res = this.apiConnection.loadWhitelist();
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the WhitelistEntryJsonApi", e);
        }
        return res.getWhitelistEntries();
    }

    @Override
    public WhitelistEntry storeWhitelistEntry(String whitelistEntryJson) {
        WhitelistOperationResponse res;
        try {
            res = this.apiConnection.createWhitelistEntry(whitelistEntryJson);
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the WhitelistEntryJsonApi", e);
        }
        return res.getWhitelistEntry();
    }

    @Override
    public WhitelistEntry updateWhitelistEntry(WhitelistEntry whitelist) {
        return null;
    }

    @Override
    public ResponseEntity<String> deleteWhitelistEntry(String url) {
        ResponseEntity<String> res;
        try {
            res = this.apiConnection.deleteWhitelistEntry(url);
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the WhitelistEntryJsonApi", e);
        }
        return res;
    }

    @Override
    public WhitelistEntry getWhitelistEntryByUrl(String url) {
        WhitelistOperationResponse res;
        try {
            res = this.apiConnection.getWhitelistEntry(url);
            if (!Boolean.valueOf(res.getSuccess()).booleanValue()) {
                throw new TechnicalRuntimeException(res.getError() + " " + res.getAction());
            }
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the WhitelistEntryApi", e);
        }
        return res.getWhitelistEntry();
    }

    @Override
    public WhitelistEntry getWhitelistEntryByName(String name) {
        return null;
    }

    @Override
    public List<? extends WhitelistEntry> getWhitelist() {
        WhitelistOperationResponse res;
        try {
            res = this.apiConnection.getWhitelist();
            if (!Boolean.valueOf(res.getSuccess()).booleanValue()) {
                throw new TechnicalRuntimeException(res.getError() + " " + res.getAction());
            }
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the WhitelistEntryApi", e);
        }
        return res.getWhitelistEntries();
    }

    @Override
    public ResponseEntity<String> deleteWholeWhitelist() {
        ResponseEntity<String> res;
        try {
            res = this.apiConnection.deleteWholeWhitelist();
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the WhitelistEntryJsonApi", e);
        }
        return res;
    }
}

