/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.client;

import eu.europeana.annotation.client.BaseAnnotationApi;
import eu.europeana.annotation.client.EuropeanaLdApi;
import eu.europeana.annotation.client.config.ClientConfiguration;
import eu.europeana.annotation.client.connection.AnnotationApiConnection;
import eu.europeana.annotation.client.exception.TechnicalRuntimeException;
import eu.europeana.annotation.client.model.result.AnnotationOperationResponse;
import eu.europeana.annotation.client.model.result.AnnotationSearchResults;
import java.io.IOException;

public class EuropeanaLdApiImpl
extends BaseAnnotationApi
implements EuropeanaLdApi {
    public EuropeanaLdApiImpl(ClientConfiguration configuration, AnnotationApiConnection apiConnection) {
        super(configuration, apiConnection);
    }

    public EuropeanaLdApiImpl() {
    }

    @Override
    public String createAnnotationLd(String motivation, Long annotationNr, String europeanaLdStr) {
        return this.createAnnotationLd(motivation, annotationNr, europeanaLdStr, null);
    }

    @Override
    public String createAnnotationLd(String motivation, Long annotationNr, String europeanaLdStr, String apikey) {
        AnnotationOperationResponse res;
        try {
            res = this.apiConnection.createEuropeanaAnnotationLd(motivation, annotationNr, europeanaLdStr, apikey);
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the EuropenaLdApi for createEuropeanaAnnotationLd method", e);
        }
        return res.getJson();
    }

    @Override
    public String getAnnotationLd(String provider, Long annotationNr) {
        return this.getAnnotationLd(provider, annotationNr, null);
    }

    @Override
    public String getAnnotationLd(String provider, Long annotationNr, String apikey) {
        AnnotationSearchResults res;
        try {
            res = this.apiConnection.getAnnotationLd(provider, annotationNr, apikey);
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the EuropenaLdApi for getAnnotationLd method", e);
        }
        return res.getJson();
    }

    @Override
    public String searchLd(String target, String resourceId) {
        AnnotationSearchResults res;
        try {
            res = this.apiConnection.searchAnnotationLd(target, resourceId);
        }
        catch (IOException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the EuropenaLdApi for searchAnnotationLd method", e);
        }
        return res.getJson();
    }

    public AnnotationSearchResults getAnnotationSearchResults(String json) {
        AnnotationSearchResults res = this.apiConnection.getAnnotationSearchResults(json);
        return res;
    }
}

