/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.annotation.client;

import eu.europeana.annotation.client.AnnotationSearchApi;
import eu.europeana.annotation.client.BaseAnnotationApi;
import eu.europeana.annotation.client.config.ClientConfiguration;
import eu.europeana.annotation.client.connection.AnnotationApiConnection;
import eu.europeana.annotation.client.exception.TechnicalRuntimeException;
import eu.europeana.annotation.definitions.model.search.SearchProfiles;
import eu.europeana.annotation.definitions.model.search.result.AnnotationPage;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.stanbol.commons.exception.JsonParseException;

public class AnnotationSearchApiImpl
extends BaseAnnotationApi
implements AnnotationSearchApi {
    public AnnotationSearchApiImpl(ClientConfiguration configuration, AnnotationApiConnection apiConnection) {
        super(configuration, apiConnection);
    }

    public AnnotationSearchApiImpl() {
    }

    @Override
    public AnnotationPage searchAnnotations(String query) {
        AnnotationPage res;
        try {
            res = this.apiConnection.search(query);
        }
        catch (IOException | JsonParseException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the AnnotationSearchApi", (Exception)e);
        }
        return res;
    }

    @Override
    @Deprecated
    public AnnotationPage searchAnnotations(String query, SearchProfiles searchProfile, String language) {
        return this.searchAnnotations(query, null, null, null, null, searchProfile, language);
    }

    @Override
    public AnnotationPage searchAnnotations(String query, String qf, String sort, String sortOrder, String page, String pageSize, SearchProfiles searchProfile, String language) {
        AnnotationPage res;
        try {
            res = this.apiConnection.search(query, qf, sort, sortOrder, page, pageSize, searchProfile, language);
        }
        catch (IOException | JsonParseException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the AnnotationSearchApi", (Exception)e);
        }
        return res;
    }

    @Override
    @Deprecated
    public AnnotationPage searchAnnotations(String query, String page, String pageSize, String field, String language) {
        return this.searchAnnotations(query, page, pageSize, field, language, SearchProfiles.STANDARD, null);
    }

    @Override
    public AnnotationPage searchAnnotations(String query, String page, String pageSize, String field, String language, SearchProfiles searchProfile, String paramLanguage) {
        AnnotationPage res;
        try {
            if (StringUtils.isNotEmpty((CharSequence)field) && StringUtils.isNotEmpty((CharSequence)language)) {
                query = AnnotationSearchApiImpl.addFieldToQuery(query, field, language);
            }
            res = this.apiConnection.search(query, page, pageSize, searchProfile, paramLanguage);
        }
        catch (IOException | JsonParseException e) {
            throw new TechnicalRuntimeException("Exception occured when invoking the AnnotationSearchApi", (Exception)e);
        }
        return res;
    }

    public static String addFieldToQuery(String query, String field, String language) {
        if (StringUtils.isNotEmpty((CharSequence)field)) {
            Object prefix = "EN_";
            if (field.equals("multilingual")) {
                if (StringUtils.isNotEmpty((CharSequence)language) && field.equals("multilingual")) {
                    prefix = language.toUpperCase() + "_";
                }
            } else {
                prefix = "";
            }
            query = (String)prefix + field + "*:*" + (String)query;
        } else {
            query = "*:*";
        }
        return query;
    }
}

