/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.annosync.config;

import eu.europeana.fulltext.util.GeneralUtils;
import eu.europeana.fulltext.util.SettingsUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:annosync.properties"}), @PropertySource(value={"classpath:annosync.user.properties"}, ignoreResourceNotFound=true)})
public class AnnoSyncSettings
implements InitializingBean {
    @Value(value="${mongo.connectionUrl}")
    private String mongoConnectionUrl;
    @Value(value="${mongo.fulltext.database}")
    private String fulltextDatabase;
    @Value(value="${annotations.wskey}")
    private String annotationsApiKey;
    @Value(value="${annotations.serviceurl}")
    private String annotationsApiUrl;
    @Value(value="${spring.profiles.active:}")
    private String activeProfileString;
    @Value(value="${batch.annotations.pageSize: 100}")
    private int annotationItemsPageSize;
    @Value(value="${batch.executor.corePool: 5}")
    private int batchCorePoolSize;
    @Value(value="${batch.step.skipLimit: 10}")
    private int batchSkipLimit;
    @Value(value="${batch.executor.maxPool: 10}")
    private int batchMaxPoolSize;
    @Value(value="${batch.step.executor.queueSize: 5}")
    private int batchQueueSize;
    @Value(value="${batch.step.throttleLimit: 5}")
    private int annoSyncThrottleLimit;
    @Value(value="${annosync.mail.enabled}")
    private boolean annoSyncMailEnabled;
    @Value(value="${annosync.mail.from:}")
    private String mailFrom;
    @Value(value="${annosync.mail.to:}")
    private String mailTo;
    @Value(value="${annosync.mail.cc:}")
    private String mailCc;
    @Value(value="${fulltext.deployment:}")
    private String deploymentName;
    @Value(value="${webclient.maxBufferMb:16}")
    private int maxBufferMb;
    @Value(value="${annotations.retry:3}")
    private int retryLimit;

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public String getAnnotationsApiUrl() {
        return this.annotationsApiUrl;
    }

    public int getAnnotationItemsPageSize() {
        return this.annotationItemsPageSize;
    }

    public int getBatchCorePoolSize() {
        return this.batchCorePoolSize;
    }

    public int getBatchMaxPoolSize() {
        return this.batchMaxPoolSize;
    }

    public int getBatchQueueSize() {
        return this.batchQueueSize;
    }

    public int getAnnoSyncThrottleLimit() {
        return this.annoSyncThrottleLimit;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public String getMailCc() {
        return this.mailCc;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public boolean annoSyncMailEnabled() {
        return this.annoSyncMailEnabled;
    }

    public int getMaxBufferMb() {
        return this.maxBufferMb;
    }

    public int getSkipLimit() {
        return this.batchSkipLimit;
    }

    public String getAnnotationsApiKey() {
        return this.annotationsApiKey;
    }

    public void afterPropertiesSet() throws Exception {
        if (GeneralUtils.testProfileNotActive((String)this.activeProfileString)) {
            this.validateRequiredSettings();
        }
    }

    private void validateRequiredSettings() {
        ArrayList missingProps = new ArrayList();
        HashMap<String, String> singleValidations = new HashMap<String, String>();
        singleValidations.put(this.annotationsApiKey, "annotations.wskey");
        singleValidations.put(this.annotationsApiUrl, "annotations.serviceurl");
        SettingsUtils.validateValues(Map.of(this.deploymentName, "fulltext.deployment"), missingProps);
        SettingsUtils.validateValues(singleValidations, missingProps);
        if (!missingProps.isEmpty()) {
            throw new IllegalStateException(String.format("The following config properties are not set: %s", String.join((CharSequence)"\n", missingProps)));
        }
    }

    public String getMongoConnectionUrl() {
        return this.mongoConnectionUrl;
    }

    public String getFulltextDatabase() {
        return this.fulltextDatabase;
    }
}

