/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.annosync.config;

import eu.europeana.fulltext.CommonBeanConfig;
import eu.europeana.fulltext.annosync.config.AnnoSyncSettings;
import eu.europeana.fulltext.service.AnnotationApiRestService;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
public class AnnoSyncBeanConfig {
    private final AnnoSyncSettings settings;

    public AnnoSyncBeanConfig(AnnoSyncSettings settings) {
        this.settings = settings;
    }

    @Bean
    @Primary
    public SpringTemplateEngine springTemplateEngine() {
        SpringTemplateEngine springTemplateEngine = new SpringTemplateEngine();
        springTemplateEngine.addTemplateResolver((ITemplateResolver)this.emailTemplateResolver());
        return springTemplateEngine;
    }

    @Bean
    public AnnotationApiRestService annotationApiRestService() {
        return new AnnotationApiRestService(CommonBeanConfig.createWebClient(Optional.ofNullable(this.settings.getAnnotationsApiUrl()), (int)this.settings.getMaxBufferMb()), this.settings.getAnnotationsApiKey());
    }

    private ClassLoaderTemplateResolver emailTemplateResolver() {
        ClassLoaderTemplateResolver emailTemplateResolver = new ClassLoaderTemplateResolver();
        emailTemplateResolver.setPrefix("/templates/");
        emailTemplateResolver.setSuffix(".html");
        emailTemplateResolver.setTemplateMode(TemplateMode.HTML);
        emailTemplateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        emailTemplateResolver.setCacheable(false);
        return emailTemplateResolver;
    }

    @Bean(value={"jobLauncherTaskExecutor"})
    public TaskExecutor jobLauncherTaskExecutor() {
        return new SyncTaskExecutor();
    }

    @Bean(value={"annoSyncTaskExecutor"})
    public TaskExecutor annoSyncTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.settings.getBatchCorePoolSize());
        taskExecutor.setMaxPoolSize(this.settings.getBatchMaxPoolSize());
        taskExecutor.setQueueCapacity(this.settings.getBatchQueueSize());
        return taskExecutor;
    }
}

