/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.annosync.batch.writer;

import eu.europeana.fulltext.annosync.batch.AnnoSyncStats;
import eu.europeana.fulltext.annosync.service.AnnoSyncService;
import eu.europeana.fulltext.util.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.item.ItemWriter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class AnnoPageDeprecationWriter
implements ItemWriter<String> {
    private final AnnoSyncService annoSyncService;
    private final AnnoSyncStats statsCounter;

    public AnnoPageDeprecationWriter(AnnoSyncService annoSyncService, AnnoSyncStats statsCounter) {
        this.annoSyncService = annoSyncService;
        this.statsCounter = statsCounter;
    }

    public void write(@NonNull List<? extends String> deletedAnnotations) throws Exception {
        long deletedCount = this.annoSyncService.deprecateAnnoPagesWithSources(this.getSourceIdFromAnnotations(deletedAnnotations));
        int i = 0;
        while ((long)i < deletedCount) {
            this.statsCounter.addDeprecated();
            ++i;
        }
    }

    private List<String> getSourceIdFromAnnotations(List<? extends String> deletedAnnotations) {
        ArrayList<String> sources = new ArrayList<String>();
        deletedAnnotations.stream().forEach(annotation -> {
            if (StringUtils.startsWith((CharSequence)annotation, (CharSequence)"http")) {
                sources.add((String)annotation);
            } else {
                sources.add(GeneralUtils.getAnnotationPageURI((String)("/" + annotation)));
            }
        });
        return sources;
    }
}

