/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.annosync.batch.reader;

import eu.europeana.fulltext.service.AnnotationApiRestService;
import eu.europeana.fulltext.subtitles.external.AnnotationItem;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.batch.item.data.AbstractPaginatedDataItemReader;

public class AnnotationItemReader
extends AbstractPaginatedDataItemReader<AnnotationItem> {
    private static final Logger logger = LogManager.getLogger(AnnotationItemReader.class);
    private final AnnotationApiRestService annotationsRestService;
    private final Instant from;
    private final Instant to;

    public AnnotationItemReader(AnnotationApiRestService annotationsRestService, int pageSize, Instant from, Instant to) {
        this.setPageSize(pageSize);
        this.annotationsRestService = annotationsRestService;
        this.from = from;
        this.to = to;
        this.setSaveState(false);
    }

    String getClassName() {
        return AnnotationItemReader.class.getSimpleName();
    }

    protected Iterator<AnnotationItem> doPageRead() {
        List searchResponse = this.annotationsRestService.getAnnotations(this.page, this.pageSize, this.from, this.to);
        if (searchResponse == null || searchResponse.isEmpty()) {
            logger.info("No results found in page:{} , pageSize:{}, from: {}, to: {} ", (Object)this.page, (Object)this.pageSize, (Object)this.from, (Object)this.to);
            return null;
        }
        logger.info("Fetched Annotations ids - {} ", (Object)searchResponse.size());
        return searchResponse.iterator();
    }

    protected void doOpen() throws Exception {
        super.doOpen();
        this.setName(this.getClassName());
    }
}

