/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.fulltext.annosync.config;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.MapperOptions;
import eu.europeana.fulltext.annosync.config.AnnoSyncSettings;
import eu.europeana.fulltext.util.MorphiaUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AnnoSyncDataConfig {
    private static final Logger logger = LogManager.getLogger(AnnoSyncDataConfig.class);
    private final AnnoSyncSettings settings;

    public AnnoSyncDataConfig(AnnoSyncSettings settings) {
        this.settings = settings;
    }

    @Bean
    public Datastore fulltextDatastore() {
        String fulltextDatabase = this.settings.getFulltextDatabase();
        logger.info("Configuring fulltext database: {}", (Object)fulltextDatabase);
        return Morphia.createDatastore((MongoClient)MongoClients.create((String)this.settings.getMongoConnectionUrl()), (String)fulltextDatabase, (MapperOptions)MorphiaUtils.MAPPER_OPTIONS);
    }
}

