/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.sdk1;

import eu.europa.ted.eforms.sdk.selector.component.VersionDependentComponent;
import eu.europa.ted.eforms.sdk.selector.component.VersionDependentComponentType;
import eu.europa.ted.efx.interfaces.EfxTemplateTranslator;
import eu.europa.ted.efx.interfaces.MarkupGenerator;
import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.ContentBlock;
import eu.europa.ted.efx.model.ContentBlockStack;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.Expression;
import eu.europa.ted.efx.model.Markup;
import eu.europa.ted.efx.sdk1.EfxExpressionTranslatorV1;
import eu.europa.ted.efx.sdk1.EfxLexer;
import eu.europa.ted.efx.sdk1.EfxParser;
import eu.europa.ted.efx.xpath.XPathAttributeLocator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VersionDependentComponent(versions={"1"}, componentType=VersionDependentComponentType.EFX_TEMPLATE_TRANSLATOR)
public class EfxTemplateTranslatorV1
extends EfxExpressionTranslatorV1
implements EfxTemplateTranslator {
    private static final Logger logger = LoggerFactory.getLogger(EfxTemplateTranslatorV1.class);
    private static final String INCONSISTENT_INDENTATION_SPACES = "Inconsistent indentation. Expected a multiple of %d spaces.";
    private static final String INDENTATION_LEVEL_SKIPPED = "Indentation level skipped.";
    private static final String START_INDENT_AT_ZERO = "Incorrect indentation. Please do not indent the first level in your template.";
    private static final String MIXED_INDENTATION = "Do not mix indentation methods. Stick with either tabs or spaces.";
    private static final String UNEXPECTED_INDENTATION = "Unexpected indentation tracker state.";
    private static final String LABEL_TYPE_NAME = EfxLexer.VOCABULARY.getLiteralName(35).replaceAll("^'|'$", "");
    private static final String LABEL_TYPE_WHEN = EfxLexer.VOCABULARY.getLiteralName(36).replaceAll("^'|'$", "").replace("-true", "");
    private static final String SHORTHAND_CONTEXT_FIELD_LABEL_REFERENCE = EfxLexer.VOCABULARY.getLiteralName(12).replaceAll("^'|'$", "");
    private static final String ASSET_TYPE_INDICATOR = EfxLexer.VOCABULARY.getLiteralName(28).replaceAll("^'|'$", "");
    private static final String ASSET_TYPE_BT = EfxLexer.VOCABULARY.getLiteralName(20).replaceAll("^'|'$", "");
    private static final String ASSET_TYPE_FIELD = EfxLexer.VOCABULARY.getLiteralName(21).replaceAll("^'|'$", "");
    private static final String ASSET_TYPE_NODE = EfxLexer.VOCABULARY.getLiteralName(22).replaceAll("^'|'$", "");
    private static final String ASSET_TYPE_CODE = EfxLexer.VOCABULARY.getLiteralName(27).replaceAll("^'|'$", "");
    private Indent indentWith = Indent.UNDETERMINED;
    private int indentSpaces = -1;
    MarkupGenerator markup;
    final ContentBlock rootBlock = ContentBlock.newRootBlock();
    ContentBlockStack blockStack = new ContentBlockStack();

    private EfxTemplateTranslatorV1() {
    }

    public EfxTemplateTranslatorV1(MarkupGenerator markupGenerator, SymbolResolver symbolResolver, ScriptGenerator scriptGenerator, BaseErrorListener errorListener) {
        super(symbolResolver, scriptGenerator, errorListener);
        this.markup = markupGenerator;
    }

    @Override
    public String renderTemplate(Path pathname) throws IOException {
        return this.renderTemplate(CharStreams.fromPath((Path)pathname));
    }

    @Override
    public String renderTemplate(String template) {
        return this.renderTemplate((CharStream)CharStreams.fromString((String)template));
    }

    @Override
    public String renderTemplate(InputStream stream) throws IOException {
        return this.renderTemplate(CharStreams.fromStream((InputStream)stream));
    }

    private String renderTemplate(CharStream charStream) {
        logger.debug("Rendering template");
        EfxLexer lexer = new EfxLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        EfxParser parser = new EfxParser((TokenStream)tokens);
        if (this.errorListener != null) {
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.TemplateFileContext tree = parser.templateFile();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)this, (ParseTree)tree);
        logger.debug("Finished rendering template");
        return this.getTranslatedMarkup();
    }

    private String getTranslatedMarkup() {
        logger.debug("Getting translated markup.");
        StringBuilder sb = new StringBuilder(64);
        while (!this.stack.empty()) {
            sb.insert(0, '\n').insert(0, this.stack.pop(Markup.class).script);
        }
        logger.debug("Finished getting translated markup.");
        return sb.toString().trim();
    }

    @Override
    public void enterTemplateFile(EfxParser.TemplateFileContext ctx) {
        assert (this.blockStack.isEmpty()) : "Unexpected indentation tracker state.";
    }

    @Override
    public void exitTemplateFile(EfxParser.TemplateFileContext ctx) {
        this.blockStack.pop();
        ArrayList<Markup> templateCalls = new ArrayList<Markup>();
        ArrayList<Markup> templates = new ArrayList<Markup>();
        for (ContentBlock rootBlock : this.rootBlock.getChildren()) {
            templateCalls.add(rootBlock.renderCallTemplate(this.markup));
            rootBlock.renderTemplate(this.markup, templates);
        }
        Markup file = this.markup.composeOutputFile(templateCalls, templates);
        this.stack.push(file);
    }

    @Override
    public void exitTextTemplate(EfxParser.TextTemplateContext ctx) {
        Markup template = ctx.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        String text = ctx.textBlock() != null ? ctx.textBlock().getText() : "";
        this.stack.push(this.markup.renderFreeText(text).join(template));
    }

    @Override
    public void exitLabelTemplate(EfxParser.LabelTemplateContext ctx) {
        Markup template = ctx.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        Markup label = ctx.labelBlock() != null ? this.stack.pop(Markup.class) : Markup.empty();
        this.stack.push(label.join(template));
    }

    @Override
    public void exitExpressionTemplate(EfxParser.ExpressionTemplateContext ctx) {
        Markup template = ctx.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        Expression expression = this.stack.pop(Expression.class);
        this.stack.push(this.markup.renderVariableExpression(expression).join(template));
    }

    @Override
    public void exitStandardLabelReference(EfxParser.StandardLabelReferenceContext ctx) {
        Expression.StringExpression assetId = ctx.assetId() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        Expression.StringExpression labelType = ctx.labelType() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        Expression.StringExpression assetType = ctx.assetType() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(assetType, this.script.getStringLiteralFromUnquotedString("|"), labelType, this.script.getStringLiteralFromUnquotedString("|"), assetId))));
    }

    @Override
    public void exitShorthandBtLabelReference(EfxParser.ShorthandBtLabelReferenceContext ctx) {
        Expression.StringExpression assetId = this.script.getStringLiteralFromUnquotedString(ctx.BtId().getText());
        Expression.StringExpression labelType = ctx.labelType() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_BT), this.script.getStringLiteralFromUnquotedString("|"), labelType, this.script.getStringLiteralFromUnquotedString("|"), assetId))));
    }

    @Override
    public void exitShorthandFieldLabelReference(EfxParser.ShorthandFieldLabelReferenceContext ctx) {
        Expression.StringExpression labelType;
        String fieldId = ctx.FieldId().getText();
        Expression.StringExpression stringExpression = labelType = ctx.labelType() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        if (labelType.script.equals("value")) {
            this.shorthandIndirectLabelReference(fieldId);
        } else {
            this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_FIELD), this.script.getStringLiteralFromUnquotedString("|"), labelType, this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(fieldId)))));
        }
    }

    @Override
    public void exitShorthandIndirectLabelReference(EfxParser.ShorthandIndirectLabelReferenceContext ctx) {
        this.shorthandIndirectLabelReference(ctx.FieldId().getText());
    }

    private void shorthandIndirectLabelReference(String fieldId) {
        Context currentContext = (Context)this.efxContext.peek();
        String fieldType = this.symbols.getTypeOfField(fieldId);
        XPathAttributeLocator parsedPath = XPathAttributeLocator.findAttribute(this.symbols.getAbsolutePathOfField(fieldId));
        Expression.StringExpression valueReference = parsedPath.hasAttribute() != false ? this.script.composeFieldAttributeReference(this.symbols.getRelativePath(parsedPath.getPath(), currentContext.absolutePath()), parsedPath.getAttribute(), Expression.StringExpression.class) : this.script.composeFieldValueReference(this.symbols.getRelativePathOfField(fieldId, currentContext.absolutePath()), Expression.StringExpression.class);
        switch (fieldType) {
            case "indicator": {
                this.stack.push(this.markup.renderLabelFromExpression(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_INDICATOR), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(LABEL_TYPE_WHEN), this.script.getStringLiteralFromUnquotedString("-"), valueReference, this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(fieldId)))));
                break;
            }
            case "code": 
            case "internal-code": {
                this.stack.push(this.markup.renderLabelFromExpression(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_CODE), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(LABEL_TYPE_NAME), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.symbols.getRootCodelistOfField(fieldId)), this.script.getStringLiteralFromUnquotedString("."), valueReference))));
                break;
            }
            default: {
                throw new ParseCancellationException(String.format("Unexpected field type '%s'. Expected a field of either type 'code' or 'indicator'.", fieldType));
            }
        }
    }

    @Override
    public void exitShorthandLabelReferenceFromContext(EfxParser.ShorthandLabelReferenceFromContextContext ctx) {
        String labelType = ctx.LabelType().getText();
        if (this.efxContext.isFieldContext().booleanValue()) {
            if (labelType.equals(SHORTHAND_CONTEXT_FIELD_LABEL_REFERENCE)) {
                this.shorthandIndirectLabelReference(this.efxContext.symbol());
            } else {
                this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_FIELD), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(labelType), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.efxContext.symbol())))));
            }
        } else if (this.efxContext.isNodeContext().booleanValue()) {
            this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_NODE), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(labelType), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.efxContext.symbol())))));
        }
    }

    @Override
    public void exitShorthandIndirectLabelReferenceFromContextField(EfxParser.ShorthandIndirectLabelReferenceFromContextFieldContext ctx) {
        if (!this.efxContext.isFieldContext().booleanValue()) {
            throw new ParseCancellationException("The #value shorthand syntax can only be used in a field is declared as context.");
        }
        this.shorthandIndirectLabelReference(this.efxContext.symbol());
    }

    @Override
    public void exitAssetType(EfxParser.AssetTypeContext ctx) {
        if (ctx.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(ctx.getText()));
        }
    }

    @Override
    public void exitLabelType(EfxParser.LabelTypeContext ctx) {
        if (ctx.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(ctx.getText()));
        }
    }

    @Override
    public void exitAssetId(EfxParser.AssetIdContext ctx) {
        if (ctx.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(ctx.getText()));
        }
    }

    @Override
    public void exitStandardExpressionBlock(EfxParser.StandardExpressionBlockContext ctx) {
        this.stack.push(this.stack.pop(Expression.class));
    }

    @Override
    public void exitShorthandFieldValueReferenceFromContextField(EfxParser.ShorthandFieldValueReferenceFromContextFieldContext ctx) {
        if (!this.efxContext.isFieldContext().booleanValue()) {
            throw new ParseCancellationException("The $value shorthand syntax can only be used when a field is declared as the context.");
        }
        this.stack.push(this.script.composeFieldValueReference(this.symbols.getRelativePathOfField(this.efxContext.symbol(), this.efxContext.absolutePath()), Expression.class));
    }

    @Override
    public void exitContextDeclarationBlock(EfxParser.ContextDeclarationBlockContext ctx) {
        String filedId = EfxTemplateTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(ctx);
        if (filedId != null) {
            this.efxContext.push(new Context.FieldContext(filedId, this.stack.pop(Expression.PathExpression.class)));
        } else {
            String nodeId = EfxTemplateTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext(ctx);
            assert (nodeId != null) : "We should have been able to locate the FieldId or NodeId declared as context.";
            this.efxContext.push(new Context.NodeContext(nodeId, this.stack.pop(Expression.PathExpression.class)));
        }
    }

    @Override
    public void exitTemplateLine(EfxParser.TemplateLineContext ctx) {
        Context lineContext = (Context)this.efxContext.pop();
        int indentLevel = this.getIndentLevel(ctx);
        int indentChange = indentLevel - this.blockStack.currentIndentationLevel();
        Markup content = ctx.template() != null ? this.stack.pop(Markup.class) : new Markup("");
        Integer outlineNumber = ctx.OutlineNumber() != null ? Integer.parseInt(ctx.OutlineNumber().getText().trim()) : -1;
        assert (this.stack.isEmpty()) : "Stack should be empty at this point.";
        if (indentChange > 1) {
            throw new ParseCancellationException(INDENTATION_LEVEL_SKIPPED);
        }
        if (indentChange == 1) {
            if (this.blockStack.isEmpty()) {
                throw new ParseCancellationException(START_INDENT_AT_ZERO);
            }
            this.blockStack.pushChild(outlineNumber, content, this.relativizeContext(lineContext, this.blockStack.currentContext()));
        } else if (indentChange < 0) {
            for (int i = indentChange; i < 0; ++i) {
                assert (!this.blockStack.isEmpty()) : "Unexpected indentation tracker state.";
                assert (this.blockStack.currentIndentationLevel() > indentLevel) : "Unexpected indentation tracker state.";
                this.blockStack.pop();
            }
            assert (this.blockStack.currentIndentationLevel() == indentLevel) : "Unexpected indentation tracker state.";
            this.blockStack.pushSibling(outlineNumber, content, this.relativizeContext(lineContext, this.blockStack.parentContext()));
        } else if (indentChange == 0) {
            if (this.blockStack.isEmpty()) {
                assert (indentLevel == 0) : "Unexpected indentation tracker state.";
                this.blockStack.push(this.rootBlock.addChild(outlineNumber, content, this.relativizeContext(lineContext, this.rootBlock.getContext())));
            } else {
                this.blockStack.pushSibling(outlineNumber, content, this.relativizeContext(lineContext, this.blockStack.parentContext()));
            }
        }
    }

    private Context relativizeContext(Context childContext, Context parentContext) {
        if (parentContext == null) {
            return childContext;
        }
        if (Context.FieldContext.class.isAssignableFrom(childContext.getClass())) {
            return new Context.FieldContext(childContext.symbol(), childContext.absolutePath(), this.symbols.getRelativePath(childContext.absolutePath(), parentContext.absolutePath()));
        }
        assert (Context.NodeContext.class.isAssignableFrom(childContext.getClass())) : "Child context should be either a FieldContext NodeContext.";
        return new Context.NodeContext(childContext.symbol(), childContext.absolutePath(), this.symbols.getRelativePath(childContext.absolutePath(), parentContext.absolutePath()));
    }

    private int getIndentLevel(EfxParser.TemplateLineContext ctx) {
        if (ctx.MixedIndent() != null) {
            throw new ParseCancellationException(MIXED_INDENTATION);
        }
        if (ctx.Spaces() != null) {
            if (this.indentWith == Indent.UNDETERMINED) {
                this.indentWith = Indent.SPACES;
                this.indentSpaces = ctx.Spaces().getText().length();
            } else if (this.indentWith == Indent.TABS) {
                throw new ParseCancellationException(MIXED_INDENTATION);
            }
            if (ctx.Spaces().getText().length() % this.indentSpaces != 0) {
                throw new ParseCancellationException(String.format(INCONSISTENT_INDENTATION_SPACES, this.indentSpaces));
            }
            return ctx.Spaces().getText().length() / this.indentSpaces;
        }
        if (ctx.Tabs() != null) {
            if (this.indentWith == Indent.UNDETERMINED) {
                this.indentWith = Indent.TABS;
            } else if (this.indentWith == Indent.SPACES) {
                throw new ParseCancellationException(MIXED_INDENTATION);
            }
            return ctx.Tabs().getText().length();
        }
        return 0;
    }

    private static enum Indent {
        TABS,
        SPACES,
        UNDETERMINED;

    }
}

