/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.sdk1;

import eu.europa.ted.eforms.sdk.selector.component.VersionDependentComponent;
import eu.europa.ted.eforms.sdk.selector.component.VersionDependentComponentType;
import eu.europa.ted.efx.interfaces.EfxExpressionTranslator;
import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.CallStack;
import eu.europa.ted.efx.model.CallStackObjectBase;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.ContextStack;
import eu.europa.ted.efx.model.Expression;
import eu.europa.ted.efx.sdk1.EfxBaseListener;
import eu.europa.ted.efx.sdk1.EfxLexer;
import eu.europa.ted.efx.sdk1.EfxParser;
import eu.europa.ted.efx.xpath.XPathAttributeLocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;

@VersionDependentComponent(versions={"1"}, componentType=VersionDependentComponentType.EFX_EXPRESSION_TRANSLATOR)
public class EfxExpressionTranslatorV1
extends EfxBaseListener
implements EfxExpressionTranslator {
    private static final String NOT_MODIFIER = EfxLexer.VOCABULARY.getLiteralName(91).replaceAll("^'|'$", "");
    private static final String BEGIN_EXPRESSION_BLOCK = "{";
    private static final String END_EXPRESSION_BLOCK = "}";
    private static final String TYPE_MISMATCH_CANNOT_COMPARE_VALUES_OF_DIFFERENT_TYPES = "Type mismatch. Cannot compare values of different types: ";
    protected CallStack stack = new CallStack();
    protected ContextStack efxContext;
    protected SymbolResolver symbols;
    protected BaseErrorListener errorListener;
    protected ScriptGenerator script;
    private LinkedList<String> expressionParameters = new LinkedList();

    protected EfxExpressionTranslatorV1() {
    }

    public EfxExpressionTranslatorV1(SymbolResolver symbolResolver, ScriptGenerator scriptGenerator, BaseErrorListener errorListener) {
        this.symbols = symbolResolver;
        this.script = scriptGenerator;
        this.errorListener = errorListener;
        this.efxContext = new ContextStack(this.symbols);
    }

    @Override
    public String translateExpression(String expression, String ... parameters) {
        this.expressionParameters.addAll(Arrays.asList(parameters));
        EfxLexer lexer = new EfxLexer((CharStream)CharStreams.fromString((String)expression));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        EfxParser parser = new EfxParser((TokenStream)tokens);
        if (this.errorListener != null) {
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.SingleExpressionContext tree = parser.singleExpression();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)this, (ParseTree)tree);
        return this.getTranslatedScript();
    }

    private <T extends Expression> T translateParameter(String parameterValue, Class<T> parameterType) {
        EfxExpressionTranslatorV1 translator = new EfxExpressionTranslatorV1(this.symbols, this.script, this.errorListener);
        EfxLexer lexer = new EfxLexer((CharStream)CharStreams.fromString((String)(BEGIN_EXPRESSION_BLOCK + parameterValue + END_EXPRESSION_BLOCK)));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        EfxParser parser = new EfxParser((TokenStream)tokens);
        if (this.errorListener != null) {
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.ParameterValueContext tree = parser.parameterValue();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)translator, (ParseTree)tree);
        return Expression.instantiate(translator.getTranslatedScript(), parameterType);
    }

    private String getTranslatedScript() {
        StringBuilder sb = new StringBuilder(this.stack.size() * 100);
        while (!this.stack.empty()) {
            sb.insert(0, '\n').insert(0, this.stack.pop(Expression.class).script);
        }
        return sb.toString().trim();
    }

    protected static String getFieldIdFromChildSimpleFieldReferenceContext(ParserRuleContext ctx) {
        if (ctx instanceof EfxParser.SimpleFieldReferenceContext) {
            return ((EfxParser.SimpleFieldReferenceContext)ctx).FieldId().getText();
        }
        if (ctx instanceof EfxParser.AbsoluteFieldReferenceContext) {
            return ((EfxParser.AbsoluteFieldReferenceContext)ctx).reference.reference.simpleFieldReference().FieldId().getText();
        }
        if (ctx instanceof EfxParser.FieldReferenceWithFieldContextOverrideContext) {
            return ((EfxParser.FieldReferenceWithFieldContextOverrideContext)ctx).reference.reference.simpleFieldReference().FieldId().getText();
        }
        if (ctx instanceof EfxParser.FieldReferenceWithNodeContextOverrideContext) {
            return ((EfxParser.FieldReferenceWithNodeContextOverrideContext)ctx).reference.reference.reference.simpleFieldReference().FieldId().getText();
        }
        EfxParser.SimpleFieldReferenceContext fieldReferenceContext = (EfxParser.SimpleFieldReferenceContext)ctx.getChild(EfxParser.SimpleFieldReferenceContext.class, 0);
        if (fieldReferenceContext != null) {
            return fieldReferenceContext.FieldId().getText();
        }
        for (ParseTree child : ctx.children) {
            String fieldId;
            if (!(child instanceof ParserRuleContext) || (fieldId = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext((ParserRuleContext)child)) == null) continue;
            return fieldId;
        }
        return null;
    }

    protected static String getNodeIdFromChildSimpleNodeReferenceContext(ParserRuleContext ctx) {
        if (ctx instanceof EfxParser.SimpleNodeReferenceContext) {
            return ((EfxParser.SimpleNodeReferenceContext)ctx).NodeId().getText();
        }
        for (ParseTree child : ctx.children) {
            String nodeId;
            if (!(child instanceof ParserRuleContext) || (nodeId = EfxExpressionTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext((ParserRuleContext)child)) == null) continue;
            return nodeId;
        }
        return null;
    }

    @Override
    public void enterSingleExpression(EfxParser.SingleExpressionContext ctx) {
        TerminalNode fieldContext = ctx.FieldId();
        if (fieldContext != null) {
            this.efxContext.pushFieldContext(fieldContext.getText());
        } else {
            TerminalNode nodeContext = ctx.NodeId();
            if (nodeContext != null) {
                this.efxContext.pushNodeContext(nodeContext.getText());
            }
        }
    }

    @Override
    public void exitSingleExpression(EfxParser.SingleExpressionContext ctx) {
        this.efxContext.pop();
    }

    @Override
    public void exitParenthesizedBooleanExpression(EfxParser.ParenthesizedBooleanExpressionContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.BooleanExpression.class), Expression.BooleanExpression.class));
    }

    @Override
    public void exitLogicalAndCondition(EfxParser.LogicalAndConditionContext ctx) {
        Expression.BooleanExpression right = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression left = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeLogicalAnd(left, right));
    }

    @Override
    public void exitLogicalOrCondition(EfxParser.LogicalOrConditionContext ctx) {
        Expression.BooleanExpression right = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression left = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeLogicalOr(left, right));
    }

    @Override
    public void exitFieldValueComparison(EfxParser.FieldValueComparisonContext ctx) {
        Expression right = this.stack.pop(Expression.class);
        Expression left = this.stack.pop(Expression.class);
        if (!left.getClass().equals(right.getClass())) {
            throw new ParseCancellationException(TYPE_MISMATCH_CANNOT_COMPARE_VALUES_OF_DIFFERENT_TYPES + left.getClass() + " and " + right.getClass());
        }
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitStringComparison(EfxParser.StringComparisonContext ctx) {
        Expression.StringExpression right = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression left = this.stack.pop(Expression.StringExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitNumericComparison(EfxParser.NumericComparisonContext ctx) {
        Expression.NumericExpression right = this.stack.pop(Expression.NumericExpression.class);
        Expression.NumericExpression left = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitBooleanComparison(EfxParser.BooleanComparisonContext ctx) {
        Expression.BooleanExpression right = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression left = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitDateComparison(EfxParser.DateComparisonContext ctx) {
        Expression.DateExpression right = this.stack.pop(Expression.DateExpression.class);
        Expression.DateExpression left = this.stack.pop(Expression.DateExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitTimeComparison(EfxParser.TimeComparisonContext ctx) {
        Expression.TimeExpression right = this.stack.pop(Expression.TimeExpression.class);
        Expression.TimeExpression left = this.stack.pop(Expression.TimeExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitDurationComparison(EfxParser.DurationComparisonContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DurationExpression left = this.stack.pop(Expression.DurationExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitEmptinessCondition(EfxParser.EmptinessConditionContext ctx) {
        Expression.StringExpression expression = this.stack.pop(Expression.StringExpression.class);
        String operator = ctx.modifier != null && ctx.modifier.getText().equals(NOT_MODIFIER) ? "!=" : "==";
        this.stack.push(this.script.composeComparisonOperation(expression, operator, this.script.getStringLiteralFromUnquotedString("")));
    }

    @Override
    public void exitPresenceCondition(EfxParser.PresenceConditionContext ctx) {
        Expression.PathExpression reference = this.stack.pop(Expression.PathExpression.class);
        if (ctx.modifier != null && ctx.modifier.getText().equals(NOT_MODIFIER)) {
            this.stack.push(this.script.composeLogicalNot(this.script.composeExistsCondition(reference)));
        } else {
            this.stack.push(this.script.composeExistsCondition(reference));
        }
    }

    @Override
    public void exitUniqueValueCondition(EfxParser.UniqueValueConditionContext ctx) {
        Expression.PathExpression haystack = this.stack.pop(Expression.PathExpression.class);
        Expression.PathExpression needle = this.stack.pop(Expression.PathExpression.class);
        if (ctx.modifier != null && ctx.modifier.getText().equals(NOT_MODIFIER)) {
            this.stack.push(this.script.composeLogicalNot(this.script.composeUniqueValueCondition(needle, haystack)));
        } else {
            this.stack.push(this.script.composeUniqueValueCondition(needle, haystack));
        }
    }

    @Override
    public void exitLikePatternCondition(EfxParser.LikePatternConditionContext ctx) {
        Expression.StringExpression expression = this.stack.pop(Expression.StringExpression.class);
        Expression.BooleanExpression condition = this.script.composePatternMatchCondition(expression, ctx.pattern.getText());
        if (ctx.modifier != null && ctx.modifier.getText().equals(NOT_MODIFIER)) {
            condition = this.script.composeLogicalNot(condition);
        }
        this.stack.push(condition);
    }

    @Override
    public void exitStringInListCondition(EfxParser.StringInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitBooleanInListCondition(EfxParser.BooleanInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitNumberInListCondition(EfxParser.NumberInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitDateInListCondition(EfxParser.DateInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitTimeInListCondition(EfxParser.TimeInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitDurationInListCondition(EfxParser.DurationInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    private <T extends Expression, L extends Expression.ListExpression<T>> void exitInListCondition(Token modifier, Class<T> expressionType, Class<L> listType) {
        Expression.ListExpression list = (Expression.ListExpression)this.stack.pop(listType);
        Expression expression = (Expression)this.stack.pop(expressionType);
        Expression.BooleanExpression condition = this.script.composeContainsCondition(expression, list);
        if (modifier != null && modifier.getText().equals(NOT_MODIFIER)) {
            condition = this.script.composeLogicalNot(condition);
        }
        this.stack.push(condition);
    }

    @Override
    public void exitQuantifiedExpression(EfxParser.QuantifiedExpressionContext ctx) {
        Expression.BooleanExpression booleanExpression = this.stack.pop(Expression.BooleanExpression.class);
        if (ctx.Every() != null) {
            this.stack.push(this.script.composeAllSatisfy(this.stack.pop(Expression.IteratorListExpression.class), booleanExpression));
        } else {
            this.stack.push(this.script.composeAnySatisfies(this.stack.pop(Expression.IteratorListExpression.class), booleanExpression));
        }
    }

    @Override
    public void exitAdditionExpression(EfxParser.AdditionExpressionContext ctx) {
        Expression.NumericExpression right = this.stack.pop(Expression.NumericExpression.class);
        Expression.NumericExpression left = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeNumericOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitMultiplicationExpression(EfxParser.MultiplicationExpressionContext ctx) {
        Expression.NumericExpression right = this.stack.pop(Expression.NumericExpression.class);
        Expression.NumericExpression left = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeNumericOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitParenthesizedNumericExpression(EfxParser.ParenthesizedNumericExpressionContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.NumericExpression.class), Expression.NumericExpression.class));
    }

    @Override
    public void exitDurationAdditionExpression(EfxParser.DurationAdditionExpressionContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DurationExpression left = this.stack.pop(Expression.DurationExpression.class);
        this.stack.push(this.script.composeAddition(left, right));
    }

    @Override
    public void exitDurationSubtractionExpression(EfxParser.DurationSubtractionExpressionContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DurationExpression left = this.stack.pop(Expression.DurationExpression.class);
        this.stack.push(this.script.composeSubtraction(left, right));
    }

    @Override
    public void exitDurationLeftMultiplicationExpression(EfxParser.DurationLeftMultiplicationExpressionContext ctx) {
        Expression.DurationExpression duration = this.stack.pop(Expression.DurationExpression.class);
        Expression.NumericExpression number = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeMultiplication(number, duration));
    }

    @Override
    public void exitDurationRightMultiplicationExpression(EfxParser.DurationRightMultiplicationExpressionContext ctx) {
        Expression.NumericExpression number = this.stack.pop(Expression.NumericExpression.class);
        Expression.DurationExpression duration = this.stack.pop(Expression.DurationExpression.class);
        this.stack.push(this.script.composeMultiplication(number, duration));
    }

    @Override
    public void exitDateSubtractionExpression(EfxParser.DateSubtractionExpressionContext ctx) {
        Expression.DateExpression startDate = this.stack.pop(Expression.DateExpression.class);
        Expression.DateExpression endDate = this.stack.pop(Expression.DateExpression.class);
        this.stack.push(this.script.composeSubtraction(startDate, endDate));
    }

    @Override
    public void exitCodeList(EfxParser.CodeListContext ctx) {
        if (this.stack.empty()) {
            this.stack.push(this.script.composeList(Collections.emptyList(), Expression.StringListExpression.class));
        }
    }

    @Override
    public void exitStringList(EfxParser.StringListContext ctx) {
        this.exitList(ctx.stringExpression().size(), Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitBooleanList(EfxParser.BooleanListContext ctx) {
        this.exitList(ctx.booleanExpression().size(), Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitNumericList(EfxParser.NumericListContext ctx) {
        this.exitList(ctx.numericExpression().size(), Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitDateList(EfxParser.DateListContext ctx) {
        this.exitList(ctx.dateExpression().size(), Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitTimeList(EfxParser.TimeListContext ctx) {
        this.exitList(ctx.timeExpression().size(), Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitDurationList(EfxParser.DurationListContext ctx) {
        this.exitList(ctx.durationExpression().size(), Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    private <T extends Expression, L extends Expression.ListExpression<T>> void exitList(int listSize, Class<T> expressionType, Class<L> listType) {
        if (this.stack.empty() || listSize == 0) {
            this.stack.push(this.script.composeList(Collections.emptyList(), listType));
            return;
        }
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (int i = 0; i < listSize; ++i) {
            list.add(0, (Expression)this.stack.pop(expressionType));
        }
        this.stack.push(this.script.composeList(list, listType));
    }

    @Override
    public void exitUntypedConditionalExpression(EfxParser.UntypedConditionalExpressionContext ctx) {
        Class<?> typeWhenFalse = ((CallStackObjectBase)this.stack.peek()).getClass();
        if (typeWhenFalse == Expression.BooleanExpression.class) {
            this.exitConditionalBooleanExpression();
        } else if (typeWhenFalse == Expression.NumericExpression.class) {
            this.exitConditionalNumericExpression();
        } else if (typeWhenFalse == Expression.StringExpression.class) {
            this.exitConditionalStringExpression();
        } else if (typeWhenFalse == Expression.DateExpression.class) {
            this.exitConditionalDateExpression();
        } else if (typeWhenFalse == Expression.TimeExpression.class) {
            this.exitConditionalTimeExpression();
        } else if (typeWhenFalse == Expression.DurationExpression.class) {
            this.exitConditionalDurationExpression();
        } else {
            throw new IllegalStateException("Unknown type " + typeWhenFalse);
        }
    }

    @Override
    public void exitConditionalBooleanExpression(EfxParser.ConditionalBooleanExpressionContext ctx) {
        this.exitConditionalBooleanExpression();
    }

    @Override
    public void exitConditionalNumericExpression(EfxParser.ConditionalNumericExpressionContext ctx) {
        this.exitConditionalNumericExpression();
    }

    @Override
    public void exitConditionalStringExpression(EfxParser.ConditionalStringExpressionContext ctx) {
        this.exitConditionalStringExpression();
    }

    @Override
    public void exitConditionalDateExpression(EfxParser.ConditionalDateExpressionContext ctx) {
        this.exitConditionalDateExpression();
    }

    @Override
    public void exitConditionalTimeExpression(EfxParser.ConditionalTimeExpressionContext ctx) {
        this.exitConditionalTimeExpression();
    }

    @Override
    public void exitConditionalDurationExpression(EfxParser.ConditionalDurationExpressionContext ctx) {
        this.exitConditionalDurationExpression();
    }

    private void exitConditionalBooleanExpression() {
        Expression.BooleanExpression whenFalse = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression whenTrue = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.BooleanExpression.class));
    }

    private void exitConditionalNumericExpression() {
        Expression.NumericExpression whenFalse = this.stack.pop(Expression.NumericExpression.class);
        Expression.NumericExpression whenTrue = this.stack.pop(Expression.NumericExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.NumericExpression.class));
    }

    private void exitConditionalStringExpression() {
        Expression.StringExpression whenFalse = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression whenTrue = this.stack.pop(Expression.StringExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.StringExpression.class));
    }

    private void exitConditionalDateExpression() {
        Expression.DateExpression whenFalse = this.stack.pop(Expression.DateExpression.class);
        Expression.DateExpression whenTrue = this.stack.pop(Expression.DateExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.DateExpression.class));
    }

    private void exitConditionalTimeExpression() {
        Expression.TimeExpression whenFalse = this.stack.pop(Expression.TimeExpression.class);
        Expression.TimeExpression whenTrue = this.stack.pop(Expression.TimeExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.TimeExpression.class));
    }

    private void exitConditionalDurationExpression() {
        Expression.DurationExpression whenFalse = this.stack.pop(Expression.DurationExpression.class);
        Expression.DurationExpression whenTrue = this.stack.pop(Expression.DurationExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.DurationExpression.class));
    }

    @Override
    public void exitStringIteratorExpression(EfxParser.StringIteratorExpressionContext ctx) {
        this.exitIteratorExpression(Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitBooleanIteratorExpression(EfxParser.BooleanIteratorExpressionContext ctx) {
        this.exitIteratorExpression(Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitNumericIteratorExpression(EfxParser.NumericIteratorExpressionContext ctx) {
        this.exitIteratorExpression(Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitDateIteratorExpression(EfxParser.DateIteratorExpressionContext ctx) {
        this.exitIteratorExpression(Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitTimeIteratorExpression(EfxParser.TimeIteratorExpressionContext ctx) {
        this.exitIteratorExpression(Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitDurationIteratorExpression(EfxParser.DurationIteratorExpressionContext ctx) {
        this.exitIteratorExpression(Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    @Override
    public void exitContextIteratorExpression(EfxParser.ContextIteratorExpressionContext ctx) {
        Expression.PathExpression path = this.stack.pop(Expression.PathExpression.class);
        Expression.ContextExpression variable = this.stack.pop(Expression.ContextExpression.class);
        this.stack.push(this.script.composeIteratorExpression(variable.script, path));
        if (ctx.fieldContext() != null) {
            String contextFieldId = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(ctx.fieldContext());
            this.efxContext.declareContextVariable(variable.script, new Context.FieldContext(contextFieldId, this.symbols.getAbsolutePathOfField(contextFieldId), this.symbols.getRelativePathOfField(contextFieldId, this.efxContext.absolutePath())));
        } else if (ctx.nodeContext() != null) {
            String contextNodeId = EfxExpressionTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext(ctx.nodeContext());
            this.efxContext.declareContextVariable(variable.script, new Context.NodeContext(contextNodeId, this.symbols.getAbsolutePathOfNode(contextNodeId), this.symbols.getRelativePathOfNode(contextNodeId, this.efxContext.absolutePath())));
        }
    }

    @Override
    public void exitIteratorList(EfxParser.IteratorListContext ctx) {
        ArrayList<Expression.IteratorExpression> iterators = new ArrayList<Expression.IteratorExpression>();
        for (int i = 0; i < ctx.iteratorExpression().size(); ++i) {
            iterators.add(0, this.stack.pop(Expression.IteratorExpression.class));
        }
        this.stack.push(this.script.composeIteratorList(iterators));
    }

    @Override
    public void exitParenthesizedStringsFromIteration(EfxParser.ParenthesizedStringsFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.StringListExpression.class), Expression.StringListExpression.class));
    }

    @Override
    public void exitParenthesizedNumbersFromIteration(EfxParser.ParenthesizedNumbersFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.NumericListExpression.class), Expression.NumericListExpression.class));
    }

    @Override
    public void exitParenthesizedBooleansFromIteration(EfxParser.ParenthesizedBooleansFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.BooleanListExpression.class), Expression.BooleanListExpression.class));
    }

    @Override
    public void exitParenthesizedDatesFromIteration(EfxParser.ParenthesizedDatesFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.DateListExpression.class), Expression.DateListExpression.class));
    }

    @Override
    public void exitParenthesizedTimesFromIteration(EfxParser.ParenthesizedTimesFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.TimeListExpression.class), Expression.TimeListExpression.class));
    }

    @Override
    public void exitParenthesizedDurationsFromITeration(EfxParser.ParenthesizedDurationsFromITerationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.DurationListExpression.class), Expression.DurationListExpression.class));
    }

    @Override
    public void exitStringSequenceFromIteration(EfxParser.StringSequenceFromIterationContext ctx) {
        this.exitIterationExpression(Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitNumericSequenceFromIteration(EfxParser.NumericSequenceFromIterationContext ctx) {
        this.exitIterationExpression(Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitBooleanSequenceFromIteration(EfxParser.BooleanSequenceFromIterationContext ctx) {
        this.exitIterationExpression(Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitDateSequenceFromIteration(EfxParser.DateSequenceFromIterationContext ctx) {
        this.exitIterationExpression(Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitTimeSequenceFromIteration(EfxParser.TimeSequenceFromIterationContext ctx) {
        this.exitIterationExpression(Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitDurationSequenceFromIteration(EfxParser.DurationSequenceFromIterationContext ctx) {
        this.exitIterationExpression(Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    public <T extends Expression, L extends Expression.ListExpression<T>> void exitIteratorExpression(Class<T> variableType, Class<L> listType) {
        Expression.ListExpression list = (Expression.ListExpression)this.stack.pop(listType);
        Expression variable = (Expression)this.stack.pop(variableType);
        this.stack.push(this.script.composeIteratorExpression(variable.script, list));
    }

    public <T extends Expression, L extends Expression.ListExpression<T>> void exitIterationExpression(Class<T> expressionType, Class<L> targetListType) {
        Expression expression = (Expression)this.stack.pop(expressionType);
        Expression.IteratorListExpression iterators = this.stack.pop(Expression.IteratorListExpression.class);
        this.stack.push(this.script.composeForExpression(iterators, expression, targetListType));
    }

    @Override
    public void exitNumericLiteral(EfxParser.NumericLiteralContext ctx) {
        this.stack.push(this.script.getNumericLiteralEquivalent(ctx.getText()));
    }

    @Override
    public void exitStringLiteral(EfxParser.StringLiteralContext ctx) {
        this.stack.push(this.script.getStringLiteralEquivalent(ctx.getText()));
    }

    @Override
    public void exitTrueBooleanLiteral(EfxParser.TrueBooleanLiteralContext ctx) {
        this.stack.push(this.script.getBooleanEquivalent(true));
    }

    @Override
    public void exitFalseBooleanLiteral(EfxParser.FalseBooleanLiteralContext ctx) {
        this.stack.push(this.script.getBooleanEquivalent(false));
    }

    @Override
    public void exitDateLiteral(EfxParser.DateLiteralContext ctx) {
        this.stack.push(this.script.getDateLiteralEquivalent(ctx.DATE().getText()));
    }

    @Override
    public void exitTimeLiteral(EfxParser.TimeLiteralContext ctx) {
        this.stack.push(this.script.getTimeLiteralEquivalent(ctx.TIME().getText()));
    }

    @Override
    public void exitDurationLiteral(EfxParser.DurationLiteralContext ctx) {
        this.stack.push(this.script.getDurationLiteralEquivalent(ctx.getText()));
    }

    @Override
    public void exitSimpleNodeReference(EfxParser.SimpleNodeReferenceContext ctx) {
        this.stack.push(this.symbols.getRelativePathOfNode(ctx.NodeId().getText(), this.efxContext.absolutePath()));
    }

    @Override
    public void exitSimpleFieldReference(EfxParser.SimpleFieldReferenceContext ctx) {
        this.stack.push(this.symbols.getRelativePathOfField(ctx.FieldId().getText(), this.efxContext.absolutePath()));
    }

    @Override
    public void enterAbsoluteFieldReference(EfxParser.AbsoluteFieldReferenceContext ctx) {
        if (ctx.Slash() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitAbsoluteFieldReference(EfxParser.AbsoluteFieldReferenceContext ctx) {
        if (ctx.Slash() != null) {
            this.efxContext.pop();
        }
    }

    @Override
    public void enterAbsoluteNodeReference(EfxParser.AbsoluteNodeReferenceContext ctx) {
        if (ctx.Slash() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitAbsoluteNodeReference(EfxParser.AbsoluteNodeReferenceContext ctx) {
        if (ctx.Slash() != null) {
            this.efxContext.pop();
        }
    }

    @Override
    public void exitNodeReferenceWithPredicate(EfxParser.NodeReferenceWithPredicateContext ctx) {
        if (ctx.predicate() != null) {
            Expression.BooleanExpression predicate = this.stack.pop(Expression.BooleanExpression.class);
            Expression.PathExpression nodeReference = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.composeNodeReferenceWithPredicate(nodeReference, predicate, Expression.PathExpression.class));
        }
    }

    @Override
    public void exitFieldReferenceWithPredicate(EfxParser.FieldReferenceWithPredicateContext ctx) {
        if (ctx.predicate() != null) {
            Expression.BooleanExpression predicate = this.stack.pop(Expression.BooleanExpression.class);
            Expression.PathExpression fieldReference = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.composeFieldReferenceWithPredicate(fieldReference, predicate, Expression.PathExpression.class));
        }
    }

    @Override
    public void enterPredicate(EfxParser.PredicateContext ctx) {
        String nodeId = EfxExpressionTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext(ctx.getParent());
        if (nodeId != null) {
            this.efxContext.pushNodeContext(nodeId);
        } else {
            String fieldId = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(ctx.getParent());
            this.efxContext.pushFieldContext(fieldId);
        }
    }

    @Override
    public void exitPredicate(EfxParser.PredicateContext ctx) {
        this.efxContext.pop();
    }

    @Override
    public void exitFieldReferenceWithAxis(EfxParser.FieldReferenceWithAxisContext ctx) {
        if (ctx.axis() != null) {
            this.stack.push(this.script.composeFieldReferenceWithAxis(this.stack.pop(Expression.PathExpression.class), ctx.axis().Axis().getText(), Expression.PathExpression.class));
        }
    }

    @Override
    public void exitNoticeReference(EfxParser.NoticeReferenceContext ctx) {
        this.stack.push(this.script.composeExternalReference(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void enterFieldReferenceInOtherNotice(EfxParser.FieldReferenceInOtherNoticeContext ctx) {
        if (ctx.noticeReference() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitFieldReferenceInOtherNotice(EfxParser.FieldReferenceInOtherNoticeContext ctx) {
        if (ctx.noticeReference() != null) {
            Expression.PathExpression field = this.stack.pop(Expression.PathExpression.class);
            Expression.PathExpression notice = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.composeFieldInExternalReference(notice, field));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitScalarFromFieldReference(EfxParser.ScalarFromFieldReferenceContext ctx) {
        Expression.PathExpression path = this.stack.pop(Expression.PathExpression.class);
        String fieldId = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(ctx);
        XPathAttributeLocator parsedPath = XPathAttributeLocator.findAttribute(path);
        if (parsedPath.hasAttribute().booleanValue()) {
            this.stack.push(this.script.composeFieldAttributeReference(parsedPath.getPath(), parsedPath.getAttribute(), Expression.types.get(this.symbols.getTypeOfField(fieldId))));
        } else if (fieldId != null) {
            this.stack.push(this.script.composeFieldValueReference(path, Expression.types.get(this.symbols.getTypeOfField(fieldId))));
        } else {
            this.stack.push(this.script.composeFieldValueReference(path, Expression.PathExpression.class));
        }
    }

    @Override
    public void exitSequenceFromFieldReference(EfxParser.SequenceFromFieldReferenceContext ctx) {
        Expression.PathExpression path = this.stack.pop(Expression.PathExpression.class);
        String fieldId = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(ctx);
        XPathAttributeLocator parsedPath = XPathAttributeLocator.findAttribute(path);
        if (parsedPath.hasAttribute().booleanValue()) {
            this.stack.push(this.script.composeFieldAttributeReference(parsedPath.getPath(), parsedPath.getAttribute(), Expression.listTypes.get(this.symbols.getTypeOfField(fieldId))));
        } else if (fieldId != null) {
            this.stack.push(this.script.composeFieldValueReference(path, Expression.listTypes.get(this.symbols.getTypeOfField(fieldId))));
        } else {
            this.stack.push(this.script.composeFieldValueReference(path, Expression.PathExpression.class));
        }
    }

    @Override
    public void exitScalarFromAttributeReference(EfxParser.ScalarFromAttributeReferenceContext ctx) {
        this.stack.push(this.script.composeFieldAttributeReference(this.stack.pop(Expression.PathExpression.class), ctx.attributeReference().Identifier().getText(), Expression.StringExpression.class));
    }

    @Override
    public void exitContextFieldSpecifier(EfxParser.ContextFieldSpecifierContext ctx) {
        this.stack.pop(Expression.PathExpression.class);
        String contextFieldId = EfxExpressionTranslatorV1.getFieldIdFromChildSimpleFieldReferenceContext(ctx.field);
        this.efxContext.push(new Context.FieldContext(contextFieldId, this.symbols.getAbsolutePathOfField(contextFieldId), this.symbols.getRelativePathOfField(contextFieldId, this.efxContext.absolutePath())));
    }

    @Override
    public void exitFieldReferenceWithFieldContextOverride(EfxParser.FieldReferenceWithFieldContextOverrideContext ctx) {
        if (ctx.contextFieldSpecifier() != null) {
            Expression.PathExpression field = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.joinPaths(this.efxContext.relativePath(), field));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitContextNodeSpecifier(EfxParser.ContextNodeSpecifierContext ctx) {
        this.stack.pop(Expression.PathExpression.class);
        String contextNodeId = EfxExpressionTranslatorV1.getNodeIdFromChildSimpleNodeReferenceContext(ctx.node);
        this.efxContext.push(new Context.NodeContext(contextNodeId, this.symbols.getAbsolutePathOfNode(contextNodeId), this.symbols.getRelativePathOfNode(contextNodeId, this.efxContext.absolutePath())));
    }

    @Override
    public void exitFieldReferenceWithNodeContextOverride(EfxParser.FieldReferenceWithNodeContextOverrideContext ctx) {
        if (ctx.contextNodeSpecifier() != null) {
            Expression.PathExpression field = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.joinPaths(this.efxContext.relativePath(), field));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitContextVariableSpecifier(EfxParser.ContextVariableSpecifierContext ctx) {
        Expression.ContextExpression variableName = this.stack.pop(Expression.ContextExpression.class);
        Context variableContext = this.efxContext.getContextFromVariable(variableName.script);
        if (variableContext.isFieldContext().booleanValue()) {
            this.efxContext.push(new Context.FieldContext(variableContext.symbol(), this.symbols.getAbsolutePathOfField(variableContext.symbol()), this.symbols.getRelativePathOfField(variableContext.symbol(), this.efxContext.absolutePath())));
        } else if (variableContext.isNodeContext().booleanValue()) {
            this.efxContext.push(new Context.NodeContext(variableContext.symbol(), this.symbols.getAbsolutePathOfNode(variableContext.symbol()), this.symbols.getRelativePathOfNode(variableContext.symbol(), this.efxContext.absolutePath())));
        } else {
            throw new IllegalStateException("Variable context is neither a field nor a node context.");
        }
        this.stack.push(variableName);
    }

    @Override
    public void exitFieldReferenceWithVariableContextOverride(EfxParser.FieldReferenceWithVariableContextOverrideContext ctx) {
        if (ctx.contextVariableSpecifier() != null) {
            Expression.PathExpression field = this.stack.pop(Expression.PathExpression.class);
            Expression.ContextExpression variableName = this.stack.pop(Expression.ContextExpression.class);
            this.stack.push(this.script.joinPaths(new Expression.PathExpression(variableName.script), field));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitCodelistReference(EfxParser.CodelistReferenceContext ctx) {
        this.stack.push(this.script.composeList(this.symbols.expandCodelist(ctx.codeListId.getText()).stream().map(s -> this.script.getStringLiteralFromUnquotedString((String)s)).collect(Collectors.toList()), Expression.StringListExpression.class));
    }

    @Override
    public void exitVariableReference(EfxParser.VariableReferenceContext ctx) {
        this.stack.pushVariableReference(ctx.Variable().getText(), this.script.composeVariableReference(ctx.Variable().getText(), Expression.class));
    }

    @Override
    public void exitStringParameterDeclaration(EfxParser.StringParameterDeclarationContext ctx) {
        this.exitParameterDeclaration(ctx.Variable().getText(), Expression.StringExpression.class);
    }

    @Override
    public void exitNumericParameterDeclaration(EfxParser.NumericParameterDeclarationContext ctx) {
        this.exitParameterDeclaration(ctx.Variable().getText(), Expression.NumericExpression.class);
    }

    @Override
    public void exitBooleanParameterDeclaration(EfxParser.BooleanParameterDeclarationContext ctx) {
        this.exitParameterDeclaration(ctx.Variable().getText(), Expression.BooleanExpression.class);
    }

    @Override
    public void exitDateParameterDeclaration(EfxParser.DateParameterDeclarationContext ctx) {
        this.exitParameterDeclaration(ctx.Variable().getText(), Expression.DateExpression.class);
    }

    @Override
    public void exitTimeParameterDeclaration(EfxParser.TimeParameterDeclarationContext ctx) {
        this.exitParameterDeclaration(ctx.Variable().getText(), Expression.TimeExpression.class);
    }

    @Override
    public void exitDurationParameterDeclaration(EfxParser.DurationParameterDeclarationContext ctx) {
        this.exitParameterDeclaration(ctx.Variable().getText(), Expression.DurationExpression.class);
    }

    private <T extends Expression> void exitParameterDeclaration(String parameterName, Class<T> parameterType) {
        if (this.expressionParameters.isEmpty()) {
            throw new ParseCancellationException("No parameter passed for " + parameterName);
        }
        this.stack.pushParameterDeclaration(parameterName, (Expression)this.script.composeParameterDeclaration(parameterName, parameterType), (Expression)this.translateParameter(this.expressionParameters.pop(), parameterType));
    }

    @Override
    public void exitStringVariableDeclaration(EfxParser.StringVariableDeclarationContext ctx) {
        this.stack.pushVariableDeclaration(ctx.Variable().getText(), this.script.composeVariableDeclaration(ctx.Variable().getText(), Expression.StringExpression.class));
    }

    @Override
    public void exitBooleanVariableDeclaration(EfxParser.BooleanVariableDeclarationContext ctx) {
        this.stack.pushVariableDeclaration(ctx.Variable().getText(), this.script.composeVariableDeclaration(ctx.Variable().getText(), Expression.BooleanExpression.class));
    }

    @Override
    public void exitNumericVariableDeclaration(EfxParser.NumericVariableDeclarationContext ctx) {
        this.stack.pushVariableDeclaration(ctx.Variable().getText(), this.script.composeVariableDeclaration(ctx.Variable().getText(), Expression.NumericExpression.class));
    }

    @Override
    public void exitDateVariableDeclaration(EfxParser.DateVariableDeclarationContext ctx) {
        this.stack.pushVariableDeclaration(ctx.Variable().getText(), this.script.composeVariableDeclaration(ctx.Variable().getText(), Expression.DateExpression.class));
    }

    @Override
    public void exitTimeVariableDeclaration(EfxParser.TimeVariableDeclarationContext ctx) {
        this.stack.pushVariableDeclaration(ctx.Variable().getText(), this.script.composeVariableDeclaration(ctx.Variable().getText(), Expression.TimeExpression.class));
    }

    @Override
    public void exitDurationVariableDeclaration(EfxParser.DurationVariableDeclarationContext ctx) {
        this.stack.pushVariableDeclaration(ctx.Variable().getText(), this.script.composeVariableDeclaration(ctx.Variable().getText(), Expression.DurationExpression.class));
    }

    @Override
    public void exitContextVariableDeclaration(EfxParser.ContextVariableDeclarationContext ctx) {
        this.stack.pushVariableDeclaration(ctx.Variable().getText(), this.script.composeVariableDeclaration(ctx.Variable().getText(), Expression.ContextExpression.class));
    }

    @Override
    public void exitNotFunction(EfxParser.NotFunctionContext ctx) {
        this.stack.push(this.script.composeLogicalNot(this.stack.pop(Expression.BooleanExpression.class)));
    }

    @Override
    public void exitContainsFunction(EfxParser.ContainsFunctionContext ctx) {
        Expression.StringExpression needle = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression haystack = this.stack.pop(Expression.StringExpression.class);
        this.stack.push(this.script.composeContainsCondition(haystack, needle));
    }

    @Override
    public void exitStartsWithFunction(EfxParser.StartsWithFunctionContext ctx) {
        Expression.StringExpression startsWith = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression text = this.stack.pop(Expression.StringExpression.class);
        this.stack.push(this.script.composeStartsWithCondition(text, startsWith));
    }

    @Override
    public void exitEndsWithFunction(EfxParser.EndsWithFunctionContext ctx) {
        Expression.StringExpression endsWith = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression text = this.stack.pop(Expression.StringExpression.class);
        this.stack.push(this.script.composeEndsWithCondition(text, endsWith));
    }

    @Override
    public void exitSequenceEqualFunction(EfxParser.SequenceEqualFunctionContext ctx) {
        Expression.ListExpression two = this.stack.pop(Expression.ListExpression.class);
        Expression.ListExpression one = this.stack.pop(Expression.ListExpression.class);
        this.stack.push(this.script.composeSequenceEqualFunction(one, two));
    }

    @Override
    public void exitCountFunction(EfxParser.CountFunctionContext ctx) {
        this.stack.push(this.script.composeCountOperation(this.stack.pop(Expression.ListExpression.class)));
    }

    @Override
    public void exitNumberFunction(EfxParser.NumberFunctionContext ctx) {
        this.stack.push(this.script.composeToNumberConversion(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitSumFunction(EfxParser.SumFunctionContext ctx) {
        this.stack.push(this.script.composeSumOperation(this.stack.pop(Expression.NumericListExpression.class)));
    }

    @Override
    public void exitStringLengthFunction(EfxParser.StringLengthFunctionContext ctx) {
        this.stack.push(this.script.composeStringLengthCalculation(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitSubstringFunction(EfxParser.SubstringFunctionContext ctx) {
        Expression.NumericExpression length = ctx.length != null ? this.stack.pop(Expression.NumericExpression.class) : null;
        Expression.NumericExpression start = this.stack.pop(Expression.NumericExpression.class);
        Expression.StringExpression text = this.stack.pop(Expression.StringExpression.class);
        if (length != null) {
            this.stack.push(this.script.composeSubstringExtraction(text, start, length));
        } else {
            this.stack.push(this.script.composeSubstringExtraction(text, start));
        }
    }

    @Override
    public void exitToStringFunction(EfxParser.ToStringFunctionContext ctx) {
        this.stack.push(this.script.composeToStringConversion(this.stack.pop(Expression.NumericExpression.class)));
    }

    @Override
    public void exitConcatFunction(EfxParser.ConcatFunctionContext ctx) {
        if (this.stack.empty() || ctx.stringExpression().size() == 0) {
            this.stack.push(this.script.composeStringConcatenation(Collections.emptyList()));
            return;
        }
        ArrayList<Expression.StringExpression> list = new ArrayList<Expression.StringExpression>();
        for (int i = 0; i < ctx.stringExpression().size(); ++i) {
            list.add(0, this.stack.pop(Expression.StringExpression.class));
        }
        this.stack.push(this.script.composeStringConcatenation(list));
    }

    @Override
    public void exitFormatNumberFunction(EfxParser.FormatNumberFunctionContext ctx) {
        Expression.StringExpression format = this.stack.pop(Expression.StringExpression.class);
        Expression.NumericExpression number = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeNumberFormatting(number, format));
    }

    @Override
    public void exitDateFromStringFunction(EfxParser.DateFromStringFunctionContext ctx) {
        this.stack.push(this.script.composeToDateConversion(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitDatePlusMeasureFunction(EfxParser.DatePlusMeasureFunctionContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DateExpression left = this.stack.pop(Expression.DateExpression.class);
        this.stack.push(this.script.composeAddition(left, right));
    }

    @Override
    public void exitDateMinusMeasureFunction(EfxParser.DateMinusMeasureFunctionContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DateExpression left = this.stack.pop(Expression.DateExpression.class);
        this.stack.push(this.script.composeSubtraction(left, right));
    }

    @Override
    public void exitTimeFromStringFunction(EfxParser.TimeFromStringFunctionContext ctx) {
        this.stack.push(this.script.composeToTimeConversion(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitDayTimeDurationFromStringFunction(EfxParser.DayTimeDurationFromStringFunctionContext ctx) {
        this.stack.push(this.script.composeToDayTimeDurationConversion(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitYearMonthDurationFromStringFunction(EfxParser.YearMonthDurationFromStringFunctionContext ctx) {
        this.stack.push(this.script.composeToYearMonthDurationConversion(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitDistinctValuesFunction(EfxParser.DistinctValuesFunctionContext ctx) {
        Class<?> sequenceType = ((CallStackObjectBase)this.stack.peek()).getClass();
        if (Expression.StringListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitDistinctValuesFunction(Expression.StringListExpression.class);
        } else if (Expression.NumericListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitDistinctValuesFunction(Expression.NumericListExpression.class);
        } else if (Expression.BooleanListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitDistinctValuesFunction(Expression.BooleanListExpression.class);
        } else if (Expression.DateListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitDistinctValuesFunction(Expression.DateListExpression.class);
        } else if (Expression.TimeListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitDistinctValuesFunction(Expression.TimeListExpression.class);
        } else if (Expression.DurationListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitDistinctValuesFunction(Expression.DurationListExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + sequenceType.getSimpleName());
        }
    }

    private <T extends Expression, L extends Expression.ListExpression<T>> void exitDistinctValuesFunction(Class<L> listType) {
        Expression.ListExpression list = (Expression.ListExpression)this.stack.pop(listType);
        this.stack.push(this.script.composeDistinctValuesFunction(list, listType));
    }

    @Override
    public void exitUnionFunction(EfxParser.UnionFunctionContext ctx) {
        Class<?> sequenceType = ((CallStackObjectBase)this.stack.peek()).getClass();
        if (Expression.StringListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitUnionFunction(Expression.StringListExpression.class);
        } else if (Expression.NumericListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitUnionFunction(Expression.NumericListExpression.class);
        } else if (Expression.BooleanListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitUnionFunction(Expression.BooleanListExpression.class);
        } else if (Expression.DateListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitUnionFunction(Expression.DateListExpression.class);
        } else if (Expression.TimeListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitUnionFunction(Expression.TimeListExpression.class);
        } else if (Expression.DurationListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitUnionFunction(Expression.DurationListExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + sequenceType.getSimpleName());
        }
    }

    private <T extends Expression, L extends Expression.ListExpression<T>> void exitUnionFunction(Class<L> listType) {
        Expression.ListExpression two = (Expression.ListExpression)this.stack.pop(listType);
        Expression.ListExpression one = (Expression.ListExpression)this.stack.pop(listType);
        this.stack.push(this.script.composeUnionFunction(one, two, listType));
    }

    @Override
    public void exitIntersectFunction(EfxParser.IntersectFunctionContext ctx) {
        Class<?> sequenceType = ((CallStackObjectBase)this.stack.peek()).getClass();
        if (Expression.StringListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitIntersectFunction(Expression.StringListExpression.class);
        } else if (Expression.NumericListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitIntersectFunction(Expression.NumericListExpression.class);
        } else if (Expression.BooleanListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitIntersectFunction(Expression.BooleanListExpression.class);
        } else if (Expression.DateListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitIntersectFunction(Expression.DateListExpression.class);
        } else if (Expression.TimeListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitIntersectFunction(Expression.TimeListExpression.class);
        } else if (Expression.DurationListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitIntersectFunction(Expression.DurationListExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + sequenceType.getSimpleName());
        }
    }

    private <T extends Expression, L extends Expression.ListExpression<T>> void exitIntersectFunction(Class<L> listType) {
        Expression.ListExpression two = (Expression.ListExpression)this.stack.pop(listType);
        Expression.ListExpression one = (Expression.ListExpression)this.stack.pop(listType);
        this.stack.push(this.script.composeIntersectFunction(one, two, listType));
    }

    @Override
    public void exitExceptFunction(EfxParser.ExceptFunctionContext ctx) {
        Class<?> sequenceType = ((CallStackObjectBase)this.stack.peek()).getClass();
        if (Expression.StringListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitExceptFunction(Expression.StringListExpression.class);
        } else if (Expression.NumericListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitExceptFunction(Expression.NumericListExpression.class);
        } else if (Expression.BooleanListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitExceptFunction(Expression.BooleanListExpression.class);
        } else if (Expression.DateListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitExceptFunction(Expression.DateListExpression.class);
        } else if (Expression.TimeListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitExceptFunction(Expression.TimeListExpression.class);
        } else if (Expression.DurationListExpression.class.isAssignableFrom(sequenceType)) {
            this.exitExceptFunction(Expression.DurationListExpression.class);
        } else {
            throw new IllegalArgumentException("Unsupported sequence type: " + sequenceType.getSimpleName());
        }
    }

    private <T extends Expression, L extends Expression.ListExpression<T>> void exitExceptFunction(Class<L> listType) {
        Expression.ListExpression two = (Expression.ListExpression)this.stack.pop(listType);
        Expression.ListExpression one = (Expression.ListExpression)this.stack.pop(listType);
        this.stack.push(this.script.composeExceptFunction(one, two, listType));
    }
}

