/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import eu.europa.ted.efx.model.CallStackObjectBase;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class Expression
extends CallStackObjectBase {
    public static final Map<String, Class<? extends Expression>> types = Map.ofEntries(Map.entry("id", StringExpression.class), Map.entry("id-ref", StringExpression.class), Map.entry("text", StringExpression.class), Map.entry("text-multilingual", StringExpression.class), Map.entry("indicator", BooleanExpression.class), Map.entry("amount", NumericExpression.class), Map.entry("number", NumericExpression.class), Map.entry("measure", DurationExpression.class), Map.entry("code", StringExpression.class), Map.entry("internal-code", StringExpression.class), Map.entry("integer", NumericExpression.class), Map.entry("date", DateExpression.class), Map.entry("zoned-date", DateExpression.class), Map.entry("time", TimeExpression.class), Map.entry("zoned-time", TimeExpression.class), Map.entry("url", StringExpression.class), Map.entry("phone", StringExpression.class), Map.entry("email", StringExpression.class));
    public static final Map<String, Class<? extends Expression>> listTypes = Map.ofEntries(Map.entry("id", StringListExpression.class), Map.entry("id-ref", StringListExpression.class), Map.entry("text", StringListExpression.class), Map.entry("text-multilingual", StringListExpression.class), Map.entry("indicator", BooleanListExpression.class), Map.entry("amount", NumericListExpression.class), Map.entry("number", NumericListExpression.class), Map.entry("measure", DurationListExpression.class), Map.entry("code", StringListExpression.class), Map.entry("internal-code", StringListExpression.class), Map.entry("integer", NumericListExpression.class), Map.entry("date", DateListExpression.class), Map.entry("zoned-date", DateListExpression.class), Map.entry("time", TimeListExpression.class), Map.entry("zoned-time", TimeListExpression.class), Map.entry("url", StringListExpression.class), Map.entry("phone", StringListExpression.class), Map.entry("email", StringListExpression.class));
    public final String script;

    public Expression(String script) {
        this.script = script;
    }

    public static <T extends Expression> T instantiate(String script, Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(String.class);
            return (T)((Expression)constructor.newInstance(script));
        }
        catch (Exception e) {
            throw new ParseCancellationException((Throwable)e);
        }
    }

    public static <T extends Expression> T empty(Class<T> type) {
        return Expression.instantiate("", type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (Expression.class.isAssignableFrom(obj.getClass())) {
            return this.script.equals(((Expression)obj).script);
        }
        return false;
    }

    public static class IteratorListExpression
    extends ListExpression<IteratorExpression> {
        public IteratorListExpression(String script) {
            super(script);
        }
    }

    public static class IteratorExpression
    extends Expression {
        public IteratorExpression(String script) {
            super(script);
        }
    }

    public static class BooleanListExpression
    extends ListExpression<BooleanExpression> {
        public BooleanListExpression(String script) {
            super(script);
        }
    }

    public static class DurationListExpression
    extends ListExpression<DurationExpression> {
        public DurationListExpression(String script) {
            super(script);
        }
    }

    public static class TimeListExpression
    extends ListExpression<TimeExpression> {
        public TimeListExpression(String script) {
            super(script);
        }
    }

    public static class DateListExpression
    extends ListExpression<DateExpression> {
        public DateListExpression(String script) {
            super(script);
        }
    }

    public static class NumericListExpression
    extends ListExpression<NumericExpression> {
        public NumericListExpression(String script) {
            super(script);
        }
    }

    public static class StringListExpression
    extends ListExpression<StringExpression> {
        public StringListExpression(String script) {
            super(script);
        }
    }

    public static class ListExpression<T extends Expression>
    extends ListExpressionBase {
        public ListExpression(String script) {
            super(script);
        }
    }

    public static class ListExpressionBase
    extends Expression {
        public ListExpressionBase(String script) {
            super(script);
        }
    }

    public static class DurationExpression
    extends Expression {
        public DurationExpression(String script) {
            super(script);
        }
    }

    public static class TimeExpression
    extends Expression {
        public TimeExpression(String script) {
            super(script);
        }
    }

    public static class DateExpression
    extends Expression {
        public DateExpression(String script) {
            super(script);
        }
    }

    public static class StringExpression
    extends Expression {
        public StringExpression(String script) {
            super(script);
        }
    }

    public static class NumericExpression
    extends Expression {
        public NumericExpression(String script) {
            super(script);
        }
    }

    public static class BooleanExpression
    extends Expression {
        public BooleanExpression(String script) {
            super(script);
        }
    }

    public static class ContextExpression
    extends Expression {
        public ContextExpression(String script) {
            super(script);
        }
    }

    public static class PathExpression
    extends Expression {
        public PathExpression(String script) {
            super(script);
        }
    }
}

