/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.Expression;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ContextStack
extends Stack<Context> {
    private final SymbolResolver symbols;
    private final Map<String, Context> variables = new HashMap<String, Context>();

    public ContextStack(SymbolResolver symbols) {
        this.symbols = symbols;
    }

    public Context.FieldContext pushFieldContext(String fieldId) {
        Expression.PathExpression absolutePath = this.symbols.getAbsolutePathOfField(fieldId);
        if (this.isEmpty()) {
            Context.FieldContext context = new Context.FieldContext(fieldId, absolutePath);
            this.push(context);
            return context;
        }
        Expression.PathExpression relativePath = this.symbols.getRelativePathOfField(fieldId, this.absolutePath());
        Context.FieldContext context = new Context.FieldContext(fieldId, absolutePath, relativePath);
        this.push(context);
        return context;
    }

    public Context.NodeContext pushNodeContext(String nodeId) {
        Expression.PathExpression absolutePath = this.symbols.getAbsolutePathOfNode(nodeId);
        if (this.isEmpty()) {
            Context.NodeContext context = new Context.NodeContext(nodeId, absolutePath);
            this.push(context);
            return context;
        }
        Expression.PathExpression relativePath = this.symbols.getRelativePathOfNode(nodeId, this.absolutePath());
        Context.NodeContext context = new Context.NodeContext(nodeId, absolutePath, relativePath);
        this.push(context);
        return context;
    }

    public void declareContextVariable(String variableName, Context variableValue) {
        this.variables.put(variableName, variableValue);
    }

    public Context getContextFromVariable(String variableName) {
        return this.variables.get(variableName);
    }

    public Boolean isFieldContext() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).isFieldContext();
    }

    public Boolean isNodeContext() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).isNodeContext();
    }

    public String symbol() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).symbol();
    }

    public Expression.PathExpression absolutePath() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).absolutePath();
    }

    public Expression.PathExpression relativePath() {
        if (this.isEmpty() || this.peek() == null) {
            return null;
        }
        return ((Context)this.peek()).relativePath();
    }
}

