/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.eforms.sdk.selector.component;

import eu.europa.ted.eforms.sdk.selector.component.VersionDependentComponent;
import eu.europa.ted.eforms.sdk.selector.component.VersionDependentComponentDescriptor;
import eu.europa.ted.eforms.sdk.selector.component.VersionDependentComponentType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.atteo.classindex.ClassIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VersionDependentComponentFactory {
    private static final Logger logger = LoggerFactory.getLogger(VersionDependentComponentFactory.class);
    private Map<String, Map<VersionDependentComponentType, VersionDependentComponentDescriptor<?>>> componentsMap;

    protected VersionDependentComponentFactory() {
        this.populateComponents();
    }

    private void populateComponents() {
        if (this.componentsMap == null) {
            this.componentsMap = new HashMap();
        }
        ClassIndex.getAnnotated(VersionDependentComponent.class).forEach(clazz -> {
            VersionDependentComponent annotation = clazz.getAnnotation(VersionDependentComponent.class);
            String[] supportedSdkVersions = annotation.versions();
            VersionDependentComponentType componentType = annotation.componentType();
            for (String sdkVersion : supportedSdkVersions) {
                Map<VersionDependentComponentType, VersionDependentComponentDescriptor<?>> components = this.componentsMap.get(sdkVersion);
                if (components == null) {
                    components = new HashMap();
                    this.componentsMap.put(sdkVersion, components);
                }
                VersionDependentComponentDescriptor component = new VersionDependentComponentDescriptor(sdkVersion, componentType, clazz);
                VersionDependentComponentDescriptor<?> existingComponent = components.get((Object)componentType);
                if (existingComponent != null && !existingComponent.equals(component)) {
                    throw new IllegalArgumentException(MessageFormat.format("More than one components of type [{0}] have been found for SDK version [{1}]:\n\t- {2}\n\t- {3}", new Object[]{componentType, sdkVersion, existingComponent.getImplType().getName(), clazz.getName()}));
                }
                components.put(componentType, component);
            }
        });
    }

    protected <T> T getComponentImpl(String sdkVersion, VersionDependentComponentType componentType, Class<T> intf, Object ... initArgs) throws InstantiationException {
        String normalizedVersion = VersionDependentComponentFactory.normalizeVersion(sdkVersion);
        VersionDependentComponentDescriptor descriptor = (VersionDependentComponentDescriptor)Optional.ofNullable(this.componentsMap.get(normalizedVersion)).orElseGet(Collections::emptyMap).get((Object)componentType);
        if (descriptor == null) {
            logger.error("Failed to load required components of SDK [{}]", (Object)sdkVersion);
            throw new IllegalArgumentException(MessageFormat.format("No implementation found for component type [{0}] of SDK [{1}].", new Object[]{componentType, sdkVersion}));
        }
        return descriptor.createInstance(initArgs);
    }

    private static String normalizeVersion(String sdkVersion) {
        String[] numbers;
        String normalizedVersion = sdkVersion;
        if (normalizedVersion.startsWith("eforms-sdk-")) {
            normalizedVersion = normalizedVersion.substring(11);
        }
        if ((numbers = normalizedVersion.split("\\.", -2)).length < 1) {
            throw new IllegalArgumentException("Invalid SDK version: " + sdkVersion);
        }
        return numbers[0] + (String)(numbers.length > 1 && Integer.parseInt(numbers[0]) > 0 ? "" : "." + numbers[1]);
    }
}

