/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.eforms.sdk.entity;

import java.util.List;
import java.util.Objects;

public abstract class SdkCodelist
implements Comparable<SdkCodelist> {
    private final String codelistId;
    private final String codelistVersion;
    private final List<String> codes;

    private SdkCodelist() {
        throw new UnsupportedOperationException();
    }

    public SdkCodelist(String codelistId, String codelistVersion, List<String> codes) {
        this.codelistId = codelistId;
        this.codelistVersion = codelistVersion;
        this.codes = codes;
    }

    public String getCodelistId() {
        return this.codelistId;
    }

    public String getVersion() {
        return this.codelistVersion;
    }

    public List<String> getCodes() {
        return this.codes;
    }

    public String toString() {
        return this.codelistId + "-" + this.codelistVersion;
    }

    @Override
    public int compareTo(SdkCodelist cl) {
        return Objects.compare(this.getCodelistId() + this.getVersion(), cl.getCodelistId() + cl.getVersion(), String::compareTo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdkCodelist other = (SdkCodelist)obj;
        return Objects.equals(this.codelistId, other.codelistId) && Objects.equals(this.codelistVersion, other.codelistVersion);
    }

    public int hashCode() {
        return Objects.hash(this.codelistId, this.codelistVersion);
    }
}

