/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.xpath;

import eu.europa.ted.efx.model.Expression;
import eu.europa.ted.efx.xpath.XPath20BaseListener;
import eu.europa.ted.efx.xpath.XPath20Lexer;
import eu.europa.ted.efx.xpath.XPath20Parser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class XPathContextualizer
extends XPath20BaseListener {
    private final CharStream inputStream;
    private final Queue<StepInfo> steps = new LinkedList<StepInfo>();
    int predicateMode = 0;

    public XPathContextualizer(CharStream inputStream) {
        this.inputStream = inputStream;
    }

    private static Queue<StepInfo> getSteps(Expression.PathExpression xpath) {
        CodePointCharStream inputStream = CharStreams.fromString((String)xpath.script);
        XPath20Lexer lexer = new XPath20Lexer((CharStream)inputStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        XPath20Parser parser = new XPath20Parser((TokenStream)tokens);
        XPath20Parser.XpathContext tree = parser.xpath();
        ParseTreeWalker walker = new ParseTreeWalker();
        XPathContextualizer contextualizer = new XPathContextualizer((CharStream)inputStream);
        walker.walk((ParseTreeListener)contextualizer, (ParseTree)tree);
        return contextualizer.steps;
    }

    public static Expression.PathExpression contextualize(Expression.PathExpression contextXpath, Expression.PathExpression xpath) {
        if (contextXpath == null || contextXpath.script.isEmpty()) {
            return xpath;
        }
        LinkedList<StepInfo> contextSteps = new LinkedList<StepInfo>(XPathContextualizer.getSteps(contextXpath));
        LinkedList<StepInfo> pathSteps = new LinkedList<StepInfo>(XPathContextualizer.getSteps(xpath));
        return XPathContextualizer.getContextualizedXpath(contextSteps, pathSteps);
    }

    public static Expression.PathExpression join(Expression.PathExpression first, Expression.PathExpression second) {
        if (first == null || first.script.trim().isEmpty()) {
            return second;
        }
        if (second == null || second.script.trim().isEmpty()) {
            return first;
        }
        LinkedList<StepInfo> firstPartSteps = new LinkedList<StepInfo>(XPathContextualizer.getSteps(first));
        LinkedList<StepInfo> secondPartSteps = new LinkedList<StepInfo>(XPathContextualizer.getSteps(second));
        return XPathContextualizer.getJoinedXPath(firstPartSteps, secondPartSteps);
    }

    private static Expression.PathExpression getContextualizedXpath(Queue<StepInfo> contextQueue, Queue<StepInfo> pathQueue) {
        Object relativeXpath = "";
        if (contextQueue != null) {
            while (!contextQueue.isEmpty() && !pathQueue.isEmpty() && pathQueue.peek().isTheSameAs(contextQueue.peek()).booleanValue()) {
                contextQueue.poll();
                pathQueue.poll();
            }
            while (!pathQueue.isEmpty()) {
                StepInfo step = pathQueue.poll();
                relativeXpath = (String)relativeXpath + "/" + step.stepText + step.getPredicateText();
            }
            while (((String)relativeXpath).startsWith("/")) {
                relativeXpath = ((String)relativeXpath).substring(1);
            }
            while (!contextQueue.isEmpty()) {
                if (contextQueue.poll().isAttributeStep().booleanValue()) continue;
                relativeXpath = "../" + (String)relativeXpath;
            }
            while (((String)relativeXpath).endsWith("/")) {
                relativeXpath = ((String)relativeXpath).substring(0, ((String)relativeXpath).length() - 1);
            }
            if (((String)relativeXpath).isEmpty()) {
                relativeXpath = ".";
            }
        }
        return new Expression.PathExpression((String)relativeXpath);
    }

    private static Expression.PathExpression getJoinedXPath(LinkedList<StepInfo> first, LinkedList<StepInfo> second) {
        List<String> dotSteps = Arrays.asList("..", ".");
        while (second.getFirst().stepText.equals("..") && !dotSteps.contains(first.getLast().stepText)) {
            second.removeFirst();
            first.removeLast();
        }
        return new Expression.PathExpression(first.stream().map(f -> f.stepText).collect(Collectors.joining("/")) + "/" + second.stream().map(s -> s.stepText).collect(Collectors.joining("/")));
    }

    private String getInputText(ParserRuleContext context) {
        return this.inputStream.getText(new Interval(context.start.getStartIndex(), context.stop.getStopIndex()));
    }

    private Boolean inPredicateMode() {
        return this.predicateMode > 0;
    }

    @Override
    public void exitStepexpr(XPath20Parser.StepexprContext ctx) {
        if (!this.inPredicateMode().booleanValue()) {
            this.steps.offer(new StepInfo(ctx, this::getInputText));
        }
    }

    @Override
    public void enterPredicate(XPath20Parser.PredicateContext ctx) {
        ++this.predicateMode;
    }

    @Override
    public void exitPredicate(XPath20Parser.PredicateContext ctx) {
        --this.predicateMode;
    }

    private class StepInfo {
        String stepText;
        List<String> predicates;

        public StepInfo(XPath20Parser.StepexprContext ctx, Function<ParserRuleContext, String> getInputText) {
            this.stepText = getInputText.apply(ctx.step());
            this.predicates = ctx.predicatelist().predicate().stream().map(getInputText).collect(Collectors.toList());
        }

        public Boolean isAttributeStep() {
            return this.stepText.startsWith("/@");
        }

        public String getPredicateText() {
            return String.join((CharSequence)"", this.predicates);
        }

        public Boolean isTheSameAs(StepInfo contextStep) {
            if (!Objects.equals(contextStep.stepText, this.stepText)) {
                return false;
            }
            if (this.predicates.size() != contextStep.predicates.size()) {
                return this.predicates.isEmpty() || contextStep.predicates.containsAll(this.predicates);
            }
            if (this.predicates.isEmpty()) {
                return true;
            }
            if (this.predicates.size() == 1) {
                return Objects.equals(contextStep.predicates.get(0), this.predicates.get(0));
            }
            ArrayList<String> pathPredicates = new ArrayList<String>(this.predicates);
            ArrayList<String> contextPredicates = new ArrayList<String>(contextStep.predicates);
            Collections.sort(pathPredicates);
            Collections.sort(contextPredicates);
            return pathPredicates.equals(contextPredicates);
        }
    }
}

