/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.sdk0.v7;

import eu.europa.ted.eforms.sdk.selector.component.SdkComponent;
import eu.europa.ted.eforms.sdk.selector.component.SdkComponentType;
import eu.europa.ted.efx.interfaces.EfxExpressionTranslator;
import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.model.CallStack;
import eu.europa.ted.efx.model.CallStackObjectBase;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.ContextStack;
import eu.europa.ted.efx.model.Expression;
import eu.europa.ted.efx.sdk0.v7.EfxBaseListener;
import eu.europa.ted.efx.sdk0.v7.EfxLexer;
import eu.europa.ted.efx.sdk0.v7.EfxParser;
import eu.europa.ted.efx.xpath.XPathAttributeLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;

@SdkComponent(versions={"0.7"}, componentType=SdkComponentType.EFX_EXPRESSION_TRANSLATOR)
public class EfxExpressionTranslator07
extends EfxBaseListener
implements EfxExpressionTranslator {
    private static final String NOT_MODIFIER = EfxLexer.VOCABULARY.getLiteralName(68).replaceAll("^'|'$", "");
    private static final String TYPE_MISMATCH_CANNOT_COMPARE_VALUES_OF_DIFFERENT_TYPES = "Type mismatch. Cannot compare values of different types: ";
    protected CallStack stack = new CallStack();
    protected ContextStack efxContext;
    protected SymbolResolver symbols;
    protected BaseErrorListener errorListener;
    protected ScriptGenerator script;

    protected EfxExpressionTranslator07() {
    }

    public EfxExpressionTranslator07(SymbolResolver symbolResolver, ScriptGenerator scriptGenerator, BaseErrorListener errorListener) {
        this.symbols = symbolResolver;
        this.script = scriptGenerator;
        this.errorListener = errorListener;
        this.efxContext = new ContextStack(this.symbols);
    }

    @Override
    public String translateExpression(String context, String expression) {
        EfxLexer lexer = new EfxLexer((CharStream)CharStreams.fromString((String)String.format("%s::${%s}", context, expression)));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        EfxParser parser = new EfxParser((TokenStream)tokens);
        if (this.errorListener != null) {
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        }
        EfxParser.SingleExpressionContext tree = parser.singleExpression();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)this, (ParseTree)tree);
        return this.getTranslatedScript();
    }

    private String getTranslatedScript() {
        StringBuilder sb = new StringBuilder(this.stack.size() * 100);
        while (!this.stack.empty()) {
            sb.insert(0, '\n').insert(0, this.stack.pop(Expression.class).script);
        }
        return sb.toString().trim();
    }

    protected static String getFieldIdFromChildSimpleFieldReferenceContext(ParserRuleContext ctx) {
        if (ctx instanceof EfxParser.SimpleFieldReferenceContext) {
            return ((EfxParser.SimpleFieldReferenceContext)ctx).FieldId().getText();
        }
        if (ctx instanceof EfxParser.AbsoluteFieldReferenceContext) {
            return ((EfxParser.AbsoluteFieldReferenceContext)ctx).reference.simpleFieldReference().FieldId().getText();
        }
        if (ctx instanceof EfxParser.FieldReferenceWithFieldContextOverrideContext) {
            return ((EfxParser.FieldReferenceWithFieldContextOverrideContext)ctx).reference.simpleFieldReference().FieldId().getText();
        }
        if (ctx instanceof EfxParser.FieldReferenceWithNodeContextOverrideContext) {
            return ((EfxParser.FieldReferenceWithNodeContextOverrideContext)ctx).reference.fieldReferenceWithPredicate().simpleFieldReference().FieldId().getText();
        }
        EfxParser.SimpleFieldReferenceContext fieldReferenceContext = (EfxParser.SimpleFieldReferenceContext)ctx.getChild(EfxParser.SimpleFieldReferenceContext.class, 0);
        if (fieldReferenceContext != null) {
            return fieldReferenceContext.FieldId().getText();
        }
        for (ParseTree child : ctx.children) {
            String fieldId;
            if (!(child instanceof ParserRuleContext) || (fieldId = EfxExpressionTranslator07.getFieldIdFromChildSimpleFieldReferenceContext((ParserRuleContext)child)) == null) continue;
            return fieldId;
        }
        return null;
    }

    protected static String getNodeIdFromChildSimpleNodeReferenceContext(ParserRuleContext ctx) {
        if (ctx instanceof EfxParser.SimpleNodeReferenceContext) {
            return ((EfxParser.SimpleNodeReferenceContext)ctx).NodeId().getText();
        }
        for (ParseTree child : ctx.children) {
            String nodeId;
            if (!(child instanceof ParserRuleContext) || (nodeId = EfxExpressionTranslator07.getNodeIdFromChildSimpleNodeReferenceContext((ParserRuleContext)child)) == null) continue;
            return nodeId;
        }
        return null;
    }

    @Override
    public void enterSingleExpression(EfxParser.SingleExpressionContext ctx) {
        TerminalNode fieldContext = ctx.FieldId();
        if (fieldContext != null) {
            this.efxContext.pushFieldContext(fieldContext.getText());
        } else {
            TerminalNode nodeContext = ctx.NodeId();
            if (nodeContext != null) {
                this.efxContext.pushNodeContext(nodeContext.getText());
            }
        }
    }

    @Override
    public void exitSingleExpression(EfxParser.SingleExpressionContext ctx) {
        this.efxContext.pop();
    }

    @Override
    public void exitParenthesizedBooleanExpression(EfxParser.ParenthesizedBooleanExpressionContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.BooleanExpression.class), Expression.BooleanExpression.class));
    }

    @Override
    public void exitLogicalAndCondition(EfxParser.LogicalAndConditionContext ctx) {
        Expression.BooleanExpression right = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression left = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeLogicalAnd(left, right));
    }

    @Override
    public void exitLogicalOrCondition(EfxParser.LogicalOrConditionContext ctx) {
        Expression.BooleanExpression right = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression left = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeLogicalOr(left, right));
    }

    @Override
    public void exitFieldValueComparison(EfxParser.FieldValueComparisonContext ctx) {
        Expression right = this.stack.pop(Expression.class);
        Expression left = this.stack.pop(Expression.class);
        if (!left.getClass().equals(right.getClass())) {
            throw new ParseCancellationException(TYPE_MISMATCH_CANNOT_COMPARE_VALUES_OF_DIFFERENT_TYPES + left.getClass() + " and " + right.getClass());
        }
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitStringComparison(EfxParser.StringComparisonContext ctx) {
        Expression.StringExpression right = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression left = this.stack.pop(Expression.StringExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitNumericComparison(EfxParser.NumericComparisonContext ctx) {
        Expression.NumericExpression right = this.stack.pop(Expression.NumericExpression.class);
        Expression.NumericExpression left = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitBooleanComparison(EfxParser.BooleanComparisonContext ctx) {
        Expression.BooleanExpression right = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression left = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitDateComparison(EfxParser.DateComparisonContext ctx) {
        Expression.DateExpression right = this.stack.pop(Expression.DateExpression.class);
        Expression.DateExpression left = this.stack.pop(Expression.DateExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitTimeComparison(EfxParser.TimeComparisonContext ctx) {
        Expression.TimeExpression right = this.stack.pop(Expression.TimeExpression.class);
        Expression.TimeExpression left = this.stack.pop(Expression.TimeExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitDurationComparison(EfxParser.DurationComparisonContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DurationExpression left = this.stack.pop(Expression.DurationExpression.class);
        this.stack.push(this.script.composeComparisonOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitEmptinessCondition(EfxParser.EmptinessConditionContext ctx) {
        Expression.StringExpression expression = this.stack.pop(Expression.StringExpression.class);
        String operator = ctx.modifier != null && ctx.modifier.getText().equals(NOT_MODIFIER) ? "!=" : "==";
        this.stack.push(this.script.composeComparisonOperation(expression, operator, this.script.getStringLiteralFromUnquotedString("")));
    }

    @Override
    public void exitPresenceCondition(EfxParser.PresenceConditionContext ctx) {
        Expression.PathExpression reference = this.stack.pop(Expression.PathExpression.class);
        if (ctx.modifier != null && ctx.modifier.getText().equals(NOT_MODIFIER)) {
            this.stack.push(this.script.composeLogicalNot(this.script.composeExistsCondition(reference)));
        } else {
            this.stack.push(this.script.composeExistsCondition(reference));
        }
    }

    @Override
    public void exitLikePatternCondition(EfxParser.LikePatternConditionContext ctx) {
        Expression.StringExpression expression = this.stack.pop(Expression.StringExpression.class);
        Expression.BooleanExpression condition = this.script.composePatternMatchCondition(expression, ctx.pattern.getText());
        if (ctx.modifier != null && ctx.modifier.getText().equals(NOT_MODIFIER)) {
            condition = this.script.composeLogicalNot(condition);
        }
        this.stack.push(condition);
    }

    @Override
    public void exitStringInListCondition(EfxParser.StringInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitBooleanInListCondition(EfxParser.BooleanInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitNumberInListCondition(EfxParser.NumberInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitDateInListCondition(EfxParser.DateInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitTimeInListCondition(EfxParser.TimeInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitDurationInListCondition(EfxParser.DurationInListConditionContext ctx) {
        this.exitInListCondition(ctx.modifier, Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    private <T extends Expression, L extends Expression.ListExpression<T>> void exitInListCondition(Token modifier, Class<T> expressionType, Class<L> listType) {
        Expression.ListExpression list = (Expression.ListExpression)this.stack.pop(listType);
        Expression expression = (Expression)this.stack.pop(expressionType);
        Expression.BooleanExpression condition = this.script.composeContainsCondition(expression, list);
        if (modifier != null && modifier.getText().equals(NOT_MODIFIER)) {
            condition = this.script.composeLogicalNot(condition);
        }
        this.stack.push(condition);
    }

    @Override
    public void exitStringQuantifiedExpression(EfxParser.StringQuantifiedExpressionContext ctx) {
        this.exitQuantifiedExpression(ctx.Every() != null, Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitBooleanQuantifiedExpression(EfxParser.BooleanQuantifiedExpressionContext ctx) {
        this.exitQuantifiedExpression(ctx.Every() != null, Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitNumericQuantifiedExpression(EfxParser.NumericQuantifiedExpressionContext ctx) {
        this.exitQuantifiedExpression(ctx.Every() != null, Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitDateQuantifiedExpression(EfxParser.DateQuantifiedExpressionContext ctx) {
        this.exitQuantifiedExpression(ctx.Every() != null, Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitTimeQuantifiedExpression(EfxParser.TimeQuantifiedExpressionContext ctx) {
        this.exitQuantifiedExpression(ctx.Every() != null, Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitDurationQuantifiedExpression(EfxParser.DurationQuantifiedExpressionContext ctx) {
        this.exitQuantifiedExpression(ctx.Every() != null, Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    private <T extends Expression, L extends Expression.ListExpression<T>> void exitQuantifiedExpression(boolean every, Class<T> expressionType, Class<L> listType) {
        Expression.BooleanExpression booleanExpression = this.stack.pop(Expression.BooleanExpression.class);
        Expression.ListExpression list = (Expression.ListExpression)this.stack.pop(listType);
        Expression variable = (Expression)this.stack.pop(expressionType);
        if (every) {
            this.stack.push(this.script.composeAllSatisfy(list, variable.script, booleanExpression));
        } else {
            this.stack.push(this.script.composeAnySatisfies(list, variable.script, booleanExpression));
        }
    }

    @Override
    public void exitAdditionExpression(EfxParser.AdditionExpressionContext ctx) {
        Expression.NumericExpression right = this.stack.pop(Expression.NumericExpression.class);
        Expression.NumericExpression left = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeNumericOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitMultiplicationExpression(EfxParser.MultiplicationExpressionContext ctx) {
        Expression.NumericExpression right = this.stack.pop(Expression.NumericExpression.class);
        Expression.NumericExpression left = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeNumericOperation(left, ctx.operator.getText(), right));
    }

    @Override
    public void exitParenthesizedNumericExpression(EfxParser.ParenthesizedNumericExpressionContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.NumericExpression.class), Expression.NumericExpression.class));
    }

    @Override
    public void exitDurationAdditionExpression(EfxParser.DurationAdditionExpressionContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DurationExpression left = this.stack.pop(Expression.DurationExpression.class);
        this.stack.push(this.script.composeAddition(left, right));
    }

    @Override
    public void exitDurationSubtractionExpression(EfxParser.DurationSubtractionExpressionContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DurationExpression left = this.stack.pop(Expression.DurationExpression.class);
        this.stack.push(this.script.composeSubtraction(left, right));
    }

    @Override
    public void exitDurationLeftMultiplicationExpression(EfxParser.DurationLeftMultiplicationExpressionContext ctx) {
        Expression.DurationExpression duration = this.stack.pop(Expression.DurationExpression.class);
        Expression.NumericExpression number = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeMultiplication(number, duration));
    }

    @Override
    public void exitDurationRightMultiplicationExpression(EfxParser.DurationRightMultiplicationExpressionContext ctx) {
        Expression.NumericExpression number = this.stack.pop(Expression.NumericExpression.class);
        Expression.DurationExpression duration = this.stack.pop(Expression.DurationExpression.class);
        this.stack.push(this.script.composeMultiplication(number, duration));
    }

    @Override
    public void exitDateSubtractionExpression(EfxParser.DateSubtractionExpressionContext ctx) {
        Expression.DateExpression startDate = this.stack.pop(Expression.DateExpression.class);
        Expression.DateExpression endDate = this.stack.pop(Expression.DateExpression.class);
        this.stack.push(this.script.composeSubtraction(startDate, endDate));
    }

    @Override
    public void exitCodeList(EfxParser.CodeListContext ctx) {
        if (this.stack.empty()) {
            this.stack.push(this.script.composeList(Collections.emptyList(), Expression.StringListExpression.class));
        }
    }

    @Override
    public void exitStringList(EfxParser.StringListContext ctx) {
        this.exitList(ctx.stringExpression().size(), Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitBooleanList(EfxParser.BooleanListContext ctx) {
        this.exitList(ctx.booleanExpression().size(), Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitNumericList(EfxParser.NumericListContext ctx) {
        this.exitList(ctx.numericExpression().size(), Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitDateList(EfxParser.DateListContext ctx) {
        this.exitList(ctx.dateExpression().size(), Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitTimeList(EfxParser.TimeListContext ctx) {
        this.exitList(ctx.timeExpression().size(), Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitDurationList(EfxParser.DurationListContext ctx) {
        this.exitList(ctx.durationExpression().size(), Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    private <T extends Expression, L extends Expression.ListExpression<T>> void exitList(int listSize, Class<T> expressionType, Class<L> listType) {
        if (this.stack.empty() || listSize == 0) {
            this.stack.push(this.script.composeList(Collections.emptyList(), listType));
            return;
        }
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (int i = 0; i < listSize; ++i) {
            list.add(0, (Expression)this.stack.pop(expressionType));
        }
        this.stack.push(this.script.composeList(list, listType));
    }

    @Override
    public void exitUntypedConditonalExpression(EfxParser.UntypedConditonalExpressionContext ctx) {
        Class<?> typeWhenFalse = ((CallStackObjectBase)this.stack.peek()).getClass();
        if (typeWhenFalse == Expression.BooleanExpression.class) {
            this.exitConditionalBooleanExpression();
        } else if (typeWhenFalse == Expression.NumericExpression.class) {
            this.exitConditionalNumericExpression();
        } else if (typeWhenFalse == Expression.StringExpression.class) {
            this.exitConditionalStringExpression();
        } else if (typeWhenFalse == Expression.DateExpression.class) {
            this.exitConditionalDateExpression();
        } else if (typeWhenFalse == Expression.TimeExpression.class) {
            this.exitConditionalTimeExpression();
        } else if (typeWhenFalse == Expression.DurationExpression.class) {
            this.exitConditionalDurationExpression();
        } else {
            throw new IllegalStateException("Unknown type " + typeWhenFalse);
        }
    }

    @Override
    public void exitConditionalBooleanExpression(EfxParser.ConditionalBooleanExpressionContext ctx) {
        this.exitConditionalBooleanExpression();
    }

    @Override
    public void exitConditionalNumericExpression(EfxParser.ConditionalNumericExpressionContext ctx) {
        this.exitConditionalNumericExpression();
    }

    @Override
    public void exitConditionalStringExpression(EfxParser.ConditionalStringExpressionContext ctx) {
        this.exitConditionalStringExpression();
    }

    @Override
    public void exitConditionalDateExpression(EfxParser.ConditionalDateExpressionContext ctx) {
        this.exitConditionalDateExpression();
    }

    @Override
    public void exitConditionalTimeExpression(EfxParser.ConditionalTimeExpressionContext ctx) {
        this.exitConditionalTimeExpression();
    }

    @Override
    public void exitConditionalDurationExpression(EfxParser.ConditionalDurationExpressionContext ctx) {
        this.exitConditionalDurationExpression();
    }

    private void exitConditionalBooleanExpression() {
        Expression.BooleanExpression whenFalse = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression whenTrue = this.stack.pop(Expression.BooleanExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.BooleanExpression.class));
    }

    private void exitConditionalNumericExpression() {
        Expression.NumericExpression whenFalse = this.stack.pop(Expression.NumericExpression.class);
        Expression.NumericExpression whenTrue = this.stack.pop(Expression.NumericExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.NumericExpression.class));
    }

    private void exitConditionalStringExpression() {
        Expression.StringExpression whenFalse = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression whenTrue = this.stack.pop(Expression.StringExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.StringExpression.class));
    }

    private void exitConditionalDateExpression() {
        Expression.DateExpression whenFalse = this.stack.pop(Expression.DateExpression.class);
        Expression.DateExpression whenTrue = this.stack.pop(Expression.DateExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.DateExpression.class));
    }

    private void exitConditionalTimeExpression() {
        Expression.TimeExpression whenFalse = this.stack.pop(Expression.TimeExpression.class);
        Expression.TimeExpression whenTrue = this.stack.pop(Expression.TimeExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.TimeExpression.class));
    }

    private void exitConditionalDurationExpression() {
        Expression.DurationExpression whenFalse = this.stack.pop(Expression.DurationExpression.class);
        Expression.DurationExpression whenTrue = this.stack.pop(Expression.DurationExpression.class);
        Expression.BooleanExpression condition = this.stack.pop(Expression.BooleanExpression.class);
        this.stack.push(this.script.composeConditionalExpression(condition, whenTrue, whenFalse, Expression.DurationExpression.class));
    }

    @Override
    public void exitParenthesizedStringsFromIteration(EfxParser.ParenthesizedStringsFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.StringListExpression.class), Expression.StringListExpression.class));
    }

    @Override
    public void exitParenthesizedNumbersFromIteration(EfxParser.ParenthesizedNumbersFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.NumericListExpression.class), Expression.NumericListExpression.class));
    }

    @Override
    public void exitParenthesizedBooleansFromIteration(EfxParser.ParenthesizedBooleansFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.BooleanListExpression.class), Expression.BooleanListExpression.class));
    }

    @Override
    public void exitParenthesizedDatesFromIteration(EfxParser.ParenthesizedDatesFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.DateListExpression.class), Expression.DateListExpression.class));
    }

    @Override
    public void exitParenthesizedTimesFromIteration(EfxParser.ParenthesizedTimesFromIterationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.TimeListExpression.class), Expression.TimeListExpression.class));
    }

    @Override
    public void exitParenthesizedDurationsFromITeration(EfxParser.ParenthesizedDurationsFromITerationContext ctx) {
        this.stack.push(this.script.composeParenthesizedExpression(this.stack.pop(Expression.DurationListExpression.class), Expression.DurationListExpression.class));
    }

    @Override
    public void exitStringsFromStringIteration(EfxParser.StringsFromStringIterationContext ctx) {
        this.exitIterationExpression(Expression.StringExpression.class, Expression.StringListExpression.class, Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitStringsFromBooleanIteration(EfxParser.StringsFromBooleanIterationContext ctx) {
        this.exitIterationExpression(Expression.BooleanExpression.class, Expression.BooleanListExpression.class, Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitStringsFromNumericIteration(EfxParser.StringsFromNumericIterationContext ctx) {
        this.exitIterationExpression(Expression.NumericExpression.class, Expression.NumericListExpression.class, Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitStringsFromDateIteration(EfxParser.StringsFromDateIterationContext ctx) {
        this.exitIterationExpression(Expression.DateExpression.class, Expression.DateListExpression.class, Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitStringsFromTimeIteration(EfxParser.StringsFromTimeIterationContext ctx) {
        this.exitIterationExpression(Expression.TimeExpression.class, Expression.TimeListExpression.class, Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitStringsFromDurationIteration(EfxParser.StringsFromDurationIterationContext ctx) {
        this.exitIterationExpression(Expression.DurationExpression.class, Expression.DurationListExpression.class, Expression.StringExpression.class, Expression.StringListExpression.class);
    }

    @Override
    public void exitBooleansFromStringIteration(EfxParser.BooleansFromStringIterationContext ctx) {
        this.exitIterationExpression(Expression.StringExpression.class, Expression.StringListExpression.class, Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitBooleansFromBooleanIteration(EfxParser.BooleansFromBooleanIterationContext ctx) {
        this.exitIterationExpression(Expression.BooleanExpression.class, Expression.BooleanListExpression.class, Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitBooleansFromNumericIteration(EfxParser.BooleansFromNumericIterationContext ctx) {
        this.exitIterationExpression(Expression.NumericExpression.class, Expression.NumericListExpression.class, Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitBooleansFromDateIteration(EfxParser.BooleansFromDateIterationContext ctx) {
        this.exitIterationExpression(Expression.DateExpression.class, Expression.DateListExpression.class, Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitBooleansFromTimeIteration(EfxParser.BooleansFromTimeIterationContext ctx) {
        this.exitIterationExpression(Expression.TimeExpression.class, Expression.TimeListExpression.class, Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitBooleansFromDurationIteration(EfxParser.BooleansFromDurationIterationContext ctx) {
        this.exitIterationExpression(Expression.DurationExpression.class, Expression.DurationListExpression.class, Expression.BooleanExpression.class, Expression.BooleanListExpression.class);
    }

    @Override
    public void exitNumbersFromStringIteration(EfxParser.NumbersFromStringIterationContext ctx) {
        this.exitIterationExpression(Expression.StringExpression.class, Expression.StringListExpression.class, Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitNumbersFromBooleanIteration(EfxParser.NumbersFromBooleanIterationContext ctx) {
        this.exitIterationExpression(Expression.BooleanExpression.class, Expression.BooleanListExpression.class, Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitNumbersFromNumericIteration(EfxParser.NumbersFromNumericIterationContext ctx) {
        this.exitIterationExpression(Expression.NumericExpression.class, Expression.NumericListExpression.class, Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitNumbersFromDateIteration(EfxParser.NumbersFromDateIterationContext ctx) {
        this.exitIterationExpression(Expression.DateExpression.class, Expression.DateListExpression.class, Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitNumbersFromTimeIteration(EfxParser.NumbersFromTimeIterationContext ctx) {
        this.exitIterationExpression(Expression.TimeExpression.class, Expression.TimeListExpression.class, Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitNumbersFromDurationIteration(EfxParser.NumbersFromDurationIterationContext ctx) {
        this.exitIterationExpression(Expression.DurationExpression.class, Expression.DurationListExpression.class, Expression.NumericExpression.class, Expression.NumericListExpression.class);
    }

    @Override
    public void exitDatesFromStringIteration(EfxParser.DatesFromStringIterationContext ctx) {
        this.exitIterationExpression(Expression.StringExpression.class, Expression.StringListExpression.class, Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitDatesFromBooleanIteration(EfxParser.DatesFromBooleanIterationContext ctx) {
        this.exitIterationExpression(Expression.BooleanExpression.class, Expression.BooleanListExpression.class, Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitDatesFromNumericIteration(EfxParser.DatesFromNumericIterationContext ctx) {
        this.exitIterationExpression(Expression.NumericExpression.class, Expression.NumericListExpression.class, Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitDatesFromDateIteration(EfxParser.DatesFromDateIterationContext ctx) {
        this.exitIterationExpression(Expression.DateExpression.class, Expression.DateListExpression.class, Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitDatesFromTimeIteration(EfxParser.DatesFromTimeIterationContext ctx) {
        this.exitIterationExpression(Expression.TimeExpression.class, Expression.TimeListExpression.class, Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitDatesFromDurationIteration(EfxParser.DatesFromDurationIterationContext ctx) {
        this.exitIterationExpression(Expression.DurationExpression.class, Expression.DurationListExpression.class, Expression.DateExpression.class, Expression.DateListExpression.class);
    }

    @Override
    public void exitTimesFromStringIteration(EfxParser.TimesFromStringIterationContext ctx) {
        this.exitIterationExpression(Expression.StringExpression.class, Expression.StringListExpression.class, Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitTimesFromBooleanIteration(EfxParser.TimesFromBooleanIterationContext ctx) {
        this.exitIterationExpression(Expression.BooleanExpression.class, Expression.BooleanListExpression.class, Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitTimesFromNumericIteration(EfxParser.TimesFromNumericIterationContext ctx) {
        this.exitIterationExpression(Expression.NumericExpression.class, Expression.NumericListExpression.class, Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitTimesFromDateIteration(EfxParser.TimesFromDateIterationContext ctx) {
        this.exitIterationExpression(Expression.DateExpression.class, Expression.DateListExpression.class, Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitTimesFromTimeIteration(EfxParser.TimesFromTimeIterationContext ctx) {
        this.exitIterationExpression(Expression.TimeExpression.class, Expression.TimeListExpression.class, Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitTimesFromDurationIteration(EfxParser.TimesFromDurationIterationContext ctx) {
        this.exitIterationExpression(Expression.DurationExpression.class, Expression.DurationListExpression.class, Expression.TimeExpression.class, Expression.TimeListExpression.class);
    }

    @Override
    public void exitDurationsFromStringIteration(EfxParser.DurationsFromStringIterationContext ctx) {
        this.exitIterationExpression(Expression.StringExpression.class, Expression.StringListExpression.class, Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    @Override
    public void exitDurationsFromBooleanIteration(EfxParser.DurationsFromBooleanIterationContext ctx) {
        this.exitIterationExpression(Expression.BooleanExpression.class, Expression.BooleanListExpression.class, Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    @Override
    public void exitDurationsFromNumericIteration(EfxParser.DurationsFromNumericIterationContext ctx) {
        this.exitIterationExpression(Expression.NumericExpression.class, Expression.NumericListExpression.class, Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    @Override
    public void exitDurationsFromDateIteration(EfxParser.DurationsFromDateIterationContext ctx) {
        this.exitIterationExpression(Expression.DateExpression.class, Expression.DateListExpression.class, Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    @Override
    public void exitDurationsFromTimeIteration(EfxParser.DurationsFromTimeIterationContext ctx) {
        this.exitIterationExpression(Expression.TimeExpression.class, Expression.TimeListExpression.class, Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    @Override
    public void exitDurationsFromDurationIteration(EfxParser.DurationsFromDurationIterationContext ctx) {
        this.exitIterationExpression(Expression.DurationExpression.class, Expression.DurationListExpression.class, Expression.DurationExpression.class, Expression.DurationListExpression.class);
    }

    public <T1 extends Expression, L1 extends Expression.ListExpression<T1>, T2 extends Expression, L2 extends Expression.ListExpression<T2>> void exitIterationExpression(Class<T1> variableType, Class<L1> sourceListType, Class<T2> expressionType, Class<L2> targetListType) {
        Expression expression = (Expression)this.stack.pop(expressionType);
        Expression.ListExpression list = (Expression.ListExpression)this.stack.pop(sourceListType);
        Expression variable = (Expression)this.stack.pop(variableType);
        this.stack.push(this.script.composeForExpression(variable.script, list, expression, targetListType));
    }

    @Override
    public void exitNumericLiteral(EfxParser.NumericLiteralContext ctx) {
        this.stack.push(this.script.getNumericLiteralEquivalent(ctx.getText()));
    }

    @Override
    public void exitStringLiteral(EfxParser.StringLiteralContext ctx) {
        this.stack.push(this.script.getStringLiteralEquivalent(ctx.getText()));
    }

    @Override
    public void exitTrueBooleanLiteral(EfxParser.TrueBooleanLiteralContext ctx) {
        this.stack.push(this.script.getBooleanEquivalent(true));
    }

    @Override
    public void exitFalseBooleanLiteral(EfxParser.FalseBooleanLiteralContext ctx) {
        this.stack.push(this.script.getBooleanEquivalent(false));
    }

    @Override
    public void exitDateLiteral(EfxParser.DateLiteralContext ctx) {
        this.stack.push(this.script.getDateLiteralEquivalent(ctx.DATE().getText()));
    }

    @Override
    public void exitTimeLiteral(EfxParser.TimeLiteralContext ctx) {
        this.stack.push(this.script.getTimeLiteralEquivalent(ctx.TIME().getText()));
    }

    @Override
    public void exitDurationLiteral(EfxParser.DurationLiteralContext ctx) {
        this.stack.push(this.script.getDurationLiteralEquivalent(ctx.getText()));
    }

    @Override
    public void exitSimpleNodeReference(EfxParser.SimpleNodeReferenceContext ctx) {
        this.stack.push(this.symbols.getRelativePathOfNode(ctx.NodeId().getText(), this.efxContext.absolutePath()));
    }

    @Override
    public void exitSimpleFieldReference(EfxParser.SimpleFieldReferenceContext ctx) {
        this.stack.push(this.symbols.getRelativePathOfField(ctx.FieldId().getText(), this.efxContext.absolutePath()));
    }

    @Override
    public void enterAbsoluteFieldReference(EfxParser.AbsoluteFieldReferenceContext ctx) {
        if (ctx.Slash() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitAbsoluteFieldReference(EfxParser.AbsoluteFieldReferenceContext ctx) {
        if (ctx.Slash() != null) {
            this.efxContext.pop();
        }
    }

    @Override
    public void enterAbsoluteNodeReference(EfxParser.AbsoluteNodeReferenceContext ctx) {
        if (ctx.Slash() != null) {
            this.efxContext.push(null);
        }
    }

    @Override
    public void exitAbsoluteNodeReference(EfxParser.AbsoluteNodeReferenceContext ctx) {
        if (ctx.Slash() != null) {
            this.efxContext.pop();
        }
    }

    @Override
    public void exitNodeReferenceWithPredicate(EfxParser.NodeReferenceWithPredicateContext ctx) {
        if (ctx.predicate() != null) {
            Expression.BooleanExpression predicate = this.stack.pop(Expression.BooleanExpression.class);
            Expression.PathExpression nodeReference = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.composeNodeReferenceWithPredicate(nodeReference, predicate, Expression.PathExpression.class));
        }
    }

    @Override
    public void exitFieldReferenceWithPredicate(EfxParser.FieldReferenceWithPredicateContext ctx) {
        if (ctx.predicate() != null) {
            Expression.BooleanExpression predicate = this.stack.pop(Expression.BooleanExpression.class);
            Expression.PathExpression fieldReference = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.composeFieldReferenceWithPredicate(fieldReference, predicate, Expression.PathExpression.class));
        }
    }

    @Override
    public void enterPredicate(EfxParser.PredicateContext ctx) {
        String fieldId = EfxExpressionTranslator07.getFieldIdFromChildSimpleFieldReferenceContext(ctx.getParent());
        this.efxContext.pushFieldContext(fieldId);
    }

    @Override
    public void exitPredicate(EfxParser.PredicateContext ctx) {
        this.efxContext.pop();
    }

    @Override
    public void exitNoticeReference(EfxParser.NoticeReferenceContext ctx) {
        this.stack.push(this.script.composeExternalReference(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitFieldReferenceInOtherNotice(EfxParser.FieldReferenceInOtherNoticeContext ctx) {
        if (ctx.noticeReference() != null) {
            Expression.PathExpression field = this.stack.pop(Expression.PathExpression.class);
            Expression.PathExpression notice = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.composeFieldInExternalReference(notice, field));
        }
    }

    @Override
    public void exitUntypedFieldValueReference(EfxParser.UntypedFieldValueReferenceContext ctx) {
        Expression.PathExpression path = this.stack.pop(Expression.PathExpression.class);
        String fieldId = EfxExpressionTranslator07.getFieldIdFromChildSimpleFieldReferenceContext(ctx);
        XPathAttributeLocator parsedPath = XPathAttributeLocator.findAttribute(path);
        if (parsedPath.hasAttribute().booleanValue()) {
            this.stack.push(this.script.composeFieldAttributeReference(parsedPath.getPath(), parsedPath.getAttribute(), Expression.types.get(this.symbols.getTypeOfField(fieldId))));
        } else if (fieldId != null) {
            this.stack.push(this.script.composeFieldValueReference(path, Expression.types.get(this.symbols.getTypeOfField(fieldId))));
        } else {
            this.stack.push(this.script.composeFieldValueReference(path, Expression.PathExpression.class));
        }
    }

    @Override
    public void exitUntypedFieldValueSequence(EfxParser.UntypedFieldValueSequenceContext ctx) {
        Expression.PathExpression path = this.stack.pop(Expression.PathExpression.class);
        String fieldId = EfxExpressionTranslator07.getFieldIdFromChildSimpleFieldReferenceContext(ctx);
        XPathAttributeLocator parsedPath = XPathAttributeLocator.findAttribute(path);
        if (parsedPath.hasAttribute().booleanValue()) {
            this.stack.push(this.script.composeFieldAttributeReference(parsedPath.getPath(), parsedPath.getAttribute(), Expression.listTypes.get(this.symbols.getTypeOfField(fieldId))));
        } else if (fieldId != null) {
            this.stack.push(this.script.composeFieldValueReference(path, Expression.listTypes.get(this.symbols.getTypeOfField(fieldId))));
        } else {
            this.stack.push(this.script.composeFieldValueReference(path, Expression.PathExpression.class));
        }
    }

    @Override
    public void exitUntypedAttributeValueReference(EfxParser.UntypedAttributeValueReferenceContext ctx) {
        this.stack.push(this.script.composeFieldAttributeReference(this.stack.pop(Expression.PathExpression.class), ctx.Identifier().getText(), Expression.StringExpression.class));
    }

    @Override
    public void exitFieldContext(EfxParser.FieldContextContext ctx) {
        this.stack.pop(Expression.PathExpression.class);
        String contextFieldId = ctx.context.reference.simpleFieldReference().FieldId().getText();
        this.efxContext.push(new Context.FieldContext(contextFieldId, this.symbols.getAbsolutePathOfField(contextFieldId), this.symbols.getRelativePathOfField(contextFieldId, this.efxContext.absolutePath())));
    }

    @Override
    public void exitFieldReferenceWithFieldContextOverride(EfxParser.FieldReferenceWithFieldContextOverrideContext ctx) {
        if (ctx.context != null) {
            Expression.PathExpression field = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.joinPaths(this.efxContext.relativePath(), field));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitNodeContext(EfxParser.NodeContextContext ctx) {
        this.stack.pop(Expression.PathExpression.class);
        String contextNodeId = EfxExpressionTranslator07.getNodeIdFromChildSimpleNodeReferenceContext(ctx.context);
        this.efxContext.push(new Context.NodeContext(contextNodeId, this.symbols.getAbsolutePathOfNode(contextNodeId), this.symbols.getRelativePathOfNode(contextNodeId, this.efxContext.absolutePath())));
    }

    @Override
    public void exitFieldReferenceWithNodeContextOverride(EfxParser.FieldReferenceWithNodeContextOverrideContext ctx) {
        if (ctx.context != null) {
            Expression.PathExpression field = this.stack.pop(Expression.PathExpression.class);
            this.stack.push(this.script.joinPaths(this.efxContext.relativePath(), field));
            this.efxContext.pop();
        }
    }

    @Override
    public void exitCodelistReference(EfxParser.CodelistReferenceContext ctx) {
        this.stack.push(this.script.composeList(this.symbols.expandCodelist(ctx.codeListId.getText()).stream().map(s -> this.script.getStringLiteralFromUnquotedString((String)s)).collect(Collectors.toList()), Expression.StringListExpression.class));
    }

    @Override
    public void exitUntypedVariable(EfxParser.UntypedVariableContext ctx) {
        this.stack.pushVariable(this.script.composeVariableReference(ctx.Variable().getText(), Expression.class));
    }

    @Override
    public void exitStringVariableDeclaration(EfxParser.StringVariableDeclarationContext ctx) {
        this.stack.pushVariable(this.script.composeVariableReference(ctx.Variable().getText(), Expression.StringExpression.class));
    }

    @Override
    public void exitBooleanVariableDeclaration(EfxParser.BooleanVariableDeclarationContext ctx) {
        this.stack.pushVariable(this.script.composeVariableReference(ctx.Variable().getText(), Expression.BooleanExpression.class));
    }

    @Override
    public void exitNumericVariableDeclaration(EfxParser.NumericVariableDeclarationContext ctx) {
        this.stack.pushVariable(this.script.composeVariableReference(ctx.Variable().getText(), Expression.NumericExpression.class));
    }

    @Override
    public void exitDateVariableDeclaration(EfxParser.DateVariableDeclarationContext ctx) {
        this.stack.pushVariable(this.script.composeVariableReference(ctx.Variable().getText(), Expression.DateExpression.class));
    }

    @Override
    public void exitTimeVariableDeclaration(EfxParser.TimeVariableDeclarationContext ctx) {
        this.stack.pushVariable(this.script.composeVariableReference(ctx.Variable().getText(), Expression.TimeExpression.class));
    }

    @Override
    public void exitDurationVariableDeclaration(EfxParser.DurationVariableDeclarationContext ctx) {
        this.stack.pushVariable(this.script.composeVariableReference(ctx.Variable().getText(), Expression.DurationExpression.class));
    }

    @Override
    public void exitNotFunction(EfxParser.NotFunctionContext ctx) {
        this.stack.push(this.script.composeLogicalNot(this.stack.pop(Expression.BooleanExpression.class)));
    }

    @Override
    public void exitContainsFunction(EfxParser.ContainsFunctionContext ctx) {
        Expression.StringExpression needle = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression haystack = this.stack.pop(Expression.StringExpression.class);
        this.stack.push(this.script.composeContainsCondition(haystack, needle));
    }

    @Override
    public void exitStartsWithFunction(EfxParser.StartsWithFunctionContext ctx) {
        Expression.StringExpression startsWith = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression text = this.stack.pop(Expression.StringExpression.class);
        this.stack.push(this.script.composeStartsWithCondition(text, startsWith));
    }

    @Override
    public void exitEndsWithFunction(EfxParser.EndsWithFunctionContext ctx) {
        Expression.StringExpression endsWith = this.stack.pop(Expression.StringExpression.class);
        Expression.StringExpression text = this.stack.pop(Expression.StringExpression.class);
        this.stack.push(this.script.composeEndsWithCondition(text, endsWith));
    }

    @Override
    public void exitCountFunction(EfxParser.CountFunctionContext ctx) {
        this.stack.push(this.script.composeCountOperation(this.stack.pop(Expression.ListExpression.class)));
    }

    @Override
    public void exitNumberFunction(EfxParser.NumberFunctionContext ctx) {
        this.stack.push(this.script.composeToNumberConversion(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitSumFunction(EfxParser.SumFunctionContext ctx) {
        this.stack.push(this.script.composeSumOperation(this.stack.pop(Expression.NumericListExpression.class)));
    }

    @Override
    public void exitStringLengthFunction(EfxParser.StringLengthFunctionContext ctx) {
        this.stack.push(this.script.composeStringLengthCalculation(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitSubstringFunction(EfxParser.SubstringFunctionContext ctx) {
        Expression.NumericExpression length = ctx.length != null ? this.stack.pop(Expression.NumericExpression.class) : null;
        Expression.NumericExpression start = this.stack.pop(Expression.NumericExpression.class);
        Expression.StringExpression text = this.stack.pop(Expression.StringExpression.class);
        if (length != null) {
            this.stack.push(this.script.composeSubstringExtraction(text, start, length));
        } else {
            this.stack.push(this.script.composeSubstringExtraction(text, start));
        }
    }

    @Override
    public void exitToStringFunction(EfxParser.ToStringFunctionContext ctx) {
        this.stack.push(this.script.composeToStringConversion(this.stack.pop(Expression.NumericExpression.class)));
    }

    @Override
    public void exitConcatFunction(EfxParser.ConcatFunctionContext ctx) {
        if (this.stack.empty() || ctx.stringExpression().size() == 0) {
            this.stack.push(this.script.composeStringConcatenation(Collections.emptyList()));
            return;
        }
        ArrayList<Expression.StringExpression> list = new ArrayList<Expression.StringExpression>();
        for (int i = 0; i < ctx.stringExpression().size(); ++i) {
            list.add(0, this.stack.pop(Expression.StringExpression.class));
        }
        this.stack.push(this.script.composeStringConcatenation(list));
    }

    @Override
    public void exitFormatNumberFunction(EfxParser.FormatNumberFunctionContext ctx) {
        Expression.StringExpression format = this.stack.pop(Expression.StringExpression.class);
        Expression.NumericExpression number = this.stack.pop(Expression.NumericExpression.class);
        this.stack.push(this.script.composeNumberFormatting(number, format));
    }

    @Override
    public void exitDateFromStringFunction(EfxParser.DateFromStringFunctionContext ctx) {
        this.stack.push(this.script.composeToDateConversion(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitDatePlusMeasureFunction(EfxParser.DatePlusMeasureFunctionContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DateExpression left = this.stack.pop(Expression.DateExpression.class);
        this.stack.push(this.script.composeAddition(left, right));
    }

    @Override
    public void exitDateMinusMeasureFunction(EfxParser.DateMinusMeasureFunctionContext ctx) {
        Expression.DurationExpression right = this.stack.pop(Expression.DurationExpression.class);
        Expression.DateExpression left = this.stack.pop(Expression.DateExpression.class);
        this.stack.push(this.script.composeSubtraction(left, right));
    }

    @Override
    public void exitTimeFromStringFunction(EfxParser.TimeFromStringFunctionContext ctx) {
        this.stack.push(this.script.composeToTimeConversion(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitDayTimeDurationFromStringFunction(EfxParser.DayTimeDurationFromStringFunctionContext ctx) {
        this.stack.push(this.script.composeToDayTimeDurationConversion(this.stack.pop(Expression.StringExpression.class)));
    }

    @Override
    public void exitYearMonthDurationFromStringFunction(EfxParser.YearMonthDurationFromStringFunctionContext ctx) {
        this.stack.push(this.script.composeToYearMonthDurationConversion(this.stack.pop(Expression.StringExpression.class)));
    }
}

