/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import eu.europa.ted.efx.model.Expression;

public abstract class Context {
    private final String symbol;
    private final Expression.PathExpression absolutePath;
    private final Expression.PathExpression relativePath;

    protected Context(String symbol, Expression.PathExpression absolutePath, Expression.PathExpression relativePath) {
        this.symbol = symbol;
        this.absolutePath = absolutePath;
        this.relativePath = relativePath == null ? absolutePath : relativePath;
    }

    protected Context(String symbol, Expression.PathExpression absolutePath) {
        this(symbol, absolutePath, absolutePath);
    }

    public Boolean isFieldContext() {
        return this.getClass().equals(FieldContext.class);
    }

    public Boolean isNodeContext() {
        return this.getClass().equals(NodeContext.class);
    }

    public String symbol() {
        return this.symbol;
    }

    public Expression.PathExpression absolutePath() {
        return this.absolutePath;
    }

    public Expression.PathExpression relativePath() {
        return this.relativePath;
    }

    public static class NodeContext
    extends Context {
        public NodeContext(String nodeId, Expression.PathExpression absolutePath, Expression.PathExpression relativePath) {
            super(nodeId, absolutePath, relativePath);
        }

        public NodeContext(String nodeId, Expression.PathExpression absolutePath) {
            super(nodeId, absolutePath);
        }
    }

    public static class FieldContext
    extends Context {
        public FieldContext(String fieldId, Expression.PathExpression absolutePath, Expression.PathExpression relativePath) {
            super(fieldId, absolutePath, relativePath);
        }

        public FieldContext(String fieldId, Expression.PathExpression absolutePath) {
            super(fieldId, absolutePath);
        }
    }
}

