/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx;

import eu.europa.ted.efx.interfaces.TranslatorDependencyFactory;
import eu.europa.ted.efx.selector.component.EfxTranslatorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public class EfxTranslator {
    public static String translateExpression(String context, String expression, TranslatorDependencyFactory dependencyFactory, String sdkVersion) throws InstantiationException {
        return EfxTranslatorFactory.getEfxExpressionTranslator(EfxTranslator.normalizeVersion(sdkVersion).getName(), dependencyFactory).translateExpression(context, expression);
    }

    public static String translateTemplate(Path pathname, TranslatorDependencyFactory dependencyFactory, String sdkVersion) throws IOException, InstantiationException {
        return EfxTranslatorFactory.getEfxTemplateTranslator(EfxTranslator.normalizeVersion(sdkVersion).getName(), dependencyFactory).renderTemplate(pathname);
    }

    public static String translateTemplate(String template, TranslatorDependencyFactory dependencyFactory, String sdkVersion) throws InstantiationException {
        return EfxTranslatorFactory.getEfxTemplateTranslator(EfxTranslator.normalizeVersion(sdkVersion).getName(), dependencyFactory).renderTemplate(template);
    }

    public static String translateTemplate(InputStream stream, TranslatorDependencyFactory dependencyFactory, String sdkVersion) throws IOException, InstantiationException {
        return EfxTranslatorFactory.getEfxTemplateTranslator(EfxTranslator.normalizeVersion(sdkVersion).getName(), dependencyFactory).renderTemplate(stream);
    }

    private static KnownSdkVersions normalizeVersion(String sdkVersion) {
        String[] numbers;
        Object normalizedVersion = sdkVersion;
        if (((String)normalizedVersion).startsWith("eforms-sdk-")) {
            normalizedVersion = ((String)normalizedVersion).substring(11);
        }
        normalizedVersion = "SDK_" + ((numbers = ((String)normalizedVersion).split("\\.", -2)).length > 0 ? numbers[0] : "") + "_" + (numbers.length > 1 ? numbers[1] : "");
        try {
            return KnownSdkVersions.valueOf((String)normalizedVersion);
        }
        catch (IllegalArgumentException e) {
            return KnownSdkVersions.UNSUPPORTED;
        }
    }

    static enum KnownSdkVersions {
        SDK_0_6("0.6"),
        SDK_0_7("0.7"),
        UNSUPPORTED("N/A");

        private String name;

        private KnownSdkVersions(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

