/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.eforms.sdk.selector.component;

import eu.europa.ted.eforms.sdk.selector.component.SdkComponent;
import eu.europa.ted.eforms.sdk.selector.component.SdkComponentDescriptor;
import eu.europa.ted.eforms.sdk.selector.component.SdkComponentType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.atteo.classindex.ClassIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SdkComponentFactory {
    private static final String FALLBACK_SDK_VERSION = "any";
    private static final Logger log = LoggerFactory.getLogger(SdkComponentFactory.class);
    private Map<String, Map<SdkComponentType, SdkComponentDescriptor<?>>> componentsMap;

    protected SdkComponentFactory() {
        this.populateComponents();
    }

    private void populateComponents() {
        if (this.componentsMap == null) {
            this.componentsMap = new HashMap();
        }
        ClassIndex.getAnnotated(SdkComponent.class).forEach(clazz -> {
            SdkComponent annotation = clazz.getAnnotation(SdkComponent.class);
            String[] supportedSdkVersions = annotation.versions();
            SdkComponentType componentType = annotation.componentType();
            for (String sdkVersion : supportedSdkVersions) {
                Map<SdkComponentType, SdkComponentDescriptor<?>> components = this.componentsMap.get(sdkVersion);
                if (components == null) {
                    components = new HashMap();
                    this.componentsMap.put(sdkVersion, components);
                }
                SdkComponentDescriptor component = new SdkComponentDescriptor(sdkVersion, componentType, clazz);
                SdkComponentDescriptor<?> existingComponent = components.get((Object)componentType);
                if (existingComponent != null && !existingComponent.equals(component)) {
                    throw new IllegalArgumentException(MessageFormat.format("More than one components of type [{0}] have been found for SDK version [{1}]:\n\t- {2}\n\t- {3}", new Object[]{componentType, sdkVersion, existingComponent.getImplType().getName(), clazz.getName()}));
                }
                components.put(componentType, component);
            }
        });
    }

    protected <T> T getComponentImpl(String sdkVersion, SdkComponentType componentType, Class<T> intf, Object ... initArgs) throws InstantiationException {
        SdkComponentDescriptor descriptor = (SdkComponentDescriptor)Optional.ofNullable(this.componentsMap.get(sdkVersion)).orElseGet(Collections::emptyMap).get((Object)componentType);
        if (descriptor == null) {
            String fallbackSdkVersion = FALLBACK_SDK_VERSION;
            log.warn("No implementation found for component type [{}] of SDK [{}]. Trying with fallback SDK [{}]", new Object[]{componentType, sdkVersion, fallbackSdkVersion});
            descriptor = (SdkComponentDescriptor)Optional.ofNullable(this.componentsMap.get(fallbackSdkVersion)).orElseGet(Collections::emptyMap).get((Object)componentType);
            if (descriptor == null) {
                throw new IllegalArgumentException(MessageFormat.format("No implementation found for component type [{0}] of SDK [{1}].", new Object[]{componentType, fallbackSdkVersion}));
            }
        }
        return descriptor.createInstance(initArgs);
    }
}

