/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.xpath;

import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.model.Expression;
import eu.europa.ted.efx.xpath.XPathContextualizer;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class XPathScriptGenerator
implements ScriptGenerator {
    private static final Map<String, String> operators = Map.ofEntries(Map.entry("+", "+"), Map.entry("-", "-"), Map.entry("*", "*"), Map.entry("/", "div"), Map.entry("%", "mod"), Map.entry("==", "="), Map.entry("!=", "!="), Map.entry("<", "<"), Map.entry("<=", "<="), Map.entry(">", ">"), Map.entry(">=", ">="));

    @Override
    public <T extends Expression> T composeNodeReferenceWithPredicate(Expression.PathExpression nodeReference, Expression.BooleanExpression predicate, Class<T> type) {
        return this.instantiate(nodeReference.script + "[" + predicate.script + "]", type);
    }

    @Override
    public <T extends Expression> T composeFieldReferenceWithPredicate(Expression.PathExpression fieldReference, Expression.BooleanExpression predicate, Class<T> type) {
        return this.instantiate(fieldReference.script + "[" + predicate.script + "]", type);
    }

    @Override
    public <T extends Expression> T composeFieldValueReference(Expression.PathExpression fieldReference, Class<T> type) {
        if (Expression.StringExpression.class.isAssignableFrom(type)) {
            return this.instantiate(fieldReference.script + "/normalize-space(text())", type);
        }
        if (Expression.NumericExpression.class.isAssignableFrom(type)) {
            return this.instantiate(fieldReference.script + "/number()", type);
        }
        if (Expression.DateExpression.class.isAssignableFrom(type)) {
            return this.instantiate(fieldReference.script + "/xs:date(text())", type);
        }
        if (Expression.TimeExpression.class.isAssignableFrom(type)) {
            return this.instantiate(fieldReference.script + "/xs:time(text())", type);
        }
        if (Expression.DurationExpression.class.isAssignableFrom(type)) {
            return this.instantiate("(if (lower-case(" + fieldReference.script + "/@unit)='w') then xs:dayTimeDuration(concat('P', " + fieldReference.script + "/number() * 7, 'D')) else if (lower-case(" + fieldReference.script + "/@unit)='d') then xs:dayTimeDuration(concat('P', " + fieldReference.script + "/number(), upper-case(" + fieldReference.script + "/@unit))) else xs:yearMonthDuration(concat('P', " + fieldReference.script + "/number(), upper-case(" + fieldReference.script + "/@unit))))", type);
        }
        return this.instantiate(fieldReference.script, type);
    }

    @Override
    public <T extends Expression> T composeFieldAttributeReference(Expression.PathExpression fieldReference, String attribute, Class<T> type) {
        return this.instantiate(fieldReference.script + "/@" + attribute, type);
    }

    @Override
    public Expression.StringListExpression composeListOfStrings(List<Expression.StringExpression> list) {
        if (list == null || list.isEmpty()) {
            return new Expression.StringListExpression("()");
        }
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        for (Expression.StringExpression item : list) {
            joiner.add(item.script);
        }
        return new Expression.StringListExpression(joiner.toString());
    }

    @Override
    public Expression.NumericExpression getNumericLiteralEquivalent(String literal) {
        return new Expression.NumericExpression(literal);
    }

    @Override
    public Expression.StringExpression getStringLiteralEquivalent(String literal) {
        return new Expression.StringExpression(literal);
    }

    @Override
    public Expression.BooleanExpression getBooleanEquivalent(boolean value) {
        return new Expression.BooleanExpression(value ? "true()" : "false()");
    }

    @Override
    public Expression.DateExpression getDateLiteralEquivalent(String literal) {
        return new Expression.DateExpression("xs:date(" + this.quoted(literal) + ")");
    }

    @Override
    public Expression.TimeExpression getTimeLiteralEquivalent(String literal) {
        return new Expression.TimeExpression("xs:time(" + this.quoted(literal) + ")");
    }

    @Override
    public Expression.DurationExpression getDurationLiteralEquivalent(String literal) {
        if (literal.contains("M") || literal.contains("Y")) {
            return new Expression.DurationExpression("xs:yearMonthDuration(" + this.quoted(literal) + ")");
        }
        if (literal.contains("W")) {
            int weeks = this.getWeeksFromDurationLiteral(literal);
            return new Expression.DurationExpression("xs:dayTimeDuration(" + this.quoted(String.format("P%dD", weeks * 7)) + ")");
        }
        return new Expression.DurationExpression("xs:dayTimeDuration(" + this.quoted(literal) + ")");
    }

    @Override
    public Expression.BooleanExpression composeContainsCondition(Expression.StringExpression expression, Expression.StringListExpression list) {
        return new Expression.BooleanExpression(String.format("%s = %s", expression.script, list.script));
    }

    @Override
    public Expression.BooleanExpression composePatternMatchCondition(Expression.StringExpression expression, String pattern) {
        return new Expression.BooleanExpression(String.format("fn:matches(normalize-space(%s), %s)", expression.script, pattern));
    }

    @Override
    public <T extends Expression> T composeParenthesizedExpression(T expression, Class<T> type) {
        try {
            Constructor<T> ctor = type.getConstructor(String.class);
            return (T)((Expression)ctor.newInstance("(" + expression.script + ")"));
        }
        catch (Exception e) {
            throw new ParseCancellationException((Throwable)e);
        }
    }

    @Override
    public Expression.PathExpression composeExternalReference(Expression.StringExpression externalReference) {
        return new Expression.PathExpression("fn:doc(concat('http://notice.service/', " + externalReference.script + ")')");
    }

    @Override
    public Expression.PathExpression composeFieldInExternalReference(Expression.PathExpression externalReference, Expression.PathExpression fieldReference) {
        return new Expression.PathExpression(externalReference.script + "/" + fieldReference.script);
    }

    @Override
    public Expression.PathExpression joinPaths(Expression.PathExpression first, Expression.PathExpression second) {
        return XPathContextualizer.join(first, second);
    }

    @Override
    public Expression.BooleanExpression composeLogicalAnd(Expression.BooleanExpression leftOperand, Expression.BooleanExpression rightOperand) {
        return new Expression.BooleanExpression(String.format("%s and %s", leftOperand.script, rightOperand.script));
    }

    @Override
    public Expression.BooleanExpression composeLogicalOr(Expression.BooleanExpression leftOperand, Expression.BooleanExpression rightOperand) {
        return new Expression.BooleanExpression(String.format("%s or %s", leftOperand.script, rightOperand.script));
    }

    @Override
    public Expression.BooleanExpression composeLogicalNot(Expression.BooleanExpression condition) {
        return new Expression.BooleanExpression(String.format("not(%s)", condition.script));
    }

    @Override
    public Expression.BooleanExpression composeExistsCondition(Expression.PathExpression reference) {
        return new Expression.BooleanExpression(reference.script);
    }

    @Override
    public Expression.BooleanExpression composeContainsCondition(Expression.StringExpression haystack, Expression.StringExpression needle) {
        return new Expression.BooleanExpression("contains(" + haystack.script + ", " + needle.script + ")");
    }

    @Override
    public Expression.BooleanExpression composeStartsWithCondition(Expression.StringExpression text, Expression.StringExpression startsWith) {
        return new Expression.BooleanExpression("starts-with(" + text.script + ", " + startsWith.script + ")");
    }

    @Override
    public Expression.BooleanExpression composeEndsWithCondition(Expression.StringExpression text, Expression.StringExpression endsWith) {
        return new Expression.BooleanExpression("ends-with(" + text.script + ", " + endsWith.script + ")");
    }

    @Override
    public Expression.BooleanExpression composeComparisonOperation(Expression leftOperand, String operator, Expression rightOperand) {
        if (Expression.DurationExpression.class.isAssignableFrom(leftOperand.getClass())) {
            return new Expression.BooleanExpression("boolean(for $T in (current-date()) return ($T + " + leftOperand.script + " " + operators.get(operator) + " $T + " + rightOperand.script + "))");
        }
        return new Expression.BooleanExpression(leftOperand.script + " " + operators.get(operator) + " " + rightOperand.script);
    }

    @Override
    public Expression.NumericExpression composeCountOperation(Expression.PathExpression nodeSet) {
        return new Expression.NumericExpression("count(" + nodeSet.script + ")");
    }

    @Override
    public Expression.NumericExpression composeToNumberConversion(Expression.StringExpression text) {
        return new Expression.NumericExpression("number(" + text.script + ")");
    }

    @Override
    public Expression.NumericExpression composeSumOperation(Expression.PathExpression nodeSet) {
        return new Expression.NumericExpression("sum(" + nodeSet.script + ")");
    }

    @Override
    public Expression.NumericExpression composeStringLengthCalculation(Expression.StringExpression text) {
        return new Expression.NumericExpression("string-length(" + text.script + ")");
    }

    @Override
    public Expression.NumericExpression composeNumericOperation(Expression.NumericExpression leftOperand, String operator, Expression.NumericExpression rightOperand) {
        return new Expression.NumericExpression(leftOperand.script + " " + operators.get(operator) + " " + rightOperand.script);
    }

    @Override
    public Expression.StringExpression composeSubstringExtraction(Expression.StringExpression text, Expression.NumericExpression start, Expression.NumericExpression length) {
        return new Expression.StringExpression("substring(" + text.script + ", " + start.script + ", " + length.script + ")");
    }

    @Override
    public Expression.StringExpression composeSubstringExtraction(Expression.StringExpression text, Expression.NumericExpression start) {
        return new Expression.StringExpression("substring(" + text.script + ", " + start.script + ")");
    }

    @Override
    public Expression.StringExpression composeToStringConversion(Expression.NumericExpression number) {
        return new Expression.StringExpression("string(" + number.script + ")");
    }

    @Override
    public Expression.StringExpression composeStringConcatenation(List<Expression.StringExpression> list) {
        return new Expression.StringExpression("concat(" + list.stream().map(i -> i.script).collect(Collectors.joining(", ")) + ")");
    }

    @Override
    public Expression.StringExpression composeNumberFormatting(Expression.NumericExpression number, Expression.StringExpression format) {
        return new Expression.StringExpression("format-number(" + number.script + ", " + format.script + ")");
    }

    @Override
    public Expression.StringExpression getStringLiteralFromUnquotedString(String value) {
        return new Expression.StringExpression("'" + value + "'");
    }

    @Override
    public Expression.DateExpression composeToDateConversion(Expression.StringExpression date) {
        return new Expression.DateExpression("xs:date(" + date.script + ")");
    }

    @Override
    public Expression.DateExpression composeAddition(Expression.DateExpression date, Expression.DurationExpression duration) {
        return new Expression.DateExpression("(" + date.script + " + " + duration.script + ")");
    }

    @Override
    public Expression.DateExpression composeSubtraction(Expression.DateExpression date, Expression.DurationExpression duration) {
        return new Expression.DateExpression("(" + date.script + " - " + duration.script + ")");
    }

    @Override
    public Expression.TimeExpression composeToTimeConversion(Expression.StringExpression time) {
        return new Expression.TimeExpression("xs:time(" + time.script + ")");
    }

    @Override
    public Expression.DurationExpression composeSubtraction(Expression.DateExpression startDate, Expression.DateExpression endDate) {
        return new Expression.DurationExpression("xs:dayTimeDuration(" + endDate.script + " " + operators.get("-") + " " + startDate.script + ")");
    }

    @Override
    public Expression.DurationExpression composeMultiplication(Expression.NumericExpression number, Expression.DurationExpression duration) {
        return new Expression.DurationExpression("(" + number.script + " * " + duration.script + ")");
    }

    @Override
    public Expression.DurationExpression composeAddition(Expression.DurationExpression left, Expression.DurationExpression right) {
        return new Expression.DurationExpression("(" + left.script + " + " + right.script + ")");
    }

    @Override
    public Expression.DurationExpression composeSubtraction(Expression.DurationExpression left, Expression.DurationExpression right) {
        return new Expression.DurationExpression("(" + left.script + " - " + right.script + ")");
    }

    private <T extends Expression> T instantiate(String value, Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(String.class);
            return (T)((Expression)constructor.newInstance(value));
        }
        catch (Exception e) {
            throw new ParseCancellationException((Throwable)e);
        }
    }

    private String quoted(String text) {
        return "'" + text.replaceAll("\"", "").replaceAll("'", "") + "'";
    }

    private int getWeeksFromDurationLiteral(String literal) {
        Matcher weeksMatcher = Pattern.compile("(?<=[^0-9])[0-9]+(?=W)").matcher(literal);
        return weeksMatcher.find() ? Integer.parseInt(weeksMatcher.group()) : 0;
    }
}

