/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.xpath;

import eu.europa.ted.efx.model.Expression;
import eu.europa.ted.efx.xpath.XPath20BaseListener;
import eu.europa.ted.efx.xpath.XPath20Lexer;
import eu.europa.ted.efx.xpath.XPath20Parser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class XPathAttributeLocator
extends XPath20BaseListener {
    private int inPredicate = 0;
    private int splitPosition = -1;
    private Expression.PathExpression path;
    private String attribute;

    public Expression.PathExpression getPath() {
        return this.path;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public Boolean hasAttribute() {
        return this.attribute != null;
    }

    @Override
    public void enterPredicate(XPath20Parser.PredicateContext ctx) {
        ++this.inPredicate;
    }

    @Override
    public void exitPredicate(XPath20Parser.PredicateContext ctx) {
        --this.inPredicate;
    }

    @Override
    public void exitAbbrevforwardstep(XPath20Parser.AbbrevforwardstepContext ctx) {
        if (this.inPredicate == 0 && ctx.AT() != null) {
            this.splitPosition = ctx.AT().getSymbol().getCharPositionInLine();
            this.attribute = ctx.nodetest().getText();
        }
    }

    public static XPathAttributeLocator findAttribute(Expression.PathExpression xpath) {
        XPathAttributeLocator locator = new XPathAttributeLocator();
        if (!xpath.script.contains("@")) {
            locator.path = xpath;
            locator.attribute = null;
            return locator;
        }
        CodePointCharStream inputStream = CharStreams.fromString((String)xpath.script);
        XPath20Lexer lexer = new XPath20Lexer((CharStream)inputStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        XPath20Parser parser = new XPath20Parser((TokenStream)tokens);
        XPath20Parser.XpathContext tree = parser.xpath();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)locator, (ParseTree)tree);
        if (locator.splitPosition > -1) {
            String path = xpath.script.substring(0, locator.splitPosition);
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            locator.path = new Expression.PathExpression(path);
        } else {
            locator.path = xpath;
        }
        return locator;
    }
}

