/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.sdk0.v6;

import eu.europa.ted.efx.interfaces.MarkupGenerator;
import eu.europa.ted.efx.interfaces.TranslatorDependencyFactory;
import eu.europa.ted.efx.model.ContentBlock;
import eu.europa.ted.efx.model.ContentBlockStack;
import eu.europa.ted.efx.model.Context;
import eu.europa.ted.efx.model.Expression;
import eu.europa.ted.efx.model.Markup;
import eu.europa.ted.efx.sdk0.v6.EfxExpressionTranslator;
import eu.europa.ted.efx.sdk0.v6.EfxLexer;
import eu.europa.ted.efx.sdk0.v6.EfxParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class EfxTemplateTranslator
extends EfxExpressionTranslator {
    private static final String INCONSISTENT_INDENTATION_SPACES = "Inconsistent indentation. Expected a multiple of %d spaces.";
    private static final String INDENTATION_LEVEL_SKIPPED = "Indentation level skipped.";
    private static final String START_INDENT_AT_ZERO = "Incorrect indentation. Please do not indent the first level in your template.";
    private static final String MIXED_INDENTATION = "Do not mix indentation methods. Stick with either tabs or spaces.";
    private static final String UNEXPECTED_INDENTATION = "Unexpected indentation tracker state.";
    private static final String LABEL_TYPE_VALUE = EfxLexer.VOCABULARY.getLiteralName(29).replaceAll("^'|'$", "");
    private static final String ASSET_TYPE_INDICATOR = EfxLexer.VOCABULARY.getLiteralName(23).replaceAll("^'|'$", "");
    private static final String ASSET_TYPE_BT = EfxLexer.VOCABULARY.getLiteralName(20).replaceAll("^'|'$", "");
    private static final String ASSET_TYPE_FIELD = EfxLexer.VOCABULARY.getLiteralName(21).replaceAll("^'|'$", "");
    private static final String ASSET_TYPE_CODE = EfxLexer.VOCABULARY.getLiteralName(22).replaceAll("^'|'$", "");
    private Indent indentWith = Indent.UNDETERMINED;
    private int indentSpaces = -1;
    MarkupGenerator markup;
    final ContentBlock rootBlock = ContentBlock.newRootBlock();
    ContentBlockStack blockStack = new ContentBlockStack();

    public EfxTemplateTranslator(TranslatorDependencyFactory factory, String sdkVersion) {
        super(factory.createSymbolResolver(sdkVersion), factory.createScriptGenerator());
        this.markup = factory.createMarkupGenerator();
    }

    public static String renderTemplate(Path pathname, TranslatorDependencyFactory factory, String sdkVersion) throws IOException {
        return EfxTemplateTranslator.renderTemplate(CharStreams.fromPath((Path)pathname), factory, sdkVersion);
    }

    public static String renderTemplate(String template, TranslatorDependencyFactory factory, String sdkVersion) {
        return EfxTemplateTranslator.renderTemplate((CharStream)CharStreams.fromString((String)template), factory, sdkVersion);
    }

    public static String renderTemplate(InputStream stream, TranslatorDependencyFactory factory, String sdkVersion) throws IOException {
        return EfxTemplateTranslator.renderTemplate(CharStreams.fromStream((InputStream)stream), factory, sdkVersion);
    }

    private static String renderTemplate(CharStream charStream, TranslatorDependencyFactory factory, String sdkVersion) {
        EfxTemplateTranslator translator = new EfxTemplateTranslator(factory, sdkVersion);
        EfxLexer lexer = new EfxLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        EfxParser parser = new EfxParser((TokenStream)tokens);
        BaseErrorListener errorListener = factory.createErrorListener();
        if (errorListener != null) {
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)errorListener);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
        }
        EfxParser.TemplateFileContext tree = parser.templateFile();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)translator, (ParseTree)tree);
        return translator.getTranslatedMarkup();
    }

    private String getTranslatedMarkup() {
        StringBuilder sb = new StringBuilder(64);
        while (!this.stack.empty()) {
            sb.insert(0, '\n').insert(0, this.stack.pop(Markup.class).script);
        }
        return sb.toString().trim();
    }

    @Override
    public void enterTemplateFile(EfxParser.TemplateFileContext ctx) {
        assert (this.blockStack.isEmpty()) : "Unexpected indentation tracker state.";
    }

    @Override
    public void exitTemplateFile(EfxParser.TemplateFileContext ctx) {
        this.blockStack.pop();
        ArrayList<Markup> templateCalls = new ArrayList<Markup>();
        ArrayList<Markup> templates = new ArrayList<Markup>();
        for (ContentBlock rootBlock : this.rootBlock.getChildren()) {
            templateCalls.add(rootBlock.renderCallTemplate(this.markup));
            rootBlock.renderTemplate(this.markup, templates);
        }
        Markup file = this.markup.composeOutputFile(templateCalls, templates);
        this.stack.push(file);
    }

    @Override
    public void exitTextTemplate(EfxParser.TextTemplateContext ctx) {
        Markup template = ctx.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        String text = ctx.text() != null ? ctx.text().getText() : "";
        this.stack.push(this.markup.renderFreeText(text).join(template));
    }

    @Override
    public void exitLabelTemplate(EfxParser.LabelTemplateContext ctx) {
        Markup template = ctx.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        Markup label = ctx.labelBlock() != null ? this.stack.pop(Markup.class) : Markup.empty();
        this.stack.push(label.join(template));
    }

    @Override
    public void exitValueTemplate(EfxParser.ValueTemplateContext ctx) {
        Markup template = ctx.templateFragment() != null ? this.stack.pop(Markup.class) : Markup.empty();
        Expression expression = this.stack.pop(Expression.class);
        this.stack.push(this.markup.renderVariableExpression(expression).join(template));
    }

    @Override
    public void exitStandardLabelReference(EfxParser.StandardLabelReferenceContext ctx) {
        Expression.StringExpression assetId = ctx.assetId() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        Expression.StringExpression labelType = ctx.labelType() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        Expression.StringExpression assetType = ctx.assetType() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(assetType, this.script.getStringLiteralFromUnquotedString("|"), labelType, this.script.getStringLiteralFromUnquotedString("|"), assetId))));
    }

    @Override
    public void exitShorthandBtLabelReference(EfxParser.ShorthandBtLabelReferenceContext ctx) {
        Expression.StringExpression assetId = this.script.getStringLiteralFromUnquotedString(ctx.BtId().getText());
        Expression.StringExpression labelType = ctx.labelType() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_BT), this.script.getStringLiteralFromUnquotedString("|"), labelType, this.script.getStringLiteralFromUnquotedString("|"), assetId))));
    }

    @Override
    public void exitShorthandFieldLabelReference(EfxParser.ShorthandFieldLabelReferenceContext ctx) {
        Expression.StringExpression labelType;
        String fieldId = ctx.FieldId().getText();
        Expression.StringExpression stringExpression = labelType = ctx.labelType() != null ? this.stack.pop(Expression.StringExpression.class) : this.script.getStringLiteralFromUnquotedString("");
        if (labelType.script.equals("value")) {
            this.shorthandFieldValueLabelReference(fieldId);
        } else {
            this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_FIELD), this.script.getStringLiteralFromUnquotedString("|"), labelType, this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(fieldId)))));
        }
    }

    @Override
    public void exitShorthandFieldValueLabelReference(EfxParser.ShorthandFieldValueLabelReferenceContext ctx) {
        this.shorthandFieldValueLabelReference(ctx.FieldId().getText());
    }

    private void shorthandFieldValueLabelReference(String fieldId) {
        String fieldType;
        Context currentContext = (Context)this.efxContext.peek();
        Expression.StringExpression valueReference = this.script.composeFieldValueReference(this.symbols.getRelativePathOfField(fieldId, currentContext.absolutePath()), Expression.StringExpression.class);
        switch (fieldType = this.symbols.getTypeOfField(fieldId)) {
            case "indicator": {
                this.stack.push(this.markup.renderLabelFromExpression(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_INDICATOR), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(LABEL_TYPE_VALUE), this.script.getStringLiteralFromUnquotedString("-"), valueReference, this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(fieldId)))));
                break;
            }
            case "code": 
            case "internal-code": {
                this.stack.push(this.markup.renderLabelFromExpression(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_CODE), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(LABEL_TYPE_VALUE), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.symbols.getRootCodelistOfField(fieldId)), this.script.getStringLiteralFromUnquotedString("."), valueReference))));
                break;
            }
            default: {
                throw new ParseCancellationException(String.format("Unexpected field type '%s'. Expected a field of either type 'code' or 'indicator'.", fieldType));
            }
        }
    }

    @Override
    public void exitShorthandContextLabelReference(EfxParser.ShorthandContextLabelReferenceContext ctx) {
        String labelType = ctx.LabelType().getText();
        if (this.efxContext.isFieldContext().booleanValue()) {
            if (labelType.equals(LABEL_TYPE_VALUE)) {
                this.shorthandFieldValueLabelReference(this.efxContext.symbol());
            } else {
                this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_FIELD), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(labelType), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.efxContext.symbol())))));
            }
        } else if (this.efxContext.isNodeContext().booleanValue()) {
            this.stack.push(this.markup.renderLabelFromKey(this.script.composeStringConcatenation(List.of(this.script.getStringLiteralFromUnquotedString(ASSET_TYPE_BT), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(labelType), this.script.getStringLiteralFromUnquotedString("|"), this.script.getStringLiteralFromUnquotedString(this.efxContext.symbol())))));
        }
    }

    @Override
    public void exitShorthandContextFieldLabelReference(EfxParser.ShorthandContextFieldLabelReferenceContext ctx) {
        if (!this.efxContext.isFieldContext().booleanValue()) {
            throw new ParseCancellationException("The #value shorthand syntax can only be used in a field is declared as context.");
        }
        this.shorthandFieldValueLabelReference(this.efxContext.symbol());
    }

    @Override
    public void exitAssetType(EfxParser.AssetTypeContext ctx) {
        if (ctx.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(ctx.getText()));
        }
    }

    @Override
    public void exitLabelType(EfxParser.LabelTypeContext ctx) {
        if (ctx.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(ctx.getText()));
        }
    }

    @Override
    public void exitAssetId(EfxParser.AssetIdContext ctx) {
        if (ctx.expressionBlock() == null) {
            this.stack.push(this.script.getStringLiteralFromUnquotedString(ctx.getText()));
        }
    }

    @Override
    public void exitStandardExpressionBlock(EfxParser.StandardExpressionBlockContext ctx) {
        this.stack.push(this.stack.pop(Expression.class));
    }

    @Override
    public void exitShorthandContextFieldValueReference(EfxParser.ShorthandContextFieldValueReferenceContext ctx) {
        if (!this.efxContext.isFieldContext().booleanValue()) {
            throw new ParseCancellationException("The $value shorthand syntax can only be used when a field is declared as the context.");
        }
        this.stack.push(this.script.composeFieldValueReference(this.symbols.getRelativePathOfField(this.efxContext.symbol(), this.efxContext.absolutePath()), Expression.class));
    }

    @Override
    public void exitContextDeclarationBlock(EfxParser.ContextDeclarationBlockContext ctx) {
        String filedId = EfxTemplateTranslator.getFieldIdFromChildSimpleFieldReferenceContext(ctx);
        if (filedId != null) {
            this.efxContext.push(new Context.FieldContext(filedId, this.stack.pop(Expression.PathExpression.class)));
        } else {
            String nodeId = EfxTemplateTranslator.getNodeIdFromChildSimpleNodeReferenceContext(ctx);
            assert (nodeId != null) : "We should have been able to locate the FieldId or NodeId declared as context.";
            this.efxContext.push(new Context.NodeContext(nodeId, this.stack.pop(Expression.PathExpression.class)));
        }
    }

    @Override
    public void exitTemplateLine(EfxParser.TemplateLineContext ctx) {
        Context lineContext = (Context)this.efxContext.pop();
        int indentLevel = this.getIndentLevel(ctx);
        int indentChange = indentLevel - this.blockStack.currentIndentationLevel();
        Markup content = ctx.template() != null ? this.stack.pop(Markup.class) : new Markup("");
        Integer outlineNumber = ctx.OutlineNumber() != null ? Integer.parseInt(ctx.OutlineNumber().getText().trim()) : -1;
        assert (this.stack.isEmpty()) : "Stack should be empty at this point.";
        if (indentChange > 1) {
            throw new ParseCancellationException(INDENTATION_LEVEL_SKIPPED);
        }
        if (indentChange == 1) {
            if (this.blockStack.isEmpty()) {
                throw new ParseCancellationException(START_INDENT_AT_ZERO);
            }
            this.blockStack.pushChild(outlineNumber, content, lineContext);
        } else if (indentChange < 0) {
            for (int i = indentChange; i < 0; ++i) {
                assert (!this.blockStack.isEmpty()) : "Unexpected indentation tracker state.";
                assert (this.blockStack.currentIndentationLevel() > indentLevel) : "Unexpected indentation tracker state.";
                this.blockStack.pop();
            }
            assert (this.blockStack.currentIndentationLevel() == indentLevel) : "Unexpected indentation tracker state.";
            this.blockStack.pushSibling(outlineNumber, content, lineContext);
        } else if (indentChange == 0) {
            if (this.blockStack.isEmpty()) {
                assert (indentLevel == 0) : "Unexpected indentation tracker state.";
                this.blockStack.push(this.rootBlock.addChild(outlineNumber, content, lineContext));
            } else {
                this.blockStack.pushSibling(outlineNumber, content, lineContext);
            }
        }
    }

    private int getIndentLevel(EfxParser.TemplateLineContext ctx) {
        if (ctx.MixedIndent() != null) {
            throw new ParseCancellationException(MIXED_INDENTATION);
        }
        if (ctx.Spaces() != null) {
            if (this.indentWith == Indent.UNDETERMINED) {
                this.indentWith = Indent.SPACES;
                this.indentSpaces = ctx.Spaces().getText().length();
            } else if (this.indentWith == Indent.TABS) {
                throw new ParseCancellationException(MIXED_INDENTATION);
            }
            if (ctx.Spaces().getText().length() % this.indentSpaces != 0) {
                throw new ParseCancellationException(String.format(INCONSISTENT_INDENTATION_SPACES, this.indentSpaces));
            }
            return ctx.Spaces().getText().length() / this.indentSpaces;
        }
        if (ctx.Tabs() != null) {
            if (this.indentWith == Indent.UNDETERMINED) {
                this.indentWith = Indent.TABS;
            } else if (this.indentWith == Indent.SPACES) {
                throw new ParseCancellationException(MIXED_INDENTATION);
            }
            return ctx.Tabs().getText().length();
        }
        return 0;
    }

    private static enum Indent {
        TABS,
        SPACES,
        UNDETERMINED;

    }
}

