/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;

public class SdkNode
implements Comparable<SdkNode> {
    private final String id;
    private final String xpathAbsolute;
    private final String xpathRelative;
    private final String parentId;
    private final boolean repeatable;

    public SdkNode(String id, String parentId, String xpathAbsolute, String xpathRelative, boolean repeatable) {
        this.id = id;
        this.parentId = parentId;
        this.xpathAbsolute = xpathAbsolute;
        this.xpathRelative = xpathRelative;
        this.repeatable = repeatable;
    }

    public SdkNode(JsonNode node) {
        this.id = node.get("id").asText(null);
        this.parentId = node.has("parentId") ? node.get("parentId").asText(null) : null;
        this.xpathAbsolute = node.get("xpathAbsolute").asText(null);
        this.xpathRelative = node.get("xpathRelative").asText(null);
        this.repeatable = node.hasNonNull("repeatable") ? node.get("repeatable").asBoolean(false) : false;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getXpathAbsolute() {
        return this.xpathAbsolute;
    }

    public String getXpathRelative() {
        return this.xpathRelative;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    @Override
    public int compareTo(SdkNode o) {
        return o.getId().compareTo(o.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdkNode other = (SdkNode)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }
}

