/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.function.Supplier;

public class SdkField
implements Comparable<SdkField> {
    private final String id;
    private final String xpathAbsolute;
    private final String xpathRelative;
    private final String parentNodeId;
    private final String type;
    private final String rootCodelistId;

    public SdkField(String id, String type, String parentNodeId, String xpathAbsolute, String xpathRelative, String rootCodelistId) {
        this.id = id;
        this.parentNodeId = parentNodeId;
        this.xpathAbsolute = xpathAbsolute;
        this.xpathRelative = xpathRelative;
        this.type = type;
        this.rootCodelistId = rootCodelistId;
    }

    public SdkField(JsonNode field) {
        this.id = field.get("id").asText(null);
        this.parentNodeId = field.get("parentNodeId").asText(null);
        this.xpathAbsolute = field.get("xpathAbsolute").asText(null);
        this.xpathRelative = field.get("xpathRelative").asText(null);
        this.type = field.get("type").asText(null);
        Supplier<String> rootCodelistIdSupplier = () -> {
            JsonNode codelistNode = field.get("codeList");
            if (codelistNode == null) {
                return null;
            }
            JsonNode valueNode = codelistNode.get("value");
            if (valueNode == null) {
                return null;
            }
            String parentCodelistId = valueNode.has("parentId") ? valueNode.get("parentId").asText(null) : null;
            return parentCodelistId == null ? valueNode.get("id").asText(null) : parentCodelistId;
        };
        this.rootCodelistId = rootCodelistIdSupplier.get();
    }

    public String getId() {
        return this.id;
    }

    public String getParentNodeId() {
        return this.parentNodeId;
    }

    public String getXpathAbsolute() {
        return this.xpathAbsolute;
    }

    public String getXpathRelative() {
        return this.xpathRelative;
    }

    public String getType() {
        return this.type;
    }

    public String getRootCodelistId() {
        return this.rootCodelistId;
    }

    @Override
    public int compareTo(SdkField o) {
        return this.getId().compareTo(o.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdkField other = (SdkField)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "SdkField [id=" + this.id + "]";
    }
}

