/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx.model;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class SdkCodelist
implements Comparable<SdkCodelist> {
    private final String codelistId;
    private final String codelistVersion;
    private final List<String> codes;

    public SdkCodelist(String codelistId, String codelistVersion, List<String> codes) {
        this.codelistId = codelistId;
        this.codelistVersion = codelistVersion;
        this.codes = codes;
    }

    public String getCodelistId() {
        return this.codelistId;
    }

    public String getVersion() {
        return this.codelistVersion;
    }

    public List<String> getCodes() {
        return this.codes;
    }

    public String toString(CharSequence delimiter, CharSequence prefix, CharSequence suffix, Character quote) {
        StringJoiner joiner = new StringJoiner(delimiter, prefix, suffix);
        for (String code : this.codes) {
            joiner.add(quote + code + quote);
        }
        return joiner.toString();
    }

    public String toString() {
        return this.codelistId + "-" + this.codelistVersion;
    }

    @Override
    public int compareTo(SdkCodelist cl) {
        return Objects.compare(this.getCodelistId() + this.getVersion(), cl.getCodelistId() + cl.getVersion(), String::compareTo);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdkCodelist other = (SdkCodelist)obj;
        return Objects.equals(this.codelistId, other.codelistId) && Objects.equals(this.codelistVersion, other.codelistVersion);
    }

    public int hashCode() {
        return Objects.hash(this.codelistId, this.codelistVersion);
    }
}

