/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.efx;

import eu.europa.ted.efx.interfaces.TranslatorDependencyFactory;
import eu.europa.ted.efx.sdk0.v6.EfxExpressionTranslator;
import eu.europa.ted.efx.sdk0.v6.EfxTemplateTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public class EfxTranslator {
    private static final String SDK_VERSION_V_NOT_SUPPORTED = "SDK version '%s' not supported";

    public static String translateExpression(String context, String expression, TranslatorDependencyFactory dependencyFactory, String sdkVersion) {
        switch (EfxTranslator.normalizeVersion(sdkVersion)) {
            case SDK_0_6: {
                return EfxExpressionTranslator.translateExpression(context, expression, dependencyFactory.createSymbolResolver(sdkVersion), dependencyFactory.createScriptGenerator(), dependencyFactory.createErrorListener());
            }
        }
        throw new RuntimeException(String.format(SDK_VERSION_V_NOT_SUPPORTED, sdkVersion));
    }

    public static String translateTemplate(Path pathname, TranslatorDependencyFactory factory, String sdkVersion) throws IOException {
        switch (EfxTranslator.normalizeVersion(sdkVersion)) {
            case SDK_0_6: {
                return EfxTemplateTranslator.renderTemplate(pathname, factory, sdkVersion);
            }
        }
        throw new RuntimeException(String.format(SDK_VERSION_V_NOT_SUPPORTED, sdkVersion));
    }

    public static String translateTemplate(String template, TranslatorDependencyFactory factory, String sdkVersion) {
        switch (EfxTranslator.normalizeVersion(sdkVersion)) {
            case SDK_0_6: {
                return EfxTemplateTranslator.renderTemplate(template, factory, sdkVersion);
            }
        }
        throw new RuntimeException(String.format(SDK_VERSION_V_NOT_SUPPORTED, sdkVersion));
    }

    public static String translateTemplate(InputStream stream, TranslatorDependencyFactory factory, String sdkVersion) throws IOException {
        switch (EfxTranslator.normalizeVersion(sdkVersion)) {
            case SDK_0_6: {
                return EfxTemplateTranslator.renderTemplate(stream, factory, sdkVersion);
            }
        }
        throw new RuntimeException(String.format(SDK_VERSION_V_NOT_SUPPORTED, sdkVersion));
    }

    private static KnownSdkVersions normalizeVersion(String sdkVersion) {
        String[] numbers;
        Object normalizedVersion = sdkVersion;
        if (((String)normalizedVersion).startsWith("eforms-sdk-")) {
            normalizedVersion = ((String)normalizedVersion).substring(11);
        }
        normalizedVersion = "SDK_" + ((numbers = ((String)normalizedVersion).split("\\.", -2)).length > 0 ? numbers[0] : "") + "_" + (numbers.length > 1 ? numbers[1] : "");
        try {
            return KnownSdkVersions.valueOf((String)normalizedVersion);
        }
        catch (IllegalArgumentException e) {
            return KnownSdkVersions.UNSUPPORTED;
        }
    }

    static enum KnownSdkVersions {
        SDK_0_6,
        UNSUPPORTED;

    }
}

