/*
 * Decompiled with CFR 0.152.
 */
package eu.erasmuswithoutpaper.registryclient;

import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

abstract class SelfSchedulableTask
implements Runnable {
    private final ScheduledExecutorService executor;
    private final long minPeriod;

    SelfSchedulableTask(ScheduledExecutorService executor, long minPeriod) {
        this.executor = executor;
        this.minPeriod = minPeriod;
    }

    @Override
    public final void run() {
        Date nextRun = this.runAndScheduleNext();
        if (nextRun == null) {
            return;
        }
        long delay = nextRun.getTime() - System.currentTimeMillis();
        if (delay < this.minPeriod) {
            delay = this.minPeriod;
        }
        this.executor.schedule(this, delay, TimeUnit.MILLISECONDS);
    }

    protected abstract Date runAndScheduleNext();
}

