/*
 * Decompiled with CFR 0.152.
 */
package eu.erasmuswithoutpaper.registryclient;

import eu.erasmuswithoutpaper.registryclient.ApiSearchConditions;
import eu.erasmuswithoutpaper.registryclient.HeiEntry;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Date;
import org.w3c.dom.Element;

public interface RegistryClient
extends AutoCloseable {
    public static final String REGISTRY_CATALOGUE_V1_NAMESPACE_URI = "https://github.com/erasmus-without-paper/ewp-specs-api-registry/tree/stable-v1";

    public boolean areHeisCoveredByCertificate(Collection<String> var1, Certificate var2) throws UnacceptableStalenessException;

    public boolean areHeisCoveredByCertificate(String[] var1, Certificate var2) throws UnacceptableStalenessException;

    public boolean areHeisCoveredByClientKey(Collection<String> var1, RSAPublicKey var2) throws UnacceptableStalenessException;

    public boolean areHeisCoveredByClientKey(String[] var1, RSAPublicKey var2) throws UnacceptableStalenessException;

    public void assertApiIsCoveredByServerKey(Element var1, RSAPublicKey var2) throws AssertionFailedException, InvalidApiEntryElement, UnacceptableStalenessException;

    public void assertCertificateIsKnown(Certificate var1) throws AssertionFailedException, UnacceptableStalenessException;

    public void assertClientKeyIsKnown(RSAPublicKey var1) throws AssertionFailedException, UnacceptableStalenessException;

    public void assertHeiIsCoveredByCertificate(String var1, Certificate var2) throws AssertionFailedException, UnacceptableStalenessException;

    public void assertHeiIsCoveredByClientKey(String var1, RSAPublicKey var2) throws AssertionFailedException, UnacceptableStalenessException;

    public void assertHeisAreCoveredByCertificate(Collection<String> var1, Certificate var2) throws AssertionFailedException, UnacceptableStalenessException;

    public void assertHeisAreCoveredByCertificate(String[] var1, Certificate var2) throws AssertionFailedException, UnacceptableStalenessException;

    public void assertHeisAreCoveredByClientKey(Collection<String> var1, RSAPublicKey var2) throws AssertionFailedException, UnacceptableStalenessException;

    public void assertHeisAreCoveredByClientKey(String[] var1, RSAPublicKey var2) throws AssertionFailedException, UnacceptableStalenessException;

    @Override
    public void close();

    public Element findApi(ApiSearchConditions var1) throws UnacceptableStalenessException;

    public Collection<Element> findApis(ApiSearchConditions var1) throws UnacceptableStalenessException;

    public HeiEntry findHei(String var1) throws UnacceptableStalenessException;

    public HeiEntry findHei(String var1, String var2) throws UnacceptableStalenessException;

    public String findHeiId(String var1, String var2) throws UnacceptableStalenessException;

    public Collection<HeiEntry> findHeis(ApiSearchConditions var1) throws UnacceptableStalenessException;

    public RSAPublicKey findRsaPublicKey(String var1) throws UnacceptableStalenessException;

    public Collection<HeiEntry> getAllHeis() throws UnacceptableStalenessException;

    public Date getExpiryDate();

    public Collection<String> getHeisCoveredByCertificate(Certificate var1) throws UnacceptableStalenessException;

    public Collection<String> getHeisCoveredByClientKey(RSAPublicKey var1) throws UnacceptableStalenessException;

    public RSAPublicKey getServerKeyCoveringApi(Element var1) throws UnacceptableStalenessException, InvalidApiEntryElement;

    public Collection<RSAPublicKey> getServerKeysCoveringApi(Element var1) throws UnacceptableStalenessException, InvalidApiEntryElement;

    public boolean isApiCoveredByServerKey(Element var1, RSAPublicKey var2) throws UnacceptableStalenessException, InvalidApiEntryElement;

    public boolean isCertificateKnown(Certificate var1) throws UnacceptableStalenessException;

    public boolean isClientKeyKnown(RSAPublicKey var1) throws UnacceptableStalenessException;

    public boolean isHeiCoveredByCertificate(String var1, Certificate var2) throws UnacceptableStalenessException;

    public boolean isHeiCoveredByClientKey(String var1, RSAPublicKey var2) throws UnacceptableStalenessException;

    public void refresh() throws RefreshFailureException;

    public static class UnacceptableStalenessException
    extends RegistryClientRuntimeException {
    }

    public static class StaleApiEntryElement
    extends InvalidApiEntryElement {
        public StaleApiEntryElement() {
        }

        public StaleApiEntryElement(RuntimeException cause) {
            super(cause);
        }
    }

    public static abstract class RegistryClientRuntimeException
    extends RuntimeException {
        public RegistryClientRuntimeException() {
        }

        public RegistryClientRuntimeException(RuntimeException cause) {
            super(cause);
        }
    }

    public static abstract class RegistryClientException
    extends Exception {
        protected RegistryClientException(Exception cause) {
            super(cause);
        }

        protected RegistryClientException(String message) {
            super(message);
        }

        protected RegistryClientException(String message, Exception cause) {
            super(message, cause);
        }
    }

    public static class RefreshFailureException
    extends RegistryClientException {
        public RefreshFailureException(Exception cause) {
            super(cause);
        }

        public RefreshFailureException(String message) {
            super(message);
        }

        public RefreshFailureException(String message, Exception cause) {
            super(message, cause);
        }
    }

    public static class InvalidApiEntryElement
    extends RegistryClientRuntimeException {
        public InvalidApiEntryElement() {
        }

        public InvalidApiEntryElement(RuntimeException cause) {
            super(cause);
        }
    }

    public static class AssertionFailedException
    extends RegistryClientException {
        public AssertionFailedException(String message) {
            super(message);
        }
    }
}

