/*
 * Decompiled with CFR 0.152.
 */
package eu.erasmuswithoutpaper.registryclient;

import eu.erasmuswithoutpaper.registryclient.HeiEntry;
import eu.erasmuswithoutpaper.registryclient.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class HeiEntryImpl
implements HeiEntry {
    private final String id;
    private final Element elem;
    private volatile Extras extras = null;

    HeiEntryImpl(String id, Element heiElem) {
        this.id = id;
        this.elem = heiElem;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        String bestName = this.getNameEnglish();
        if (bestName != null) {
            return bestName;
        }
        bestName = this.getNameNonEnglish();
        if (bestName != null) {
            return bestName;
        }
        return this.id;
    }

    @Override
    public String getName(String langCode) {
        return (String)this.getExtras().allNames.get(langCode);
    }

    @Override
    public String getNameEnglish() {
        String englishName = (String)this.getExtras().allNames.get("en");
        if (englishName != null) {
            return englishName;
        }
        for (String s : this.getExtras().allNames.keySet()) {
            if (s.length() < 2 || !s.substring(0, 2).equalsIgnoreCase("en")) continue;
            return (String)this.getExtras().allNames.get(s);
        }
        return null;
    }

    @Override
    public String getNameNonEnglish() {
        for (String s : this.getExtras().allNames.keySet()) {
            if (s.toLowerCase(Locale.ROOT).startsWith("en")) continue;
            return (String)this.getExtras().allNames.get(s);
        }
        return null;
    }

    @Override
    public Collection<String> getOtherIds(String type) {
        List values = (List)this.getExtras().otherIds.get(type);
        if (values == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extras getExtras() {
        if (this.extras == null) {
            HeiEntryImpl heiEntryImpl = this;
            synchronized (heiEntryImpl) {
                if (this.extras == null) {
                    this.extras = new Extras(this);
                }
            }
        }
        return this.extras;
    }

    private static class Extras {
        private final Map<String, String> allNames = new HashMap<String, String>();
        private final Map<String, List<String>> otherIds = new HashMap<String, List<String>>();

        private Extras(HeiEntryImpl hei) {
            for (Node node : Utils.asNodeList(hei.elem.getChildNodes())) {
                if (node.getNodeType() != 1) continue;
                Element elem = (Element)node;
                String value = elem.getTextContent();
                switch (elem.getTagName()) {
                    case "name": {
                        String lang = elem.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                        if (value.length() <= 0) break;
                        this.allNames.put(lang, value);
                        break;
                    }
                    case "other-id": {
                        String idType = elem.getAttribute("type");
                        List<String> lst = this.otherIds.get(idType);
                        if (lst == null) {
                            lst = new ArrayList<String>();
                            this.otherIds.put(idType, lst);
                        }
                        lst.add(value);
                        break;
                    }
                }
            }
        }
    }
}

