/*
 * Decompiled with CFR 0.152.
 */
package eu.erasmuswithoutpaper.registryclient;

import eu.erasmuswithoutpaper.registryclient.CatalogueFetcher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalogueFetcher
implements CatalogueFetcher {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCatalogueFetcher.class);
    private final String registryDomain;

    private static byte[] readEntireStream(InputStream is) throws IOException {
        int nread;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nread = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nread);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public DefaultCatalogueFetcher() {
        this.registryDomain = "registry.erasmuswithoutpaper.eu";
    }

    public DefaultCatalogueFetcher(String customRegistryDomain) {
        this.registryDomain = customRegistryDomain;
    }

    @Override
    public CatalogueFetcher.RegistryResponse fetchCatalogue(String previousETag) throws IOException {
        URL url;
        try {
            url = new URL("https://" + this.registryDomain + "/catalogue-v1.xml");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        logger.debug("Opening HTTPS connection to " + url);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setAllowUserInteraction(false);
        conn.setRequestProperty("If-None-Match", previousETag);
        conn.connect();
        int status = conn.getResponseCode();
        logger.debug("Registry API responded with HTTP " + status);
        long clientTimeNow = System.currentTimeMillis();
        long serverTimeNow = conn.getHeaderFieldDate("Date", clientTimeNow);
        long difference = serverTimeNow - clientTimeNow;
        if (Math.abs(difference) > 60000L) {
            logger.debug("Difference in server-client time is " + difference + "ms");
        }
        long serverTimeExpires = conn.getHeaderFieldDate("Expires", clientTimeNow + 300000L);
        Date expires = new Date(clientTimeNow + (serverTimeExpires - serverTimeNow));
        logger.debug("Effective expiry time: " + expires);
        switch (status) {
            case 200: {
                String newETag = conn.getHeaderField("ETag");
                byte[] content = DefaultCatalogueFetcher.readEntireStream(conn.getInputStream());
                logger.debug("Read " + content.length + " bytes with ETag " + newETag);
                return new CatalogueFetcher.Http200RegistryResponse(content, newETag, expires);
            }
            case 304: {
                return new CatalogueFetcher.Http304RegistryResponse(expires);
            }
        }
        throw new IOException("Unexpected Registry API response status: " + status);
    }
}

