/*
 * Decompiled with CFR 0.152.
 */
package eu.erasmuswithoutpaper.registryclient;

import eu.erasmuswithoutpaper.registryclient.CatalogueFetcher;
import eu.erasmuswithoutpaper.registryclient.DefaultCatalogueFetcher;
import java.util.Map;

public class ClientImplOptions {
    private CatalogueFetcher catalogueFetcher = new DefaultCatalogueFetcher();
    private long maxAcceptableStaleness = 432000000L;
    private boolean autoRefreshing = false;
    private Map<String, byte[]> persistentCacheMap = null;
    private long minTimeBetweenQueries = 60000L;
    private long timeBetweenRetries = 180000L;

    @Deprecated
    public boolean getAutoRefreshing() {
        return this.isAutoRefreshing();
    }

    public CatalogueFetcher getCatalogueFetcher() {
        return this.catalogueFetcher;
    }

    public long getMaxAcceptableStaleness() {
        return this.maxAcceptableStaleness;
    }

    public long getMinTimeBetweenQueries() {
        return this.minTimeBetweenQueries;
    }

    public Map<String, byte[]> getPersistentCacheMap() {
        return this.persistentCacheMap;
    }

    @Deprecated
    public Map<String, byte[]> getPersistentCacheProvider() {
        return this.persistentCacheMap;
    }

    public long getStalenessWarningThreshold() {
        return Math.min(this.getMaxAcceptableStaleness() / 4L, 86400000L);
    }

    public long getTimeBetweenRetries() {
        return this.timeBetweenRetries;
    }

    public boolean isAutoRefreshing() {
        return this.autoRefreshing;
    }

    public ClientImplOptions setAutoRefreshing(boolean autoRefreshing) {
        this.autoRefreshing = autoRefreshing;
        return this;
    }

    public ClientImplOptions setCatalogueFetcher(CatalogueFetcher catalogueFetcher) {
        if (catalogueFetcher == null) {
            throw new IllegalArgumentException();
        }
        this.catalogueFetcher = catalogueFetcher;
        return this;
    }

    public ClientImplOptions setMaxAcceptableStaleness(long milliseconds) {
        this.maxAcceptableStaleness = milliseconds;
        return this;
    }

    public ClientImplOptions setMinTimeBetweenQueries(long milliseconds) {
        this.minTimeBetweenQueries = milliseconds;
        return this;
    }

    public ClientImplOptions setPersistentCacheMap(Map<String, byte[]> persistentCacheMap) {
        this.persistentCacheMap = persistentCacheMap;
        return this;
    }

    public ClientImplOptions setTimeBetweenRetries(long milliseconds) {
        this.timeBetweenRetries = milliseconds;
        return this;
    }

    public String toString() {
        return "ClientImplOptions [catalogueFetcher=" + this.catalogueFetcher + ", maxAcceptableStaleness=" + this.maxAcceptableStaleness + ", autoRefreshing=" + this.autoRefreshing + ", persistentCacheProvider=" + this.persistentCacheMap + "]";
    }
}

