/*
 * Decompiled with CFR 0.152.
 */
package eu.erasmuswithoutpaper.registryclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Date;

public interface CatalogueFetcher {
    public RegistryResponse fetchCatalogue(String var1) throws IOException;

    public static abstract class RegistryResponse {
        private final Date expires;

        RegistryResponse(Date expires) {
            this.expires = expires;
        }

        Date getExpires() {
            if (this.expires != null) {
                return new Date(this.expires.getTime());
            }
            return null;
        }
    }

    public static class Http304RegistryResponse
    extends RegistryResponse {
        protected Http304RegistryResponse(Date expires) {
            super(expires);
        }
    }

    public static class Http200RegistryResponse
    extends RegistryResponse {
        private final byte[] content;
        private final String etag;

        static Http200RegistryResponse deserialize(byte[] raw) throws CouldNotDeserialize {
            try {
                try {
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(raw));
                    int version = in.readInt();
                    if (version != 1) {
                        throw new CouldNotDeserialize();
                    }
                    Date expires = (Date)in.readObject();
                    byte[] content = (byte[])in.readObject();
                    String etag = (String)in.readObject();
                    return new Http200RegistryResponse(content, etag, expires);
                }
                catch (StreamCorruptedException | ClassNotFoundException e) {
                    throw new CouldNotDeserialize();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Http200RegistryResponse(byte[] content, String etag, Date expires) {
            super(expires);
            this.content = (byte[])content.clone();
            this.etag = etag;
        }

        byte[] getContent() {
            return this.content;
        }

        String getETag() {
            return this.etag;
        }

        byte[] serialize() {
            try {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(data);
                out.writeInt(1);
                out.writeObject(this.getExpires());
                out.writeObject(this.getContent());
                out.writeObject(this.getETag());
                return data.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        static class CouldNotDeserialize
        extends Exception {
            CouldNotDeserialize() {
            }
        }
    }
}

