/*
 * Decompiled with CFR 0.152.
 */
package eu.erasmuswithoutpaper.registryclient;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import eu.erasmuswithoutpaper.registryclient.ApiSearchConditions;
import eu.erasmuswithoutpaper.registryclient.CatalogueFetcher;
import eu.erasmuswithoutpaper.registryclient.HeiEntry;
import eu.erasmuswithoutpaper.registryclient.HeiEntryImpl;
import eu.erasmuswithoutpaper.registryclient.RegistryClient;
import eu.erasmuswithoutpaper.registryclient.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
class CatalogueDocument {
    private static final Logger logger = LoggerFactory.getLogger(CatalogueDocument.class);
    private static final String INTERNAL_USERDATA_KEY = "59a03da6-2456-4be1-9d21-13dc0df41978";
    private final Document doc;
    private final String etag;
    private final Map<String, Set<String>> certHeis;
    private final Map<String, Set<String>> cliKeyHeis;
    private final Map<Element, Set<String>> hostHeis;
    private final Map<Element, Set<String>> hostServerKeys;
    private final Map<String, Map<String, String>> heiIdMaps;
    private final Map<String, HeiEntry> heiEntries;
    private final Map<String, List<Element>> apiIndex;
    private final HashMap<String, RSAPublicKey> keyBodies;
    private volatile Date expires;

    private static String getApiIndexKey(String namespaceUri, String localName) {
        return "{" + namespaceUri + "}" + localName;
    }

    private static String getCanonicalId(String value) {
        return value.trim().toLowerCase(Locale.ENGLISH);
    }

    static boolean doesVersionXMatchMinimumRequiredVersionY(String apiVersion, String minRequiredVersion) {
        int i;
        String[] s1 = apiVersion.split("\\.");
        String[] s2 = minRequiredVersion.split("\\.");
        if (s1.length != 3 || s2.length != 3) {
            return false;
        }
        int[] i1 = new int[3];
        int[] i2 = new int[3];
        try {
            for (i = 0; i < 3; ++i) {
                i1[i] = Integer.parseInt(s1[i]);
                i2[i] = Integer.parseInt(s2[i]);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (i1[i] > i2[i]) {
                return true;
            }
            if (i1[i] >= i2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    CatalogueDocument(CatalogueFetcher.Http200RegistryResponse registryResponse) throws CatalogueParserException {
        DocumentBuilder docBuilder = Utils.newSecureDocumentBuilder();
        this.expires = registryResponse.getExpires();
        if (this.expires == null) {
            logger.warn("Missing 'Expires' header in catalogue response. Will assume 5 minutes.");
            this.expires = new Date(new Date().getTime() + 300000L);
        }
        this.etag = registryResponse.getETag();
        try {
            this.doc = docBuilder.parse(new ByteArrayInputStream(registryResponse.getContent()));
        }
        catch (SAXException e) {
            throw new CatalogueParserException("Problem parsing the catalogue response", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Element root = this.doc.getDocumentElement();
        if (root.getNamespaceURI() == null || !root.getNamespaceURI().equals("https://github.com/erasmus-without-paper/ewp-specs-api-registry/tree/stable-v1")) {
            throw new CatalogueParserException("Catalogue namespace URI mismatch.");
        }
        if (!root.getLocalName().equals("catalogue")) {
            throw new CatalogueParserException("Catalogue localName mismatch.");
        }
        XPathFactory xpathfactory = XPathFactory.newInstance();
        XPath xpath = xpathfactory.newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if ("r".equals(prefix)) {
                    return "https://github.com/erasmus-without-paper/ewp-specs-api-registry/tree/stable-v1";
                }
                throw new IllegalArgumentException(prefix);
            }

            @Override
            public String getPrefix(String namespaceUri) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceUri) {
                throw new UnsupportedOperationException();
            }
        });
        this.certHeis = new HashMap<String, Set<String>>();
        this.cliKeyHeis = new HashMap<String, Set<String>>();
        this.hostHeis = new HashMap<Element, Set<String>>();
        this.hostServerKeys = new HashMap<Element, Set<String>>();
        this.heiIdMaps = new HashMap<String, Map<String, String>>();
        this.apiIndex = new HashMap<String, List<Element>>();
        this.heiEntries = new HashMap<String, HeiEntry>();
        this.keyBodies = new HashMap();
        try {
            KeyFactory rsaKeyFactory;
            Set<Object> coveredHeis;
            for (Element element : Utils.asElementList((NodeList)xpath.evaluate("r:host/r:client-credentials-in-use/r:certificate", root, XPathConstants.NODESET))) {
                String string = element.getAttribute("sha-256");
                if (this.certHeis.containsKey(string)) {
                    coveredHeis = this.certHeis.get(string);
                } else {
                    coveredHeis = new HashSet();
                    this.certHeis.put(string, coveredHeis);
                }
                for (Element element2 : Utils.asElementList((NodeList)xpath.evaluate("../../r:institutions-covered/r:hei-id", element, XPathConstants.NODESET))) {
                    coveredHeis.add(element2.getTextContent());
                }
            }
            for (Element element : Utils.asElementList((NodeList)xpath.evaluate("r:host/r:client-credentials-in-use/r:rsa-public-key", root, XPathConstants.NODESET))) {
                String string = element.getAttribute("sha-256");
                if (this.cliKeyHeis.containsKey(string)) {
                    coveredHeis = this.cliKeyHeis.get(string);
                } else {
                    coveredHeis = new HashSet();
                    this.cliKeyHeis.put(string, coveredHeis);
                }
                for (Element element3 : Utils.asElementList((NodeList)xpath.evaluate("../../r:institutions-covered/r:hei-id", element, XPathConstants.NODESET))) {
                    coveredHeis.add(element3.getTextContent());
                }
            }
            for (Element element : Utils.asElementList((NodeList)xpath.evaluate("r:institutions/r:hei/r:other-id", root, XPathConstants.NODESET))) {
                void var11_54;
                String string = element.getAttribute("type");
                String value = element.getTextContent();
                String string2 = ((Element)element.getParentNode()).getAttribute("id");
                Map<String, String> map = this.heiIdMaps.get(string);
                if (map == null) {
                    HashMap hashMap = new HashMap();
                    this.heiIdMaps.put(string, hashMap);
                }
                var11_54.put(CatalogueDocument.getCanonicalId(value), string2);
            }
            for (Element element : Utils.asElementList((NodeList)xpath.evaluate("r:institutions/r:hei", root, XPathConstants.NODESET))) {
                String string = element.getAttribute("id");
                HeiEntryImpl hei = new HeiEntryImpl(string, element);
                this.heiEntries.put(string, hei);
            }
            for (Element element : Utils.asElementList((NodeList)xpath.evaluate("r:host/r:apis-implemented/*", root, XPathConstants.NODESET))) {
                String string = CatalogueDocument.getApiIndexKey(element.getNamespaceURI(), element.getLocalName());
                List<Element> entries = this.apiIndex.get(string);
                if (entries == null) {
                    entries = new ArrayList<Element>();
                    this.apiIndex.put(string, entries);
                }
                entries.add(element);
            }
            for (Element element : Utils.asElementList((NodeList)xpath.evaluate("r:host", root, XPathConstants.NODESET))) {
                HashSet<String> hashSet = new HashSet<String>();
                this.hostHeis.put(element, hashSet);
                for (Element element4 : Utils.asElementList((NodeList)xpath.evaluate("r:institutions-covered/r:hei-id", element, XPathConstants.NODESET))) {
                    String string = element4.getTextContent();
                    hashSet.add(string);
                }
                HashSet<String> keys = new HashSet<String>();
                this.hostServerKeys.put(element, keys);
                for (Element element5 : Utils.asElementList((NodeList)xpath.evaluate("r:server-credentials-in-use/r:rsa-public-key", element, XPathConstants.NODESET))) {
                    String fingerprint2 = element5.getAttribute("sha-256");
                    keys.add(fingerprint2);
                }
            }
            try {
                rsaKeyFactory = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
            for (Element element : Utils.asElementList((NodeList)xpath.evaluate("r:binaries/r:rsa-public-key", root, XPathConstants.NODESET))) {
                String fingerprint3 = element.getAttribute("sha-256");
                byte[] byArray = DatatypeConverter.parseBase64Binary((String)element.getTextContent());
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                try {
                    RSAPublicKey value = (RSAPublicKey)rsaKeyFactory.generatePublic(x509EncodedKeySpec);
                    this.keyBodies.put(fingerprint3, value);
                }
                catch (ClassCastException | InvalidKeySpecException e) {
                    logger.warn("Could not load object " + fingerprint3 + " as RSAPublicKey: " + e.toString());
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isApiCoveredByServerKey(Element apiElement, RSAPublicKey serverKey) throws RegistryClient.InvalidApiEntryElement {
        return this.extractFingerprintsForApiElement(apiElement).contains(Utils.extractFingerprint(serverKey));
    }

    public String toString() {
        return "CatalogueDocument[ETag=" + this.getETag() + ", Expires=" + this.getExpiryDate() + "]";
    }

    private boolean doesElementMatchConditions(Element elem, ApiSearchConditions conds) {
        if (conds.getRequiredNamespaceUri() != null && !conds.getRequiredNamespaceUri().equals(elem.getNamespaceURI())) {
            return false;
        }
        if (conds.getRequiredLocalName() != null && !conds.getRequiredLocalName().equals(elem.getLocalName())) {
            return false;
        }
        if (conds.getRequiredMinVersion() != null) {
            String attrVer = elem.getAttribute("version");
            if (attrVer.isEmpty()) {
                return false;
            }
            if (!CatalogueDocument.doesVersionXMatchMinimumRequiredVersionY(attrVer, conds.getRequiredMinVersion())) {
                return false;
            }
        }
        if (conds.getRequiredHei() != null) {
            Element hostElem = (Element)elem.getParentNode().getParentNode();
            Set<String> heis = this.hostHeis.get(hostElem);
            if (heis == null) {
                return false;
            }
            if (!heis.contains(conds.getRequiredHei())) {
                return false;
            }
        }
        return true;
    }

    private Set<String> extractFingerprintsForApiElement(Element apiElement) {
        Object object = apiElement.getUserData(INTERNAL_USERDATA_KEY);
        if (object == null || !(object instanceof InternalApiEntryAttachment)) {
            throw new RegistryClient.InvalidApiEntryElement();
        }
        InternalApiEntryAttachment meta = (InternalApiEntryAttachment)object;
        if (meta.isStale()) {
            logger.warn("Stale apiElements in use. Possible memory leaks. See: https://github.com/erasmus-without-paper/ewp-registry-client/issues/8");
            throw new RegistryClient.StaleApiEntryElement();
        }
        if (!((InternalApiEntryAttachment)meta).catalogueDocument.hostServerKeys.containsKey(meta.host)) {
            return new HashSet<String>();
        }
        return ((InternalApiEntryAttachment)meta).catalogueDocument.hostServerKeys.get(meta.host);
    }

    synchronized void extendExpiryDate(Date newExpiryDate) {
        if (newExpiryDate.after(this.expires)) {
            this.expires = new Date(newExpiryDate.getTime());
        }
    }

    Element findApi(ApiSearchConditions conditions) {
        Element bestChoice = null;
        for (Element entry : this.findApis(conditions)) {
            if (bestChoice == null) {
                bestChoice = entry;
                continue;
            }
            if (bestChoice.getAttribute("version").length() == 0) {
                bestChoice = entry;
                continue;
            }
            String currentBest = bestChoice.getAttribute("version");
            String newCandidate = entry.getAttribute("version");
            if (!CatalogueDocument.doesVersionXMatchMinimumRequiredVersionY(newCandidate, currentBest)) continue;
            bestChoice = entry;
        }
        return bestChoice;
    }

    Collection<Element> findApis(ApiSearchConditions conditions) {
        List<List<Element>> lookupBase = this.getApiLookupBase(conditions);
        ArrayList<Element> results = new ArrayList<Element>();
        for (List<Element> lst : lookupBase) {
            for (Element elem : lst) {
                if (!this.doesElementMatchConditions(elem, conditions)) continue;
                Element clone = (Element)elem.cloneNode(true);
                clone.setUserData(INTERNAL_USERDATA_KEY, new InternalApiEntryAttachment(this, (Element)elem.getParentNode().getParentNode()), null);
                results.add(clone);
            }
        }
        return results;
    }

    HeiEntry findHei(String id) {
        return this.heiEntries.get(id);
    }

    HeiEntry findHei(String type, String value) {
        String heiId = this.findHeiId(type, value);
        if (heiId == null) {
            return null;
        }
        return this.findHei(heiId);
    }

    String findHeiId(String type, String value) {
        value = CatalogueDocument.getCanonicalId(value);
        Map<String, String> mapForType = this.heiIdMaps.get(type);
        if (mapForType == null) {
            return null;
        }
        return mapForType.get(value);
    }

    Collection<HeiEntry> findHeis(ApiSearchConditions conditions) {
        List<List<Element>> lookupBase = this.getApiLookupBase(conditions);
        HashSet<Element> hostElems = new HashSet<Element>();
        for (List<Element> lst : lookupBase) {
            for (Element apiElem : lst) {
                if (!this.doesElementMatchConditions(apiElem, conditions)) continue;
                Element hostElem = (Element)apiElem.getParentNode().getParentNode();
                hostElems.add(hostElem);
            }
        }
        HashSet<HeiEntry> results = new HashSet<HeiEntry>();
        for (Element hostElem : hostElems) {
            Set<String> heiIds = this.hostHeis.get(hostElem);
            for (String heiId : heiIds) {
                HeiEntry hei = this.heiEntries.get(heiId);
                if (hei == null) continue;
                results.add(hei);
            }
        }
        return results;
    }

    RSAPublicKey findRsaPublicKey(String fingerprint) {
        return this.keyBodies.get(fingerprint);
    }

    Collection<HeiEntry> getAllHeis() {
        return Collections.unmodifiableCollection(this.heiEntries.values());
    }

    List<List<Element>> getApiLookupBase(ApiSearchConditions conditions) {
        ArrayList<List<Element>> lookupBase = new ArrayList<List<Element>>();
        if (conditions.getRequiredNamespaceUri() != null && conditions.getRequiredLocalName() != null) {
            List<Element> match = this.apiIndex.get(CatalogueDocument.getApiIndexKey(conditions.getRequiredNamespaceUri(), conditions.getRequiredLocalName()));
            if (match != null) {
                lookupBase.add(match);
            }
        } else {
            lookupBase.addAll(this.apiIndex.values());
        }
        return lookupBase;
    }

    String getETag() {
        return this.etag;
    }

    Date getExpiryDate() {
        return new Date(this.expires.getTime());
    }

    Collection<String> getHeisCoveredByCertificate(Certificate clientCert) {
        String fingerprint = Utils.extractFingerprint(clientCert);
        Set<String> heis = this.certHeis.get(fingerprint);
        if (heis == null) {
            heis = new HashSet<String>();
        }
        return Collections.unmodifiableSet(heis);
    }

    Collection<String> getHeisCoveredByClientKey(RSAPublicKey clientKey) {
        String fingerprint = Utils.extractFingerprint(clientKey);
        Set<String> heis = this.cliKeyHeis.get(fingerprint);
        if (heis == null) {
            heis = new HashSet<String>();
        }
        return Collections.unmodifiableSet(heis);
    }

    RSAPublicKey getServerKeyCoveringApi(Element apiElement) {
        for (String fingerprint : this.extractFingerprintsForApiElement(apiElement)) {
            RSAPublicKey key = this.findRsaPublicKey(fingerprint);
            if (key != null) {
                return key;
            }
            logger.warn("Catalogue contains a reference to a non-existent key " + fingerprint + ". We will ignore this reference, but this shouldn't happen and should be " + "investigated.");
        }
        return null;
    }

    Collection<RSAPublicKey> getServerKeysCoveringApi(Element apiElement) {
        ArrayList<RSAPublicKey> result = new ArrayList<RSAPublicKey>();
        for (String fingerprint : this.extractFingerprintsForApiElement(apiElement)) {
            RSAPublicKey key = this.findRsaPublicKey(fingerprint);
            if (key != null) {
                result.add(key);
                continue;
            }
            logger.warn("Catalogue contains a reference to a non-existent key " + fingerprint + ". We will ignore this reference, but this shouldn't happen and should be " + "investigated.");
        }
        return result;
    }

    boolean isCertificateKnown(Certificate clientCert) {
        String fingerprint = Utils.extractFingerprint(clientCert);
        return this.certHeis.containsKey(fingerprint);
    }

    boolean isClientKeyKnown(RSAPublicKey clientKey) {
        String fingerprint = Utils.extractFingerprint(clientKey);
        return this.cliKeyHeis.containsKey(fingerprint);
    }

    static class CatalogueParserException
    extends RegistryClient.RegistryClientException {
        CatalogueParserException(String message) {
            super(message);
        }

        CatalogueParserException(String message, Exception cause) {
            super(message, cause);
        }
    }

    private static class InternalApiEntryAttachment {
        private final CatalogueDocument catalogueDocument;
        private final Element host;
        private final long created;

        private InternalApiEntryAttachment(CatalogueDocument catalogueDocument, Element host) {
            this.catalogueDocument = catalogueDocument;
            this.host = host;
            this.created = new Date().getTime();
        }

        public boolean isStale() {
            long now = new Date().getTime();
            long diff = now - this.created;
            return diff > 60000L;
        }
    }
}

