/*
 * Decompiled with CFR 0.152.
 */
package eu.elbkind.osgi.reporting.commands;

import eu.elbkind.osgi.reporting.api.ReportFormatter;
import eu.elbkind.osgi.reporting.api.Reporting;
import eu.elbkind.osgi.reporting.commands.ColoredPrintStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Command(scope="${reporting.scope}", name="list", description="List all reports.")
public class ReportingListCommand
extends OsgiCommandSupport {
    private BundleContext bundleContext;
    private String colorOut;
    private String colorErr;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setColorOut(String colorOut) {
        this.colorOut = String.format("\u001b[%sm", colorOut);
    }

    public void setColorErr(String colorErr) {
        this.colorErr = String.format("\u001b[%sm", colorErr);
    }

    protected Object doExecute() throws Exception {
        ColoredPrintStream out = new ColoredPrintStream((OutputStream)System.out, this.colorOut);
        out.println("\nList of active reports");
        out.println("-----------------------\n");
        TreeSet<Reporting> reports = new TreeSet<Reporting>(new Comparator<Reporting>(){

            @Override
            public int compare(Reporting value, Reporting compare) {
                return value.getId().compareTo(compare.getId());
            }
        });
        Collection result = this.bundleContext.getServiceReferences(Reporting.class, null);
        for (ServiceReference reference : result) {
            Reporting monitor = (Reporting)this.bundleContext.getService(reference);
            if (monitor == null) continue;
            reports.add(monitor);
        }
        String[] headers = new String[]{"ID", "Dexcription"};
        ArrayList<String[]> rows = new ArrayList<String[]>(reports.size());
        for (Reporting reporter : reports) {
            rows.add(new String[]{reporter.getId(), reporter.getDescription()});
        }
        new ReportFormatter().format(System.out, headers, (String[][])rows.toArray((T[])new String[rows.size()][]));
        out.println();
        out.println();
        return null;
    }
}

