/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SpreadsheetDateUtil {
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int SECONDS_PER_DAY = 86400;
    private static final int BAD_DATE = -1;
    public static final long DAY_MILLISECONDS = 86400000L;
    private static final BigDecimal BD_NANOSEC_DAY = BigDecimal.valueOf(8.64E13);
    private static final BigDecimal BD_MILISEC_RND = BigDecimal.valueOf(500000.0);
    private static final BigDecimal BD_SECOND_RND = BigDecimal.valueOf(5.0E8);

    private SpreadsheetDateUtil() {
    }

    public static double getSpreadsheetDate(LocalDate date) {
        int year = date.getYear();
        int dayOfYear = date.getDayOfYear();
        int hour = 0;
        int minute = 0;
        int second = 0;
        int milliSecond = 0;
        return SpreadsheetDateUtil.internalGetSpreadsheetDate(year, dayOfYear, hour, minute, second, milliSecond);
    }

    public static double getSpreadsheetDate(LocalDateTime date) {
        int year = date.getYear();
        int dayOfYear = date.getDayOfYear();
        int hour = date.getHour();
        int minute = date.getMinute();
        int second = date.getSecond();
        int milliSecond = date.getNano() / 1000000;
        return SpreadsheetDateUtil.internalGetSpreadsheetDate(year, dayOfYear, hour, minute, second, milliSecond);
    }

    public static double getSpreadsheetDate(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        int year = calStart.get(1);
        int dayOfYear = calStart.get(6);
        int hour = calStart.get(11);
        int minute = calStart.get(12);
        int second = calStart.get(13);
        int milliSecond = calStart.get(14);
        return SpreadsheetDateUtil.internalGetSpreadsheetDate(year, dayOfYear, hour, minute, second, milliSecond);
    }

    private static double internalGetSpreadsheetDate(int year, int dayOfYear, int hour, int minute, int second, int milliSecond) {
        if (year < 1900) {
            return -1.0;
        }
        double fraction = ((((double)hour * 60.0 + (double)minute) * 60.0 + (double)second) * 1000.0 + (double)milliSecond) / 8.64E7;
        double value = fraction + (double)SpreadsheetDateUtil.absoluteDay(year, dayOfYear);
        if (value >= 60.0) {
            value += 1.0;
        }
        return value;
    }

    public static Date getJavaDate(double date, TimeZone tz) {
        return SpreadsheetDateUtil.getJavaDate(date, tz, false);
    }

    public static Date getJavaDate(double date) {
        return SpreadsheetDateUtil.getJavaDate(date, null, false);
    }

    public static Date getJavaDate(double date, TimeZone tz, boolean roundSeconds) {
        Calendar calendar = SpreadsheetDateUtil.getJavaCalendar(date, tz, roundSeconds);
        return calendar == null ? null : calendar.getTime();
    }

    public static LocalDateTime getLocalDateTime(double date) {
        return SpreadsheetDateUtil.getLocalDateTime(date, false);
    }

    public static LocalDateTime getLocalDateTime(double date, boolean roundSeconds) {
        if (!SpreadsheetDateUtil.isValidSpreadsheetDate(date)) {
            return null;
        }
        BigDecimal bd = BigDecimal.valueOf(date);
        int wholeDays = bd.intValue();
        int startYear = 1900;
        int dayAdjust = -1;
        if (wholeDays < 61) {
            dayAdjust = 0;
        }
        LocalDateTime ldt = LocalDateTime.of(startYear, 1, 1, 0, 0);
        ldt = ldt.plusDays((long)(wholeDays + dayAdjust) - 1L);
        long nanosTime = bd.subtract(BigDecimal.valueOf(wholeDays)).multiply(BD_NANOSEC_DAY).add(roundSeconds ? BD_SECOND_RND : BD_MILISEC_RND).longValue();
        ldt = ldt.plusNanos(nanosTime);
        ldt = ldt.truncatedTo(roundSeconds ? ChronoUnit.SECONDS : ChronoUnit.MILLIS);
        return ldt;
    }

    public static Calendar getJavaCalendar(double date, TimeZone timeZone, boolean roundSeconds) {
        if (!SpreadsheetDateUtil.isValidSpreadsheetDate(date)) {
            return null;
        }
        int wholeDays = (int)Math.floor(date);
        int millisecondsInDay = (int)((date - (double)wholeDays) * 8.64E7 + 0.5);
        Calendar calendar = timeZone != null ? Calendar.getInstance(timeZone) : Calendar.getInstance();
        SpreadsheetDateUtil.setCalendar(calendar, wholeDays, millisecondsInDay, roundSeconds);
        return calendar;
    }

    public static void setCalendar(Calendar calendar, int wholeDays, int millisecondsInDay, boolean roundSeconds) {
        int startYear = 1900;
        int dayAdjust = -1;
        if (wholeDays < 61) {
            dayAdjust = 0;
        }
        calendar.set(startYear, 0, wholeDays + dayAdjust, 0, 0, 0);
        calendar.set(14, millisecondsInDay);
        if (calendar.get(14) == 0) {
            calendar.clear(14);
        }
        if (roundSeconds) {
            calendar.add(14, 500);
            calendar.clear(14);
        }
    }

    public static boolean isValidSpreadsheetDate(double value) {
        return value > -4.9E-324;
    }

    private static int absoluteDay(int year, int dayOfYear) {
        return dayOfYear + SpreadsheetDateUtil.daysInPriorYears(year);
    }

    static int daysInPriorYears(int yr) {
        if (yr < 1900) {
            throw new IllegalArgumentException("'year' must be 1900 or greater");
        }
        int yr1 = yr - 1;
        int leapDays = yr1 / 4 - yr1 / 100 + yr1 / 400 - 460;
        return 365 * (yr - 1900) + leapDays;
    }
}

