/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets.internal;

import com.google.api.services.sheets.v4.model.AddSheetRequest;
import com.google.api.services.sheets.v4.model.AppendDimensionRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse;
import com.google.api.services.sheets.v4.model.CellData;
import com.google.api.services.sheets.v4.model.DeleteDimensionRequest;
import com.google.api.services.sheets.v4.model.DeleteRangeRequest;
import com.google.api.services.sheets.v4.model.DeleteSheetRequest;
import com.google.api.services.sheets.v4.model.DimensionProperties;
import com.google.api.services.sheets.v4.model.DimensionRange;
import com.google.api.services.sheets.v4.model.DuplicateSheetRequest;
import com.google.api.services.sheets.v4.model.GridRange;
import com.google.api.services.sheets.v4.model.InsertDimensionRequest;
import com.google.api.services.sheets.v4.model.MergeCellsRequest;
import com.google.api.services.sheets.v4.model.MoveDimensionRequest;
import com.google.api.services.sheets.v4.model.RepeatCellRequest;
import com.google.api.services.sheets.v4.model.Request;
import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.UnmergeCellsRequest;
import com.google.api.services.sheets.v4.model.UpdateDimensionPropertiesRequest;
import com.google.api.services.sheets.v4.model.UpdateSheetPropertiesRequest;
import com.google.api.services.sheets.v4.model.UpdateSpreadsheetPropertiesRequest;
import eu.easyrpa.openframework.google.sheets.SpreadsheetDocument;
import eu.easyrpa.openframework.google.sheets.exceptions.SpreadsheetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpreadsheetUpdateRequestsBatch {
    private static final int MAX_REQUESTS_IN_BATCH_COUNT = 100000;
    private List<Request> requests = new ArrayList<Request>();
    private SpreadsheetDocument document;

    public SpreadsheetUpdateRequestsBatch(SpreadsheetDocument document) {
        this.document = document;
    }

    public void addUpdateSpreadsheetPropertiesRequest(Spreadsheet spreadsheet, String ... propertyNames) {
        this.requests.add(new Request().setUpdateSpreadsheetProperties(new UpdateSpreadsheetPropertiesRequest().setProperties(spreadsheet.getProperties()).setFields(String.join((CharSequence)",", propertyNames))));
    }

    public void addNewSheetRequest(Sheet newSheet) {
        this.requests.add(new Request().setAddSheet(new AddSheetRequest().setProperties(newSheet.getProperties())));
    }

    public void addDeleteSheetRequest(int sheetId) {
        this.requests.add(new Request().setDeleteSheet(new DeleteSheetRequest().setSheetId(Integer.valueOf(sheetId))));
    }

    public void addDuplicateSheetRequest(Sheet sourceSheet, int newSheetIndex, String newSheetName) {
        this.requests.add(new Request().setDuplicateSheet(new DuplicateSheetRequest().setSourceSheetId(sourceSheet.getProperties().getSheetId()).setInsertSheetIndex(Integer.valueOf(newSheetIndex)).setNewSheetName(newSheetName)));
    }

    public void addUpdateSheetPropertiesRequest(Sheet sheet, String ... propertyNames) {
        this.requests.add(new Request().setUpdateSheetProperties(new UpdateSheetPropertiesRequest().setProperties(sheet.getProperties()).setFields(String.join((CharSequence)",", propertyNames))));
    }

    public void addMergeCellsRequest(GridRange range) {
        this.requests.add(new Request().setMergeCells(new MergeCellsRequest().setMergeType("MERGE_ALL").setRange(range)));
    }

    public void addUnmergeCellsRequest(GridRange range) {
        this.requests.add(new Request().setUnmergeCells(new UnmergeCellsRequest().setRange(range)));
    }

    public void addAppendRowsRequest(int rowsCount, int sheetId) {
        this.requests.add(new Request().setAppendDimension(new AppendDimensionRequest().setDimension("ROWS").setLength(Integer.valueOf(rowsCount)).setSheetId(Integer.valueOf(sheetId))));
    }

    public void addInsertRowsRequest(int startRow, int rowsCount, int sheetId) {
        DimensionRange range = new DimensionRange();
        range.setDimension("ROWS");
        range.setSheetId(Integer.valueOf(sheetId));
        range.setStartIndex(Integer.valueOf(startRow));
        range.setEndIndex(Integer.valueOf(startRow + rowsCount));
        this.requests.add(new Request().setInsertDimension(new InsertDimensionRequest().setRange(range).setInheritFromBefore(Boolean.valueOf(true))));
    }

    public void addDeleteRowsRequest(int startRow, int rowsCount, int sheetId) {
        DimensionRange range = new DimensionRange();
        range.setDimension("ROWS");
        range.setSheetId(Integer.valueOf(sheetId));
        range.setStartIndex(Integer.valueOf(startRow));
        range.setEndIndex(Integer.valueOf(startRow + rowsCount));
        this.requests.add(new Request().setDeleteDimension(new DeleteDimensionRequest().setRange(range)));
    }

    public void addCleanRowRequest(int rowIndex, int sheetId) {
        GridRange range = new GridRange();
        range.setSheetId(Integer.valueOf(sheetId));
        range.setStartRowIndex(Integer.valueOf(rowIndex));
        range.setEndRowIndex(Integer.valueOf(rowIndex + 1));
        this.requests.add(new Request().setDeleteRange(new DeleteRangeRequest().setRange(range).setShiftDimension("COLUMNS")));
    }

    public void addAppendColumnsRequest(int columnsCount, int sheetId) {
        this.requests.add(new Request().setAppendDimension(new AppendDimensionRequest().setDimension("COLUMNS").setLength(Integer.valueOf(columnsCount)).setSheetId(Integer.valueOf(sheetId))));
    }

    public void addInsertColumnsRequest(int startCol, int columnsCount, int sheetId) {
        DimensionRange range = new DimensionRange();
        range.setDimension("COLUMNS");
        range.setSheetId(Integer.valueOf(sheetId));
        range.setStartIndex(Integer.valueOf(startCol));
        range.setEndIndex(Integer.valueOf(startCol + columnsCount));
        this.requests.add(new Request().setInsertDimension(new InsertDimensionRequest().setRange(range).setInheritFromBefore(Boolean.valueOf(true))));
    }

    public void addDeleteColumnsRequest(int startCol, int columnsCount, int sheetId) {
        DimensionRange range = new DimensionRange();
        range.setDimension("COLUMNS");
        range.setSheetId(Integer.valueOf(sheetId));
        range.setStartIndex(Integer.valueOf(startCol));
        range.setEndIndex(Integer.valueOf(startCol + columnsCount));
        this.requests.add(new Request().setDeleteDimension(new DeleteDimensionRequest().setRange(range)));
    }

    public void addMoveColumnsRequest(int fromColIndex, int toColIndex, int columnsCount, int sheetId) {
        DimensionRange range = new DimensionRange();
        range.setDimension("COLUMNS");
        range.setSheetId(Integer.valueOf(sheetId));
        range.setStartIndex(Integer.valueOf(fromColIndex));
        range.setEndIndex(Integer.valueOf(fromColIndex + columnsCount));
        this.requests.add(new Request().setMoveDimension(new MoveDimensionRequest().setSource(range).setDestinationIndex(Integer.valueOf(toColIndex))));
    }

    public void addCleanColumnRequest(int colIndex, int sheetId) {
        GridRange range = new GridRange();
        range.setSheetId(Integer.valueOf(sheetId));
        range.setStartColumnIndex(Integer.valueOf(colIndex));
        range.setEndColumnIndex(Integer.valueOf(colIndex + 1));
        this.requests.add(new Request().setDeleteRange(new DeleteRangeRequest().setRange(range).setShiftDimension("ROWS")));
    }

    public void addUpdateColumnMetadataRequest(int colIndex, DimensionProperties metadata, int sheetId) {
        DimensionRange range = new DimensionRange();
        range.setDimension("COLUMNS");
        range.setSheetId(Integer.valueOf(sheetId));
        range.setStartIndex(Integer.valueOf(colIndex));
        range.setEndIndex(Integer.valueOf(colIndex + 1));
        this.requests.add(new Request().setUpdateDimensionProperties(new UpdateDimensionPropertiesRequest().setRange(range).setProperties(metadata).setFields("*")));
    }

    public void addUpdateCellRequest(CellData cellData, int rowIndex, int colIndex, int sheetId, String ... propertyNames) {
        this.addUpdateCellRequest(cellData, rowIndex, colIndex, sheetId, Arrays.asList(propertyNames));
    }

    public void addUpdateCellRequest(CellData cellData, int rowIndex, int colIndex, int sheetId, List<String> propertyNames) {
        this.requests.add(new Request().setRepeatCell(new RepeatCellRequest().setRange(new GridRange().setSheetId(Integer.valueOf(sheetId)).setStartRowIndex(Integer.valueOf(rowIndex)).setEndRowIndex(Integer.valueOf(rowIndex + 1)).setStartColumnIndex(Integer.valueOf(colIndex)).setEndColumnIndex(Integer.valueOf(colIndex + 1))).setCell(cellData).setFields(String.join((CharSequence)",", propertyNames))));
    }

    public List<BatchUpdateSpreadsheetResponse> send() {
        ArrayList<BatchUpdateSpreadsheetResponse> responses = new ArrayList<BatchUpdateSpreadsheetResponse>();
        if (this.requests.size() > 0) {
            try {
                List<Request> batch;
                for (int i = 0; i < this.requests.size() && (batch = this.requests.subList(i, i + Math.min(this.requests.size() - i, 100000))).size() > 0; i += batch.size()) {
                    BatchUpdateSpreadsheetRequest body = new BatchUpdateSpreadsheetRequest().setRequests(batch);
                    responses.add((BatchUpdateSpreadsheetResponse)this.document.getSheetsService().spreadsheets().batchUpdate(this.document.getId(), body).execute());
                }
            }
            catch (Exception e) {
                throw new SpreadsheetException("Batch update of spreadsheet has failed.", e);
            }
            finally {
                this.requests.clear();
                this.requests = null;
                this.document = null;
            }
        }
        return responses;
    }
}

