/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets.internal;

import eu.easyrpa.openframework.core.utils.TypeUtils;
import eu.easyrpa.openframework.google.sheets.Cell;
import eu.easyrpa.openframework.google.sheets.CellStyle;
import eu.easyrpa.openframework.google.sheets.annotations.GSheetCellStyle;
import eu.easyrpa.openframework.google.sheets.annotations.GSheetColumn;
import eu.easyrpa.openframework.google.sheets.annotations.GSheetTable;
import eu.easyrpa.openframework.google.sheets.constants.Colors;
import eu.easyrpa.openframework.google.sheets.constants.FontFamily;
import eu.easyrpa.openframework.google.sheets.constants.HorizontalAlignment;
import eu.easyrpa.openframework.google.sheets.constants.NumberFormats;
import eu.easyrpa.openframework.google.sheets.constants.VerticalAlignment;
import eu.easyrpa.openframework.google.sheets.constants.WrapStrategy;
import eu.easyrpa.openframework.google.sheets.function.ColumnFormatter;
import eu.easyrpa.openframework.google.sheets.function.FieldMapper;
import eu.easyrpa.openframework.google.sheets.function.TableFormatter;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RecordTypeHelper<T> {
    public static final String NAME_LEVEL_DELIMITER = "&&";
    private Class<T> recordType = null;
    private CellStyle tableHeaderCellStyle = null;
    private CellStyle tableCellStyle = null;
    private TableFormatter<T> tableFormatter = null;
    private List<String> fields = new ArrayList<String>();
    private Map<String, String> fieldToColumnMap = new HashMap<String, String>();
    private Map<String, Integer> columnNameToOrderMap = new HashMap<String, Integer>();
    private Map<Integer, String> columnOrderToFieldMap = new HashMap<Integer, String>();
    private ColumnNamesTree columnNamesTree = new ColumnNamesTree();
    private Map<Integer, Integer> columnWidthMap = new HashMap<Integer, Integer>();
    private Map<Integer, CellStyle> columnHeaderCellStyleMap = new HashMap<Integer, CellStyle>();
    private Map<Integer, CellStyle> columnCellStyleMap = new HashMap<Integer, CellStyle>();
    private Map<Integer, ColumnFormatter<T>> columnFormatterMap = new HashMap<Integer, ColumnFormatter<T>>();
    private Map<String, FieldMapper> fieldMapperMap = new HashMap<String, FieldMapper>();
    private static final Map<String, RecordTypeHelper<?>> HELPERS_CACHE = new HashMap();

    private RecordTypeHelper() {
    }

    public ColumnNamesTree getColumnNames() {
        return this.columnNamesTree;
    }

    public T mapToRecord(List<Object> values, Map<String, Integer> columnNameToValueIndexMap) {
        try {
            if (values == null) {
                return null;
            }
            if (columnNameToValueIndexMap == null) {
                columnNameToValueIndexMap = this.columnNameToOrderMap;
            }
            T record = this.recordType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (String fieldName : this.fields) {
                String columnName = this.fieldToColumnMap.get(fieldName);
                Integer valueIndex = columnName != null ? columnNameToValueIndexMap.get(columnName) : null;
                Object value = null;
                FieldMapper mapper = this.fieldMapperMap.get(fieldName);
                if (mapper != null) {
                    value = mapper.map(fieldName, values, valueIndex != null ? valueIndex : -1);
                } else if (valueIndex != null && valueIndex >= 0 && valueIndex < values.size()) {
                    value = values.get(valueIndex);
                }
                if (value == null) continue;
                TypeUtils.setFieldValue(record, (String)fieldName, (Object)value);
            }
            return record;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object> mapToValues(T record, Map<String, Integer> columnNameToValueIndexMap) {
        try {
            if (record == null) {
                return null;
            }
            if (columnNameToValueIndexMap == null) {
                columnNameToValueIndexMap = this.columnNameToOrderMap;
            }
            int valuesCount = columnNameToValueIndexMap.values().stream().max(Comparator.comparingInt(v -> v)).orElse(-1) + 1;
            ArrayList<Object> values = new ArrayList<Object>(Collections.nCopies(valuesCount, null));
            for (String columnName : columnNameToValueIndexMap.keySet()) {
                String fieldName;
                Integer columnOrder;
                Integer valueIndex = columnNameToValueIndexMap.get(columnName);
                if (valueIndex == null || valueIndex < 0 || (columnOrder = this.columnNameToOrderMap.get(columnName)) == null || (fieldName = this.columnOrderToFieldMap.get(columnOrder)) == null) continue;
                values.set(valueIndex, TypeUtils.getFieldValue(record, (String)fieldName));
            }
            return values;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void formatCell(Cell cell, String columnName, int recordIndex, List<T> records) {
        if (cell != null && columnName != null && !columnName.trim().isEmpty()) {
            ColumnFormatter<Object> formatter;
            Integer columnOrder = this.columnNameToOrderMap.get(columnName);
            if (columnOrder == null) {
                return;
            }
            CellStyle cellStyle = this.columnCellStyleMap.get(columnOrder);
            if (cellStyle != null) {
                cell.setStyle(cellStyle);
            } else if (this.tableCellStyle != null) {
                cell.setStyle(this.tableCellStyle);
            }
            if (this.tableFormatter != null) {
                this.tableFormatter.format(cell, columnName, recordIndex, records);
            }
            if ((formatter = this.columnFormatterMap.get(columnOrder)) != null) {
                Object record = records != null && recordIndex >= 0 && recordIndex < records.size() ? (Object)records.get(recordIndex) : null;
                formatter.format(cell, columnName, record);
            }
        }
    }

    public void formatHeaderCell(Cell cell, String columnName) {
        if (cell != null && columnName != null && !columnName.trim().isEmpty()) {
            ColumnFormatter<Object> formatter;
            CellStyle headerCellStyle;
            Integer columnOrder = this.columnNameToOrderMap.get(columnName);
            if (columnOrder == null) {
                if (this.tableHeaderCellStyle != null) {
                    cell.setStyle(this.tableHeaderCellStyle);
                }
                if (this.tableFormatter != null) {
                    this.tableFormatter.format(cell, columnName, -1, null);
                }
                return;
            }
            Integer width = this.columnWidthMap.get(columnOrder);
            if (width != null) {
                cell.getSheet().setColumnWidth(cell.getColumnIndex(), (int)width);
            }
            if ((headerCellStyle = this.columnHeaderCellStyleMap.get(columnOrder)) != null) {
                cell.setStyle(headerCellStyle);
            } else if (this.tableHeaderCellStyle != null) {
                cell.setStyle(this.tableHeaderCellStyle);
            }
            if (this.tableFormatter != null) {
                this.tableFormatter.format(cell, columnName, -1, null);
            }
            if ((formatter = this.columnFormatterMap.get(columnOrder)) != null) {
                formatter.format(cell, columnName, null);
            }
        }
    }

    public static <T> RecordTypeHelper<T> getFor(T record) {
        return RecordTypeHelper.getFor(record.getClass());
    }

    public static <T> RecordTypeHelper<T> getFor(Class<T> recordType) {
        RecordTypeHelper<Object> typeInfo = HELPERS_CACHE.get(recordType.getName());
        if (typeInfo != null) {
            return typeInfo;
        }
        try {
            typeInfo = new RecordTypeHelper<T>();
            typeInfo.recordType = recordType;
            GSheetTable tableAnnotation = recordType.getAnnotation(GSheetTable.class);
            if (tableAnnotation != null) {
                Class<? extends TableFormatter> formatterClass;
                GSheetCellStyle[] styleAnnotations = tableAnnotation.cellStyle();
                if (styleAnnotations.length > 0) {
                    typeInfo.tableCellStyle = RecordTypeHelper.getStyleForAnnotation(styleAnnotations[0]);
                }
                if ((styleAnnotations = tableAnnotation.headerStyle()).length > 0) {
                    typeInfo.tableHeaderCellStyle = RecordTypeHelper.getStyleForAnnotation(styleAnnotations[0]);
                }
                if ((formatterClass = tableAnnotation.formatter()) != TableFormatter.class) {
                    typeInfo.tableFormatter = formatterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            int index = 0;
            for (Field field : recordType.getDeclaredFields()) {
                Class<? extends FieldMapper> mapperClass;
                Class<? extends ColumnFormatter> formatterClass;
                GSheetCellStyle[] styleAnnotations;
                int width;
                GSheetColumn columnAnnotation = field.getAnnotation(GSheetColumn.class);
                if (columnAnnotation == null) continue;
                int order = columnAnnotation.order();
                CharSequence[] nameHierarchy = columnAnnotation.name();
                String fieldName = field.getName();
                int columnOrder = order > 0 ? order : index++;
                String columnName = fieldName;
                if (nameHierarchy.length > 0) {
                    for (int i = 0; i < nameHierarchy.length; ++i) {
                        nameHierarchy[i] = ((String)nameHierarchy[i]).trim();
                    }
                    columnName = String.join((CharSequence)NAME_LEVEL_DELIMITER, nameHierarchy);
                }
                typeInfo.columnNamesTree.add(columnName);
                typeInfo.fields.add(fieldName);
                if (columnName != null) {
                    typeInfo.fieldToColumnMap.put(fieldName, columnName);
                    typeInfo.columnNameToOrderMap.put(columnName, columnOrder);
                    typeInfo.columnOrderToFieldMap.put(columnOrder, fieldName);
                }
                if ((width = columnAnnotation.width()) >= 0) {
                    typeInfo.columnWidthMap.put(columnOrder, width);
                }
                if ((styleAnnotations = columnAnnotation.cellStyle()).length > 0) {
                    typeInfo.columnCellStyleMap.put(columnOrder, RecordTypeHelper.getStyleForAnnotation(styleAnnotations[0]));
                }
                if ((styleAnnotations = columnAnnotation.headerStyle()).length > 0) {
                    typeInfo.columnHeaderCellStyleMap.put(columnOrder, RecordTypeHelper.getStyleForAnnotation(styleAnnotations[0]));
                }
                if ((formatterClass = columnAnnotation.formatter()) != ColumnFormatter.class) {
                    typeInfo.columnFormatterMap.put(columnOrder, formatterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                if ((mapperClass = columnAnnotation.mapper()) == FieldMapper.class) continue;
                typeInfo.fieldMapperMap.put(fieldName, mapperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            HELPERS_CACHE.put(recordType.getName(), typeInfo);
            return typeInfo;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static CellStyle getStyleForAnnotation(GSheetCellStyle styleAnnotation) {
        CellStyle style = new CellStyle();
        if (styleAnnotation.font() != FontFamily.UNSPECIFIED) {
            style.font(styleAnnotation.font());
        }
        if (styleAnnotation.fontSize() > 0) {
            style.fontSize(styleAnnotation.fontSize());
        }
        style.bold(styleAnnotation.bold());
        style.italic(styleAnnotation.italic());
        style.strikeout(styleAnnotation.strikeout());
        style.underline(styleAnnotation.underline());
        if (styleAnnotation.color() != Colors.UNSPECIFIED) {
            style.color(styleAnnotation.color().get());
        }
        if (styleAnnotation.numberFormat() != NumberFormats.UNSPECIFIED) {
            style.format(styleAnnotation.numberFormat());
        }
        if (styleAnnotation.numberPattern().length() > 0) {
            style.format(styleAnnotation.numberPattern());
        }
        if (styleAnnotation.background() != Colors.UNSPECIFIED) {
            style.background(styleAnnotation.background().get());
        }
        if (styleAnnotation.hAlign() != HorizontalAlignment.UNSPECIFIED) {
            style.hAlign(styleAnnotation.hAlign());
        }
        if (styleAnnotation.vAlign() != VerticalAlignment.UNSPECIFIED) {
            style.vAlign(styleAnnotation.vAlign());
        }
        if (styleAnnotation.wrapStrategy() != WrapStrategy.UNSPECIFIED) {
            style.wrapStrategy(styleAnnotation.wrapStrategy());
        }
        if (styleAnnotation.rotation() > 0) {
            style.rotation(styleAnnotation.rotation());
        }
        style.vertical(styleAnnotation.vertical());
        if (styleAnnotation.border().length > 0) {
            style.borders(styleAnnotation.border());
        }
        if (styleAnnotation.borderColor().length > 0) {
            style.borderColors(Arrays.stream(styleAnnotation.borderColor()).map(c -> c != Colors.UNSPECIFIED ? c.get() : null).collect(Collectors.toList()).toArray(new Color[0]));
        }
        if (styleAnnotation.padding().length > 0) {
            style.padding(styleAnnotation.padding());
        }
        return style;
    }

    public static class ColumnNameNode {
        private ColumnNameNode root;
        private String name;
        private String fullName;
        private int level;
        private int maxLevel;
        private int columnIndex = 0;
        private int width = 1;
        private int height = 1;
        private List<ColumnNameNode> children = new ArrayList<ColumnNameNode>();

        protected ColumnNameNode(ColumnNameNode root, String[] nameHierarchy, int level) {
            this.root = root;
            if (nameHierarchy != null) {
                this.name = nameHierarchy[level];
                this.fullName = String.join((CharSequence)RecordTypeHelper.NAME_LEVEL_DELIMITER, Arrays.copyOfRange(nameHierarchy, 0, level + 1));
            }
            this.level = this.maxLevel = level;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.fullName;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColumnNameNode)) {
                return false;
            }
            ColumnNameNode that = (ColumnNameNode)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        protected void add(String[] nameHierarchy, int level) {
            if (level < nameHierarchy.length) {
                ColumnNameNode columnNameNode = new ColumnNameNode(this.root != null ? this.root : this, nameHierarchy, level);
                int index = this.children.indexOf(columnNameNode);
                if (index >= 0) {
                    columnNameNode = this.children.get(index);
                } else {
                    this.children.add(columnNameNode);
                }
                columnNameNode.add(nameHierarchy, level + 1);
                this.maxLevel = Math.max(this.maxLevel, nameHierarchy.length - 1);
            }
        }

        protected void adjustSize() {
            int oldHeight = this.height;
            this.width = this.calculateWidth();
            this.height = this.root == null ? (oldHeight = this.maxLevel + 1) : (int)Math.ceil((double)(this.root.maxLevel - this.maxLevel) / (double)(this.maxLevel - this.level + 1)) + 1;
            for (ColumnNameNode child : this.children) {
                if (this.height != oldHeight) {
                    child.shiftLevel(this.height - oldHeight);
                }
                child.adjustSize();
            }
        }

        protected void adjustPosition() {
            int index = this.columnIndex;
            for (ColumnNameNode child : this.children) {
                child.columnIndex = index;
                index += child.width;
                child.adjustPosition();
            }
        }

        protected void collectByLevel(List<ColumnNameNode> nodes, int level) {
            if (this.level == level) {
                nodes.add(this);
            } else {
                for (ColumnNameNode child : this.children) {
                    child.collectByLevel(nodes, level);
                }
            }
        }

        private void shiftLevel(int n) {
            this.level += n;
            this.maxLevel += n;
            for (ColumnNameNode child : this.children) {
                child.shiftLevel(n);
            }
        }

        private int calculateWidth() {
            if (this.children.isEmpty()) {
                return 1;
            }
            int width = 0;
            for (ColumnNameNode child : this.children) {
                width += child.calculateWidth();
            }
            return width;
        }
    }

    public static class ColumnNamesTree
    extends ColumnNameNode {
        public ColumnNamesTree() {
            super(null, null, -1);
        }

        public List<ColumnNameNode> getForLevel(int level) {
            ArrayList<ColumnNameNode> nodes = new ArrayList<ColumnNameNode>();
            this.collectByLevel(nodes, level);
            return nodes;
        }

        protected void add(String name) {
            if (name != null) {
                String[] nameHierarchy = name.split(RecordTypeHelper.NAME_LEVEL_DELIMITER);
                this.add(nameHierarchy, 0);
                this.adjustSize();
                this.adjustPosition();
            }
        }
    }
}

