/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import eu.easyrpa.openframework.google.sheets.Cell;
import eu.easyrpa.openframework.google.sheets.Row;
import eu.easyrpa.openframework.google.sheets.Sheet;
import eu.easyrpa.openframework.google.sheets.constants.InsertMethod;
import eu.easyrpa.openframework.google.sheets.internal.RecordTypeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Table<T>
implements Iterable<T> {
    private Sheet parent;
    private int hTopRow;
    private int hLeftCol;
    private int hBottomRow;
    private int hRightCol;
    private int bottomRow = -1;
    private Map<String, Integer> columnNameToIndexMap;
    private List<T> records;
    private RecordTypeHelper<T> typeHelper;

    protected Table(Sheet parent, int topRow, int leftCol, List<T> records) {
        this.parent = parent;
        if (records != null && records.size() > 0) {
            this.typeHelper = RecordTypeHelper.getFor(records.get(0).getClass());
            this.buildTable(topRow, leftCol, records);
        } else {
            this.hTopRow = topRow;
            this.hLeftCol = leftCol;
            this.hBottomRow = topRow;
            this.hRightCol = parent.getLastColumnIndex();
        }
    }

    protected Table(Sheet parent, int headerTopRow, int headerLeftCol, int headerBottomRow, int headerRightCol, Class<T> recordType) {
        this.parent = parent;
        this.hTopRow = headerTopRow;
        this.hLeftCol = headerLeftCol;
        this.hBottomRow = headerBottomRow;
        this.hRightCol = headerRightCol;
        this.typeHelper = RecordTypeHelper.getFor(recordType);
    }

    public Sheet getSheet() {
        return this.parent;
    }

    public int getHeaderTopRow() {
        return this.hTopRow;
    }

    public void setHeaderTopRow(int topRowIndex) {
        this.hTopRow = topRowIndex;
        this.columnNameToIndexMap = null;
    }

    public int getHeaderLeftCol() {
        return this.hLeftCol;
    }

    public void setHeaderLeftCol(int leftColIndex) {
        this.hLeftCol = leftColIndex;
        this.columnNameToIndexMap = null;
    }

    public int getHeaderBottomRow() {
        return this.hBottomRow;
    }

    public void setHeaderBottomRow(int bottomRowIndex) {
        this.hBottomRow = bottomRowIndex;
        this.columnNameToIndexMap = null;
    }

    public int getHeaderRightCol() {
        return this.hRightCol;
    }

    public void setHeaderRightCol(int rightColIndex) {
        this.hRightCol = rightColIndex;
        this.columnNameToIndexMap = null;
    }

    public int getBottomRow() {
        if (this.bottomRow < 0) {
            return this.parent.getLastRowIndex();
        }
        return this.bottomRow;
    }

    public void setBottomRow(int bottomRowIndex) {
        this.bottomRow = bottomRowIndex;
    }

    public Map<String, Integer> getColumnNameToIndexMap() {
        if (this.columnNameToIndexMap == null) {
            this.columnNameToIndexMap = this.getColumnNameToIndexMap(this.hTopRow, this.hLeftCol, this.hBottomRow, this.hRightCol);
        }
        return this.columnNameToIndexMap;
    }

    public List<T> getRecords() {
        if (this.records == null) {
            Map<String, Integer> columnsIndexMap = this.getColumnNameToIndexMap();
            if (columnsIndexMap != null) {
                List<List<Object>> data = this.parent.getRange(this.hBottomRow + 1, this.hLeftCol, this.getBottomRow(), this.hRightCol);
                this.records = data.stream().map(values -> this.typeHelper.mapToRecord((List<Object>)values, columnsIndexMap)).collect(Collectors.toList());
            }
        } else {
            for (int i = 0; i < this.records.size(); ++i) {
                if (this.records.get(i) != null) continue;
                this.getRecord(i);
            }
        }
        return new ArrayList<T>(this.records);
    }

    public T getRecord(int index) {
        T record;
        int recordsCount = this.getRecordsCount();
        if (index < 0 || index >= recordsCount) {
            return null;
        }
        if (this.records == null) {
            this.records = new ArrayList<Object>(Collections.nCopies(recordsCount, null));
        }
        if ((record = this.records.get(index)) == null) {
            Row row = this.parent.getRow(index + this.hBottomRow + 1);
            List<Object> values = row.getRange(this.hLeftCol, this.hRightCol);
            record = this.typeHelper.mapToRecord(values, this.getColumnNameToIndexMap());
            this.records.set(index, record);
        }
        return record;
    }

    public T findRecord(Predicate<T> isSatisfy) {
        int index = this.findRecordIndex(isSatisfy);
        return index >= 0 ? (T)this.records.get(index) : null;
    }

    public int findRecordIndex(Predicate<T> isSatisfy) {
        if (isSatisfy != null) {
            int recordsCount = this.getRecordsCount();
            for (int i = 0; i < recordsCount; ++i) {
                T record = this.getRecord(i);
                if (!isSatisfy.test(record)) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(T record) {
        return record != null ? this.findRecordIndex(record::equals) : -1;
    }

    public int getRecordsCount() {
        return this.getBottomRow() - this.hBottomRow;
    }

    public void addRecord(T record) {
        this.insertRecord(InsertMethod.BEFORE, this.getRecordsCount(), record);
    }

    public void addRecords(List<T> records) {
        this.insertRecords(InsertMethod.BEFORE, this.getRecordsCount(), records);
    }

    public void insertRecord(InsertMethod method, T relatedRecord, T record) {
        this.insertRecords(method, this.indexOf(relatedRecord), Collections.singletonList(record));
    }

    public void insertRecord(InsertMethod method, int recordIndex, T record) {
        this.insertRecords(method, recordIndex, Collections.singletonList(record));
    }

    public void insertRecords(InsertMethod method, T relatedRecord, List<T> records) {
        this.insertRecords(method, this.indexOf(relatedRecord), records);
    }

    public void insertRecords(InsertMethod method, int recordIndex, List<T> records) {
        if (recordIndex < 0 || records == null || records.isEmpty()) {
            return;
        }
        this.parent.getDocument().batchUpdate(request -> {
            int startRow;
            int insertPos;
            Map<String, Integer> columnsIndexMap = this.getColumnNameToIndexMap();
            Map<Integer, String> columnNamesMap = columnsIndexMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            List data = records.stream().map(r -> this.typeHelper.mapToValues(r, columnsIndexMap)).collect(Collectors.toList());
            this.parent.insertRows(method, recordIndex + this.hBottomRow + 1, this.hLeftCol, data);
            int n = insertPos = method == null || method == InsertMethod.BEFORE ? recordIndex : recordIndex + 1;
            if (this.records == null) {
                this.records = new ArrayList<Object>(Collections.nCopies(this.getRecordsCount(), null));
            }
            int i = insertPos;
            for (int j = 0; j < records.size(); ++j) {
                this.records.set(i, records.get(j));
                ++i;
            }
            if (this.bottomRow >= 0) {
                this.bottomRow += records.size();
            }
            int rowsCount = data.size();
            for (int i2 = startRow = insertPos + this.hBottomRow + 1; i2 < rowsCount + startRow; ++i2) {
                for (int j = this.hLeftCol; j <= this.hRightCol; ++j) {
                    this.typeHelper.formatCell(this.parent.getCell(i2, j), columnNamesMap.get(j - this.hLeftCol), i2 - this.hBottomRow - 1, this.records);
                }
            }
        });
    }

    public void updateRecord(T record) {
        this.updateRecords(Collections.singletonList(record));
    }

    public void updateRecords(List<T> records) {
        if (records == null) {
            return;
        }
        Map<String, Integer> columnsIndexMap = this.getColumnNameToIndexMap();
        Map<Integer, String> columnNamesMap = columnsIndexMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.parent.getDocument().batchUpdate(request -> {
            for (Object record : records) {
                int index = this.indexOf(record);
                if (index < 0) continue;
                int rowNum = index + this.hBottomRow + 1;
                List<Object> values = this.typeHelper.mapToValues(record, columnsIndexMap);
                this.parent.putRange(rowNum, this.hLeftCol, values);
                for (int j = this.hLeftCol; j <= this.hRightCol; ++j) {
                    this.typeHelper.formatCell(this.parent.getCell(rowNum, j), (String)columnNamesMap.get(j - this.hLeftCol), index, this.records);
                }
                this.records.set(index, record);
            }
        });
    }

    public void removeRecord(T record) {
        int index;
        if (record != null && (index = this.indexOf(record)) >= 0) {
            this.parent.removeRow(index + this.hBottomRow + 1);
            this.records.remove(index);
            if (this.bottomRow >= 0) {
                --this.bottomRow;
            }
        }
    }

    public void removeRecords(List<T> records) {
        if (records != null) {
            for (T record : records) {
                this.removeRecord(record);
            }
        }
    }

    public void clearCache() {
        this.records = null;
    }

    public void trimLeadingAndTrailingSpaces() {
        while (this.parent.getColumn(this.getHeaderLeftCol()).isEmpty()) {
            this.setHeaderLeftCol(this.getHeaderLeftCol() + 1);
        }
        while (this.parent.getColumn(this.getHeaderRightCol()).isEmpty()) {
            this.setHeaderRightCol(this.getHeaderRightCol() - 1);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new RecordIterator();
    }

    private Map<String, Integer> getColumnNameToIndexMap(int headerTopRow, int headerLeftCol, int headerBottomRow, int headerRightCol) {
        HashMap<String, Integer> columnsIndex = new HashMap<String, Integer>();
        List<List<Object>> headerValues = this.parent.getRange(headerTopRow, headerLeftCol, headerBottomRow, headerRightCol);
        ArrayList<String> nameHierarchy = new ArrayList<String>();
        for (int j = 0; j <= headerRightCol - headerLeftCol; ++j) {
            for (int i = 0; i <= headerBottomRow - headerTopRow; ++i) {
                String name;
                List<Object> rowValues;
                if (i >= headerValues.size() || (rowValues = headerValues.get(i)) == null || j >= rowValues.size() || (name = (String)rowValues.get(j)) == null || !nameHierarchy.isEmpty() && name.equals(nameHierarchy.get(nameHierarchy.size() - 1))) continue;
                nameHierarchy.add(name);
            }
            if (nameHierarchy.isEmpty()) continue;
            String fullColumnName = nameHierarchy.stream().map(String::trim).collect(Collectors.joining("&&"));
            columnsIndex.put(fullColumnName, j);
            nameHierarchy.clear();
        }
        return columnsIndex.size() > 0 ? columnsIndex : null;
    }

    private void buildTable(int startRow, int startCol, List<T> records) {
        this.parent.getDocument().batchUpdate(r -> {
            RecordTypeHelper.ColumnNamesTree columnNamesTree = this.typeHelper.getColumnNames();
            this.hTopRow = startRow;
            this.hLeftCol = startCol;
            this.hBottomRow = startRow + columnNamesTree.getHeight() - 1;
            this.hRightCol = startCol + columnNamesTree.getWidth() - 1;
            List<List<String>> stub = Collections.nCopies(columnNamesTree.getHeight(), Collections.nCopies(columnNamesTree.getWidth(), ""));
            this.parent.insertRows(InsertMethod.BEFORE, this.hTopRow, this.hLeftCol, stub);
            for (int i = 0; i < columnNamesTree.getHeight(); ++i) {
                List<RecordTypeHelper.ColumnNameNode> columnNodes = columnNamesTree.getForLevel(i);
                Row row = this.parent.getRow(startRow + i);
                for (RecordTypeHelper.ColumnNameNode columnNode : columnNodes) {
                    Cell cell = row.getCell(startCol + columnNode.getColumnIndex());
                    cell.setValue(columnNode.getName());
                    if (columnNode.getWidth() > 1 || columnNode.getHeight() > 1) {
                        this.parent.mergeCells(cell.getRowIndex(), cell.getColumnIndex(), cell.getRowIndex() + columnNode.getHeight() - 1, cell.getColumnIndex() + columnNode.getWidth() - 1);
                    }
                    this.typeHelper.formatHeaderCell(cell, columnNode.getFullName());
                }
            }
            this.insertRecords(InsertMethod.BEFORE, 0, records);
        });
    }

    private class RecordIterator
    implements Iterator<T> {
        private int index = 0;
        private int recordsCount;

        public RecordIterator() {
            this.recordsCount = Table.this.getBottomRow() - Table.this.hBottomRow;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.recordsCount;
        }

        @Override
        public T next() {
            return Table.this.getRecord(this.index++);
        }
    }
}

